/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.cache.map;

import com.xunlei.channel.sms.cache.CacheException;
import com.xunlei.channel.sms.cache.CacheService;
import com.xunlei.channel.sms.cache.vo.Cache;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HashMapCacheService
implements CacheService {
    private static final Logger logger = LoggerFactory.getLogger(HashMapCacheService.class);
    private Map<String, Map<String, String>> cacheMap = new ConcurrentHashMap<String, Map<String, String>>();
    private volatile ExpireThread expireThread;

    @Override
    public Collection<String> keys(String pattern) throws CacheException {
        logger.warn("HashMap not implements this pattern feature, just show all keys.");
        return this.cacheMap.keySet();
    }

    @Override
    public boolean existsCache(String cacheGroup, String cacheName) throws CacheException {
        Map<String, String> map = this.cacheMap.get(cacheGroup);
        return map != null && map.containsKey(cacheName);
    }

    @Override
    public Cache setCache(Cache cache) throws CacheException {
        Map<String, String> map = this.cacheMap.get(cache.getCacheGroup());
        if (map == null) {
            map = new ConcurrentHashMap<String, String>();
            this.cacheMap.put(cache.getCacheGroup(), map);
        }
        Cache old = this.getCache(cache.getCacheGroup(), cache.getCacheName());
        map.put(cache.getCacheName(), cache.getCacheValue());
        return old;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean setExpire(String cacheGroup, long timeout, TimeUnit timeUnit) throws CacheException {
        if (!this.cacheMap.containsKey(cacheGroup)) {
            return false;
        }
        if (this.expireThread == null) {
            HashMapCacheService hashMapCacheService = this;
            synchronized (hashMapCacheService) {
                if (this.expireThread == null) {
                    this.expireThread = new ExpireThread();
                }
            }
        }
        this.expireThread.putExpire(cacheGroup, timeout, timeUnit);
        return true;
    }

    @Override
    public Cache getCache(String cacheGroup, String cacheName) throws CacheException {
        String cacheValue = this.getCacheValue(cacheGroup, cacheName);
        if (cacheValue == null) {
            return null;
        }
        return new Cache(cacheGroup, cacheName, cacheValue);
    }

    @Override
    public Collection<Cache> getCachesByGroup(String cacheGroup) throws CacheException {
        Map<String, String> map = this.cacheMap.get(cacheGroup);
        if (map == null) {
            return null;
        }
        Set<Map.Entry<String, String>> entries = map.entrySet();
        HashSet<Cache> caches = new HashSet<Cache>(entries.size());
        for (Map.Entry<String, String> entry : entries) {
            String key = entry.getKey();
            String value = entry.getValue();
            Cache cache = new Cache(cacheGroup, key, value);
            caches.add(cache);
        }
        return caches;
    }

    @Override
    public Collection<String> getCacheValuesByGroup(String cacheGroup) throws CacheException {
        Map<String, String> map = this.cacheMap.get(cacheGroup);
        if (map == null) {
            return null;
        }
        return map.values();
    }

    @Override
    public String getCacheValue(String cacheGroup, String cacheName) throws CacheException {
        Map<String, String> map = this.cacheMap.get(cacheGroup);
        if (map == null) {
            return null;
        }
        return map.get(cacheName);
    }

    @Override
    public boolean clearCachesByGroup(String cacheGroup) throws CacheException {
        return this.cacheMap.remove(cacheGroup) != null;
    }

    @Override
    public boolean clearCachesByGroupPrefix(String cacheGroupPrefix) throws CacheException {
        Set<String> keySet = this.cacheMap.keySet();
        int size = 0;
        Iterator<String> iterator = keySet.iterator();
        while (iterator.hasNext()) {
            String key = iterator.next();
            if (!key.startsWith(cacheGroupPrefix)) continue;
            ++size;
            iterator.remove();
        }
        return size > 0;
    }

    class ExpireThread {
        private Map<String, Long> expireMap = new HashMap<String, Long>();

        ExpireThread() {
            new Thread(){

                @Override
                public void run() {
                    boolean interrupt = false;
                    while (!interrupt) {
                        Iterator iterator = ExpireThread.this.expireMap.entrySet().iterator();
                        while (iterator.hasNext()) {
                            Map.Entry entry = iterator.next();
                            Long expire = (Long)entry.getValue();
                            if (expire > System.currentTimeMillis()) continue;
                            Map remove = (Map)HashMapCacheService.this.cacheMap.remove(entry.getKey());
                            if (logger.isDebugEnabled()) {
                                logger.debug("Succeed remove exipre cache: {}", (Object)remove);
                            }
                            iterator.remove();
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            logger.error("", (Throwable)e);
                            interrupt = true;
                        }
                    }
                }
            }.start();
        }

        public void putExpire(String cacheGroup, long timeout, TimeUnit timeUnit) {
            long milliseconds = TimeUnit.MILLISECONDS.convert(timeout, timeUnit);
            this.expireMap.put(cacheGroup, System.currentTimeMillis() + milliseconds);
        }
    }
}

