/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.config.aop;

import com.xunlei.channel.sms.cache.CacheService;
import com.xunlei.channel.sms.cache.vo.Cache;
import com.xunlei.channel.sms.config.ConfigReloadable;
import com.xunlei.channel.sms.util.JacksonHelper;
import java.io.IOException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceCacheInterceptor<T>
implements ConfigReloadable {
    private static final Logger logger = LoggerFactory.getLogger(ServiceCacheInterceptor.class);
    private CacheService cacheService;
    private final String cacheGroup;
    private final Class<T> pojoType;

    public ServiceCacheInterceptor(Class<T> pojoType, String cacheGroup) {
        this.pojoType = pojoType;
        this.cacheGroup = cacheGroup;
    }

    public T getCacheById(ProceedingJoinPoint call, String id) throws Throwable {
        Object proceed;
        String cacheValue = null;
        try {
            cacheValue = this.cacheService.getCacheValue(this.cacheGroup, id);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        if (cacheValue != null) {
            try {
                Object found = JacksonHelper.convertJsonByClass((String)cacheValue, this.pojoType);
                if (logger.isDebugEnabled()) {
                    logger.debug("Got cache: {}", found);
                }
                if (found != null) {
                    return (T)found;
                }
            }
            catch (IOException e) {
                logger.error("", (Throwable)e);
            }
        }
        if ((proceed = call.proceed()) != null && this.pojoType.isInstance(proceed)) {
            try {
                String jsonString = JacksonHelper.getJsonString((Object)proceed);
                this.cacheService.setCache(new Cache(this.cacheGroup, id, jsonString));
                if (logger.isInfoEnabled()) {
                    logger.info("Setting cache: {}", proceed);
                }
            }
            catch (Exception e) {
                logger.error("", (Throwable)e);
            }
            return (T)proceed;
        }
        return null;
    }

    public void updateCacheById(ProceedingJoinPoint call, T cache, String id) throws Throwable {
        call.proceed();
        try {
            String jsonString = JacksonHelper.getJsonString(cache);
            this.cacheService.setCache(new Cache(this.cacheGroup, id, jsonString));
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
    }

    public CacheService getCacheService() {
        return this.cacheService;
    }

    public void setCacheService(CacheService cacheService) {
        this.cacheService = cacheService;
    }

    @Override
    public boolean reloadConfig() {
        try {
            this.cacheService.clearCachesByGroup(this.cacheGroup);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            return false;
        }
        return true;
    }
}

