/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.config.aop;

import com.xunlei.channel.sms.cache.CacheService;
import com.xunlei.channel.sms.cache.vo.Cache;
import com.xunlei.channel.sms.config.ConfigReloadable;
import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigServiceInterceptor
implements ConfigReloadable {
    private static final Logger logger = LoggerFactory.getLogger(ConfigServiceInterceptor.class);
    private static final String CONFIG_GROUP_PREFIX = "sms_config_group:";
    private CacheService cacheService;

    public String getConfig(ProceedingJoinPoint call, String configGroup, String configName) throws Throwable {
        String cacheGroup = ConfigServiceInterceptor.buildConfigGroup(configGroup);
        String value = null;
        try {
            value = this.cacheService.getCacheValue(cacheGroup, configName);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        if (value == null) {
            String configValue = null;
            try {
                configValue = (String)call.proceed();
                if (logger.isDebugEnabled()) {
                    logger.debug("Got configValue: {} by configGroup: {}, configName: {} from configService", new Object[]{configValue, configGroup, configName});
                }
            }
            catch (Throwable throwable) {
                logger.error("", throwable);
            }
            if (configValue == null) {
                return null;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Putting configGroup: {} configName: [} configValue: {} to cache.", new Object[]{configGroup, configName, configValue});
            }
            try {
                this.cacheService.setCache(new Cache(cacheGroup, configName, configValue));
            }
            catch (Exception e) {
                logger.error("", (Throwable)e);
            }
            return configValue;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Got config value: {} by ConfigGroup: {} and ConfigName: {}", new Object[]{value, cacheGroup, configName});
        }
        return value;
    }

    private static String buildConfigGroup(String configGroup) {
        return CONFIG_GROUP_PREFIX + configGroup;
    }

    public String setConfig(ProceedingJoinPoint proceedingJoinPoint, String configGroup, String configName, String configValue) {
        String proceed = null;
        try {
            proceed = (String)proceedingJoinPoint.proceed();
        }
        catch (Throwable throwable) {
            logger.error("", throwable);
        }
        String cacheGroup = ConfigServiceInterceptor.buildConfigGroup(configGroup);
        try {
            this.cacheService.setCache(new Cache(cacheGroup, configName, configValue));
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        return proceed;
    }

    public boolean clearCache(ProceedingJoinPoint proceedingJoinPoint) {
        try {
            proceedingJoinPoint.proceed();
        }
        catch (Throwable throwable) {
            logger.error("", throwable);
        }
        try {
            this.cacheService.clearCachesByGroupPrefix(CONFIG_GROUP_PREFIX);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        return true;
    }

    public CacheService getCacheService() {
        return this.cacheService;
    }

    public void setCacheService(CacheService cacheService) {
        this.cacheService = cacheService;
    }

    @Override
    public boolean reloadConfig() {
        try {
            this.cacheService.clearCachesByGroupPrefix(CONFIG_GROUP_PREFIX);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            return false;
        }
        return true;
    }
}

