/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.config;

import com.xunlei.channel.sms.service.ConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.NumberUtils;
import org.springframework.util.StringUtils;

@Component
public abstract class ConfigProvider {
    private static final Logger logger = LoggerFactory.getLogger(ConfigProvider.class);
    @Autowired
    protected ConfigService configService;
    private String configGroup;

    public ConfigProvider(String configGroup) {
        Assert.hasText((String)configGroup, (String)"ConfigGroup can't be null!");
        this.configGroup = configGroup;
    }

    public String getConfig(String configName) {
        return this.configService.getConfig(this.configGroup, configName);
    }

    public String getConfigOrDefault(String configName, String defaultValue) {
        String config = this.getConfig(configName);
        if (StringUtils.isEmpty((Object)config)) {
            return defaultValue;
        }
        return config;
    }

    public <T extends Number> T getConfigOrDefault(String configName, T defaultValue) {
        Number number;
        String configValue = this.getConfig(configName);
        if (StringUtils.isEmpty((Object)configValue)) {
            if (logger.isDebugEnabled()) {
                logger.debug("No config value found with group: {} and name: {}", (Object)this.configGroup, (Object)configName);
            }
            return defaultValue;
        }
        try {
            number = NumberUtils.parseNumber((String)configValue, defaultValue.getClass());
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            return defaultValue;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Got config from cache: {} with group: {} and name: {}", new Object[]{number, this.configGroup, configName});
        }
        return (T)number;
    }
}

