/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.util.ip;

import java.util.Collections;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public abstract class RemoteIpUtils {
    private static final Logger logger = LoggerFactory.getLogger(RemoteIpUtils.class);
    public static final String LOW_CASE_X_FORWARD = "x-forwarded-for";
    private static String lastHeaderNameOfXForwardFor = null;
    public static final String _255 = "(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)";
    public static final Pattern pattern = Pattern.compile("^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$");

    public static String longToIpV4(long longIp) {
        int octet3 = (int)((longIp >> 24) % 256L);
        int octet2 = (int)((longIp >> 16) % 256L);
        int octet1 = (int)((longIp >> 8) % 256L);
        int octet0 = (int)(longIp % 256L);
        return octet3 + "." + octet2 + "." + octet1 + "." + octet0;
    }

    public static long ipV4ToLong(String ip) {
        String[] octets = ip.split("\\.");
        return (Long.parseLong(octets[0]) << 24) + (long)(Integer.parseInt(octets[1]) << 16) + (long)(Integer.parseInt(octets[2]) << 8) + (long)Integer.parseInt(octets[3]);
    }

    public static boolean isIPv4Private(String ip) {
        long longIp = RemoteIpUtils.ipV4ToLong(ip);
        return longIp >= RemoteIpUtils.ipV4ToLong("10.0.0.0") && longIp <= RemoteIpUtils.ipV4ToLong("10.255.255.255") || longIp >= RemoteIpUtils.ipV4ToLong("172.16.0.0") && longIp <= RemoteIpUtils.ipV4ToLong("172.31.255.255") || longIp >= RemoteIpUtils.ipV4ToLong("192.168.0.0") && longIp <= RemoteIpUtils.ipV4ToLong("192.168.255.255");
    }

    public static boolean isIPv4Valid(String ip) {
        return pattern.matcher(ip).matches();
    }

    public static String getIpFromRequest(HttpServletRequest request) {
        String headerNameOfXForwardFor;
        String ip;
        if (request == null) {
            return null;
        }
        boolean found = false;
        if (logger.isDebugEnabled()) {
            RemoteIpUtils.logHeader(request);
        }
        if ((ip = request.getHeader(headerNameOfXForwardFor = RemoteIpUtils.getHeaderNameOfXForwardFor(request))) != null) {
            logger.debug("Found x-forwarded-for ip: {}", (Object)ip);
            StringTokenizer tokenizer = new StringTokenizer(ip, ",");
            while (tokenizer.hasMoreElements()) {
                ip = tokenizer.nextToken().trim();
                if (!RemoteIpUtils.isIPv4Valid(ip) || RemoteIpUtils.isIPv4Private(ip)) continue;
                found = true;
                break;
            }
        }
        if (!found) {
            ip = request.getRemoteAddr();
        }
        logger.info("Found remote ip: {}; Is from x-forwarded-for? {}", (Object)ip, (Object)found);
        return ip;
    }

    protected static String getHeaderNameOfXForwardFor(HttpServletRequest request) {
        if (lastHeaderNameOfXForwardFor != null && StringUtils.hasText((String)request.getHeader(lastHeaderNameOfXForwardFor))) {
            return lastHeaderNameOfXForwardFor;
        }
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            if (!LOW_CASE_X_FORWARD.equalsIgnoreCase(headerName)) continue;
            lastHeaderNameOfXForwardFor = headerName;
            return headerName;
        }
        return LOW_CASE_X_FORWARD;
    }

    private static void logHeader(HttpServletRequest httpServletRequest) {
        Enumeration headerNames = httpServletRequest.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            Enumeration headers = httpServletRequest.getHeaders(headerName);
            logger.debug("Header: {}={}", (Object)headerName, Collections.list(headers));
        }
    }
}

