/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.type.TypeBindings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class JacksonHelper {
    static final ThreadLocal<ObjectMapper> mapper = new ThreadLocal<ObjectMapper>(){

        @Override
        protected ObjectMapper initialValue() {
            return JacksonHelper.newConfiguredMapper();
        }
    };

    public static String getJsonString(Object o) {
        ObjectMapper mapper = JacksonHelper.newMapper();
        try {
            return mapper.writeValueAsString(o);
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }

    public static <T> T convertJsonByClass(String json, Class<T> clazz) throws IOException {
        ObjectMapper mapper = JacksonHelper.newMapper();
        return (T)mapper.readValue(json, clazz);
    }

    public static <T> List<T> convertJsonToListByRawType(String json, Class<T> clazz) throws IOException {
        ObjectMapper mapper = JacksonHelper.newMapper();
        JavaType listType = JacksonHelper.getListType(clazz);
        List list = (List)mapper.readValue(json, listType);
        return list;
    }

    public static <K, V> Map<K, V> convertJsonToMapByRawType(String json, Class<K> keyClass, Class<V> valueClass) throws IOException {
        ObjectMapper mapper = JacksonHelper.newMapper();
        JavaType listType = JacksonHelper.getMapType(keyClass, valueClass);
        Map list = (Map)mapper.readValue(json, listType);
        return list;
    }

    public static <K, V> Map<K, V> convertJsonToMap(String json, Class<K> keyClass, Class<V> valueClass) throws IOException {
        ObjectMapper mapper = JacksonHelper.newMapper();
        Map list = (Map)mapper.readValue(json, HashMap.class);
        return list;
    }

    public static JavaType getListType(Class<?> clazz) {
        ObjectMapper mapper = JacksonHelper.newMapper();
        JavaType javaType = mapper.constructType(clazz);
        TypeBindings bindings = TypeBindings.create(ArrayList.class, (JavaType)javaType);
        CollectionType collectionType = CollectionType.construct(ArrayList.class, (TypeBindings)bindings, null, null, (JavaType)javaType);
        return collectionType;
    }

    public static JavaType getMapType(Class<?> keyType, Class<?> valueType) {
        ObjectMapper mapper = JacksonHelper.newMapper();
        JavaType javaKeyType = mapper.constructType(keyType);
        JavaType javaValueType = mapper.constructType(valueType);
        TypeBindings bindings = TypeBindings.create(HashMap.class, (JavaType)javaKeyType, (JavaType)javaValueType);
        MapType mapType = MapType.construct(HashMap.class, (TypeBindings)bindings, null, null, (JavaType)javaKeyType, (JavaType)javaValueType);
        return mapType;
    }

    public static ObjectMapper newConfiguredMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        return objectMapper;
    }

    public static ObjectMapper newMapper() {
        return mapper.get();
    }
}

