/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class CollectionUtils {
    public static <T> List<List<T>> splitBySize(List<T> list, int maxSize) {
        if (list == null || list.size() == 0) {
            return new ArrayList<List<T>>();
        }
        if (list.size() <= maxSize) {
            return Collections.singletonList(list);
        }
        int size = list.size();
        int numberOfSegments = size / maxSize + (size % maxSize == 0 ? 0 : 1);
        int from = 0;
        int to = 0;
        ArrayList<List<T>> lists = new ArrayList<List<T>>(numberOfSegments);
        for (int i = 0; i < numberOfSegments; ++i) {
            if ((to += maxSize) > size) {
                to = size;
            }
            List<T> subList = list.subList(from, to);
            lists.add(subList);
            from += maxSize;
        }
        return lists;
    }
}

