/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.util;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NetWorkUtils {
    private static final Logger logger = LoggerFactory.getLogger(NetWorkUtils.class);

    public static InetAddress getInetAddress() throws UnknownHostException {
        return InetAddress.getLocalHost();
    }

    public static String getHostIp(InetAddress netAddress) {
        if (null == netAddress) {
            return null;
        }
        String ip = netAddress.getHostAddress();
        return ip;
    }

    public static String getWidthMachineNumber() throws UnknownHostException {
        return NetWorkUtils.getWidthMachineNumber(NetWorkUtils.maxWidth());
    }

    public static String getWidthMachineNumber(int maxWidth) throws UnknownHostException {
        String hostName = NetWorkUtils.getHostName();
        if (hostName == null) {
            return null;
        }
        int hash = hostName.hashCode();
        long unsignedHash = NetWorkUtils.getUnsignedInt(hash);
        String machineNo = unsignedHash + "";
        int least = maxWidth - machineNo.length();
        if (least > 0) {
            for (int i = 0; i < least; ++i) {
                machineNo = "0" + machineNo;
            }
        }
        return machineNo;
    }

    public static int stringHashCode(String string) {
        int h = 0;
        char[] value = string.toCharArray();
        if (h == 0 && value.length > 0) {
            char[] val = value;
            for (int i = 0; i < value.length; ++i) {
                h = 31 * h + val[i];
            }
        }
        return h;
    }

    public static int byteArrayHashCode(byte[] bytes) {
        int h = 0;
        if (h == 0 && bytes.length > 0) {
            byte[] val = bytes;
            for (int i = 0; i < bytes.length; ++i) {
                h = 31 * h + val[i];
            }
        }
        return h;
    }

    private static int maxWidth() {
        return "2147483647".length();
    }

    public static String getHostName() throws UnknownHostException {
        return NetWorkUtils.getHostName(NetWorkUtils.getInetAddress());
    }

    public static String getHostName(InetAddress netAddress) {
        if (null == netAddress) {
            return null;
        }
        String name = netAddress.getHostName();
        return name;
    }

    static String numericToTextFormat(byte[] src) {
        return (src[0] & 0xFF) + "." + (src[1] & 0xFF) + "." + (src[2] & 0xFF) + "." + (src[3] & 0xFF);
    }

    static String numericToMac(byte[] src) {
        if (src.length == 6) {
            StringBuilder builder = new StringBuilder();
            for (byte b : src) {
                builder.append(Integer.toHexString(b & 0xFF));
            }
            return builder.toString();
        }
        return null;
    }

    public static long getUnsignedInt(int x) {
        return (long)x & 0xFFFFFFFFL;
    }

    public static void main(String[] args) throws IOException {
        String hostName = NetWorkUtils.getHostName(NetWorkUtils.getInetAddress());
        System.out.println(hostName.hashCode());
        System.out.println(NetWorkUtils.stringHashCode(hostName));
        System.out.println(Integer.MAX_VALUE);
        System.out.println(NetWorkUtils.getWidthMachineNumber());
    }
}

