/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.util.security;

import com.xunlei.channel.sms.util.security.JCEUtil;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public abstract class AESCFBEncrypt {
    public static final String DEFAULT_CHARSET = "UTF-8";
    public static final String ALGORITHM = "AES/CFB/NoPADDING";

    public static String encryptToBase64(String key, String data) throws Exception {
        return AESCFBEncrypt.encryptToBase64(key, data, DEFAULT_CHARSET);
    }

    public static String encryptToBase64(String key, String data, String charset) throws Exception {
        byte[] bytes = data.getBytes(charset);
        byte[] encrypt = AESCFBEncrypt.encrypt(key, bytes);
        return Base64.encodeBase64String((byte[])encrypt);
    }

    public static String decryptFromBase64(String key, String base64Data) throws Exception {
        return AESCFBEncrypt.decryptFromBase64(key, base64Data, DEFAULT_CHARSET);
    }

    public static String decryptFromBase64(String key, String base64Data, String charset) throws Exception {
        byte[] bytes = Base64.decodeBase64((String)base64Data);
        byte[] decrypt = AESCFBEncrypt.decrypt(key, bytes);
        String origin = new String(decrypt, charset);
        return origin;
    }

    public static byte[] encrypt(String key, byte[] data) throws Exception {
        SecretKeySpec secretKeySpec = new SecretKeySpec(key.getBytes(DEFAULT_CHARSET), "AES");
        try {
            return AESCFBEncrypt.encrypt(secretKeySpec, data);
        }
        catch (InvalidKeyException e) {
            throw new InvalidKeyException(e.getMessage() + "; If key length greater than 16, must down load jce: http://www.oracle.com/technetwork/java/javase/downloads/jce8-download-2133166.html", e);
        }
    }

    public static byte[] decrypt(String key, byte[] encrypted) throws Exception {
        SecretKeySpec secretKeySpec = new SecretKeySpec(key.getBytes(DEFAULT_CHARSET), "AES");
        byte[] IV = new byte[16];
        byte[] cipherText = new byte[encrypted.length - 16];
        System.arraycopy(encrypted, 0, IV, 0, IV.length);
        System.arraycopy(encrypted, IV.length, cipherText, 0, cipherText.length);
        return AESCFBEncrypt.decrypt(secretKeySpec, IV, cipherText);
    }

    public static byte[] encrypt(SecretKey key, byte[] plaintext) throws Exception {
        SecureRandom rnd = new SecureRandom();
        byte[] IV = new byte[16];
        rnd.nextBytes(IV);
        IvParameterSpec IVSpec = new IvParameterSpec(IV);
        Cipher AESCipher = Cipher.getInstance(ALGORITHM);
        AESCipher.init(1, (Key)key, IVSpec);
        byte[] ciphertext = AESCipher.doFinal(plaintext);
        byte[] output = new byte[ciphertext.length + 16];
        System.arraycopy(IV, 0, output, 0, IV.length);
        System.arraycopy(ciphertext, 0, output, IV.length, ciphertext.length);
        return output;
    }

    public static byte[] decrypt(SecretKey key, byte[] IV, byte[] cipherText) throws Exception {
        Cipher AESCipher = Cipher.getInstance(ALGORITHM);
        IvParameterSpec IVSpec = new IvParameterSpec(IV);
        AESCipher.init(2, (Key)key, IVSpec);
        byte[] plaintext = AESCipher.doFinal(cipherText);
        return plaintext;
    }

    public static void main(String[] args) {
    }

    static {
        JCEUtil.removeCryptographyRestrictions();
    }
}

