/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.util.random;

import com.xunlei.channel.sms.util.Words;
import java.security.SecureRandom;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RandomUtils {
    private static final Logger logger = LoggerFactory.getLogger(RandomUtils.class);

    public static RandomStringUtils newRandomStringUtils(boolean secure) {
        return new RandomStringUtils(secure);
    }

    static class RandomFactory {
        private Class<? extends Random> randomClass;

        private RandomFactory() {
        }

        public static RandomFactory useUnsecure() {
            RandomFactory randomFactory = new RandomFactory();
            randomFactory.randomClass = Random.class;
            return randomFactory;
        }

        public static RandomFactory useSecure() {
            RandomFactory randomFactory = new RandomFactory();
            randomFactory.randomClass = SecureRandom.class;
            return randomFactory;
        }

        public Random newRandom() {
            try {
                return this.randomClass.newInstance();
            }
            catch (InstantiationException e) {
                logger.error("", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                logger.error("", (Throwable)e);
            }
            return new SecureRandom();
        }
    }

    public static class RandomStringUtils {
        RandomFactory randomFactory;

        public RandomStringUtils(boolean secure) {
            this.randomFactory = secure ? RandomFactory.useSecure() : RandomFactory.useUnsecure();
        }

        public String randomWordString(int length) {
            if (length <= 0) {
                return null;
            }
            return this.generateCharts(length, Words.words());
        }

        public String randomNumberString(int length) {
            if (length <= 0) {
                return null;
            }
            return this.generateCharts(length, Words.numbers());
        }

        private String generateCharts(int length, char[] chars) {
            byte[] verifierBytes = new byte[length];
            this.randomFactory.newRandom().nextBytes(verifierBytes);
            return this.getAuthorizationCodeString(verifierBytes, chars);
        }

        private String getAuthorizationCodeString(byte[] verifierBytes, char[] salts) {
            char[] chars = new char[verifierBytes.length];
            for (int i = 0; i < verifierBytes.length; ++i) {
                chars[i] = salts[(verifierBytes[i] & 0xFF) % salts.length];
            }
            return new String(chars);
        }
    }
}

