/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.util.ip;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public abstract class IpMaskUtils {
    private static final Logger logger = LoggerFactory.getLogger(IpMaskUtils.class);

    public static int convertIpAddressToInt(String ipString) throws UnknownHostException {
        Inet4Address inet4Address = (Inet4Address)InetAddress.getByName(ipString);
        byte[] ipBytes = inet4Address.getAddress();
        int ip = (ipBytes[0] & 0xFF) << 24 | (ipBytes[1] & 0xFF) << 16 | (ipBytes[2] & 0xFF) << 8 | (ipBytes[3] & 0xFF) << 0;
        return ip;
    }

    public static int[] parseSubnetConfig(String subnetConfig) {
        Assert.hasText((String)subnetConfig, (String)"Subnet config is null!");
        String[] subnetAndMask = subnetConfig.split("/");
        Integer ip = null;
        Integer bits = 0;
        if (subnetAndMask.length == 1) {
            try {
                ip = IpMaskUtils.convertIpAddressToInt(subnetAndMask[0]);
            }
            catch (Exception e) {
                logger.error("Illegal ip format: " + subnetConfig + ", message: " + e.getMessage(), (Throwable)e);
            }
        } else {
            try {
                ip = IpMaskUtils.convertIpAddressToInt(subnetAndMask[0]);
                bits = Integer.parseInt(subnetAndMask[1]);
            }
            catch (Exception e) {
                logger.error("Illegal ip format: " + subnetConfig + ", message: " + e.getMessage(), (Throwable)e);
            }
        }
        Assert.notNull((Object)ip, (String)"Illegal config format! format: 192.168.0.1 or 192.168.0.1/16");
        if (logger.isDebugEnabled()) {
            logger.debug("Parse subnetConfig: {} to subnet: {} bits: {}", new Object[]{subnetConfig, ip, bits});
        }
        return new int[]{ip, bits};
    }

    public static boolean isIpInMask(String ipString, String config) throws UnknownHostException {
        int ip = IpMaskUtils.convertIpAddressToInt(ipString);
        int[] subnetAndBits = IpMaskUtils.parseSubnetConfig(config);
        int subnet = subnetAndBits[0];
        int bits = subnetAndBits[1];
        return IpMaskUtils.isIpInMask(ip, subnet, bits);
    }

    public static boolean isIpInMask(int ip, int subnet, int bits) {
        boolean b;
        int mask = -1 << 32 - bits;
        boolean bl = b = (subnet & mask) == (ip & mask);
        if (logger.isDebugEnabled()) {
            logger.debug("({} & {})(subnet & mask): {}, ({} & {})(ip & mask): {}", new Object[]{Integer.toHexString(subnet), Integer.toHexString(mask), Integer.toHexString(subnet & mask), Integer.toHexString(ip), Integer.toHexString(mask), Integer.toHexString(ip & mask)});
        }
        return b;
    }
}

