/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.io.IOException;

public abstract class XmlHelper {
    static final ThreadLocal<XmlMapper> mapper = new ThreadLocal<XmlMapper>(){

        @Override
        protected XmlMapper initialValue() {
            return XmlHelper.newConfiguredMapper();
        }
    };

    public static String getXmlString(Object o) {
        XmlMapper mapper = XmlHelper.newMapper();
        try {
            return mapper.writeValueAsString(o);
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }

    public static <T> T convertXmlByClass(String xml, Class<T> clazz) throws IOException {
        XmlMapper mapper = XmlHelper.newMapper();
        return (T)mapper.readValue(xml, clazz);
    }

    public static XmlMapper newConfiguredMapper() {
        XmlMapper xmlMapper = new XmlMapper();
        xmlMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        xmlMapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        return xmlMapper;
    }

    public static XmlMapper newMapper() {
        return mapper.get();
    }
}

