/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.chain.user;

import com.google.common.base.Strings;
import com.xunlei.channel.sms.entity.SmsMessageRequest;
import com.xunlei.channel.sms.interceptor.PrioritySmsMessageInterceptor;
import com.xunlei.channel.sms.interceptor.result.InterceptResult;
import com.xunlei.pay.proxy.dto.request.GetUserPhoneById;
import com.xunlei.pay.proxy.dto.response.UserPhoneResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class SmsMessageUserIdInterceptor
extends PrioritySmsMessageInterceptor {
    public static final int PRIORITY = -9;
    private static final Logger logger = LoggerFactory.getLogger(SmsMessageUserIdInterceptor.class);

    public InterceptResult intercept(SmsMessageRequest message) {
        if (Strings.isNullOrEmpty((String)message.getMobile()) && Strings.isNullOrEmpty((String)message.getMobiles()) && Strings.isNullOrEmpty((String)message.getUserId())) {
            return InterceptResult.MOBILE_OR_USER_ID_EMPTY;
        }
        if (Strings.isNullOrEmpty((String)message.getMobile()) && Strings.isNullOrEmpty((String)message.getMobiles())) {
            String userIds = message.getUserId();
            return this.setMobilesByUserIds(message, userIds);
        }
        return InterceptResult.SUCCESS;
    }

    private InterceptResult setMobilesByUserIds(SmsMessageRequest message, String userIds) {
        String[] arrayIds = userIds.split(",");
        StringBuffer userPhones = new StringBuffer();
        String delimiter = "";
        int i = 0;
        for (String userId : arrayIds) {
            try {
                String userPhone = this.getMobileByUserId(userId);
                if (StringUtils.isEmpty((Object)userPhone)) {
                    logger.info("Could'nt found mobile by uid: {}", (Object)userId);
                    continue;
                }
                logger.info("Found mobile: {} by uid: {}", (Object)userPhone, (Object)userId);
                userPhones.append(delimiter).append(userPhone);
                delimiter = ",";
                ++i;
            }
            catch (Exception e) {
                logger.error("Error happened when getting phone by userId: " + userId + ", message: " + e.getMessage(), (Throwable)e);
                return (InterceptResult)InterceptResult.SYSTEM_ERROR;
            }
        }
        if (i < 1) {
            return InterceptResult.INTERCEPTOR_NOT_FOUND_MOBILE_BY_UID;
        }
        if (i == 1) {
            message.setMobile(userPhones.toString());
        }
        if (i > 1) {
            message.setMobiles(userPhones.toString());
        }
        return InterceptResult.SUCCESS;
    }

    protected String getMobileByUserId(String userId) {
        GetUserPhoneById userPhoneRequest = new GetUserPhoneById(userId);
        UserPhoneResponse response = (UserPhoneResponse)userPhoneRequest.request();
        return response.getPhone();
    }

    protected int priority() {
        return -9;
    }

    public static void main(String[] args) {
        StringBuffer userPhones = new StringBuffer();
        System.out.println(userPhones.toString().split(",").length);
    }
}

