/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.chain.sp;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.xunlei.channel.sms.constants.SmsType;
import com.xunlei.channel.sms.entity.BizInfo;
import com.xunlei.channel.sms.entity.SmsMessageRequest;
import com.xunlei.channel.sms.entity.SmsQueue;
import com.xunlei.channel.sms.entity.SpInfo;
import com.xunlei.channel.sms.interceptor.PrioritySmsMessageInterceptor;
import com.xunlei.channel.sms.interceptor.result.InterceptResult;
import com.xunlei.channel.sms.service.BizInfoService;
import com.xunlei.channel.sms.service.SmsQueueService;
import com.xunlei.channel.sms.service.SpInfoService;
import com.xunlei.channel.sms.util.JacksonHelper;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class SpecialSpInterceptor
extends PrioritySmsMessageInterceptor {
    public static final int PRIORITY = 0;
    public static final String INTERNATIONAL_INFO = "00";
    public static final String INTERNATIONAL = "INTERNATIONAL";
    private static final String RONGLIAN = "ronglian";
    private static final String VOICE = "voice";
    private static final Logger logger = LoggerFactory.getLogger(SpecialSpInterceptor.class);
    @Autowired
    private BizInfoService bizInfoService;
    @Autowired
    private SmsQueueService queueService;
    @Autowired
    private SpInfoService spInfoService;

    public InterceptResult intercept(SmsMessageRequest message) {
        String bizNo = message.getBizNo();
        if (Strings.isNullOrEmpty((String)bizNo)) {
            return InterceptResult.INTERCEPTOR_BIZ_NO_ERROR;
        }
        BizInfo bizInfo = this.bizInfoService.getBizInfoByBizNo(bizNo);
        if (bizInfo == null) {
            return InterceptResult.INTERCEPTOR_BIZ_INFO_NOT_FOUND;
        }
        String queueId = bizInfo.getQueueId();
        if (Strings.isNullOrEmpty((String)queueId)) {
            return InterceptResult.INTERCEPTOR_QUEUE_ID_NOT_FOUND;
        }
        List queueList = this.queueService.getSortedSmsQueueListByQueueId(queueId);
        if (CollectionUtils.isEmpty((Collection)queueList)) {
            return InterceptResult.INTERCEPTOR_QUEUE_NOT_FOUND;
        }
        Optional<SpInfo> bestSpInfoOp = Optional.absent();
        String spId = message.getSpId();
        if (!StringUtils.isEmpty((Object)spId)) {
            bestSpInfoOp = Optional.of((Object)this.spInfoService.getSpInfoBySpId(spId));
        }
        if (!(bestSpInfoOp = this.getSpecialSp(bestSpInfoOp, message, queueList)).isPresent()) {
            return InterceptResult.INTERCEPTOR_SP_INFO_NOT_FOUND;
        }
        SpInfo spInfo = (SpInfo)bestSpInfoOp.get();
        message.setSpId(spInfo.getSpId());
        message.setSpClass(spInfo.getSpClass());
        String smsType = spInfo.getSmsType();
        if (Strings.isNullOrEmpty((String)smsType)) {
            logger.warn("Could'nt found SmsType in SpInfo: {}", (Object)spInfo);
            return InterceptResult.INTERCEPTOR_SMS_TYPE_NOT_FOUND;
        }
        message.setSmsType(SmsType.valueOf((String)smsType));
        return InterceptResult.SUCCESS;
    }

    public Optional<SpInfo> getSpecialSp(Optional<SpInfo> bestSpInfoOp, SmsMessageRequest message, List<SmsQueue> queueList) {
        if (!bestSpInfoOp.isPresent() || !this.isSatisfySpecialSp((SpInfo)bestSpInfoOp.get(), message)) {
            bestSpInfoOp = this.findSpecialSp(message, queueList);
            if (bestSpInfoOp.isPresent()) {
                logger.info("get SpecialSp :" + bestSpInfoOp.get() + "SmsMessageRequest:" + message);
            } else {
                logger.error(" there are not the SpecialSp SmsMessageRequest:" + message);
            }
        }
        return bestSpInfoOp;
    }

    Optional<SpInfo> findSpecialSp(SmsMessageRequest message, List<SmsQueue> queueList) {
        List<SpInfo> voiceSpInfos;
        String signatureNumber = message.getSignatureNumber();
        String form = message.getForm();
        List spInfos = this.spInfoService.getSpInfos(Integer.MAX_VALUE, 0);
        if (!StringUtils.isEmpty((Object)signatureNumber)) {
            List<SpInfo> signatureSpInfos = this.getSignatureSpInfos(spInfos, signatureNumber);
            if (signatureSpInfos.isEmpty()) {
                logger.error("not find correct sp by signatureNumber :" + signatureNumber);
                return Optional.absent();
            }
            Optional<SpInfo> spInfoOptional = this.getBestSpFromQueueList(signatureSpInfos, queueList);
            if (spInfoOptional.isPresent()) {
                List<String> signatures = this.getSignatures((SpInfo)spInfoOptional.get());
                for (String signatureStr : signatures) {
                    if (!signatureStr.contains(signatureNumber)) continue;
                    message.setSignatureNumber(signatureStr);
                    break;
                }
            }
            return spInfoOptional;
        }
        if ((!StringUtils.isEmpty((Object)message.getExtJson()) || VOICE.equals(form)) && this.isSupportInternationalSms(message)) {
            voiceSpInfos = this.getVoiceSpInfos(spInfos, VOICE);
            if (voiceSpInfos.isEmpty()) {
                logger.error("not find correct sp by form :" + form);
                return Optional.absent();
            }
            for (SpInfo voiceSpInfo : voiceSpInfos) {
                if (!RONGLIAN.equals(voiceSpInfo.getSpClass())) continue;
                return Optional.of((Object)voiceSpInfo);
            }
        }
        if (VOICE.equals(form)) {
            voiceSpInfos = this.getVoiceSpInfos(spInfos, form);
            if (voiceSpInfos.isEmpty()) {
                logger.error("not find correct sp by form :" + form);
                return Optional.absent();
            }
            return this.getBestSpFromQueueList(voiceSpInfos, queueList);
        }
        if (this.isSupportInternationalSms(message)) {
            List<SpInfo> internationalSpInfos = this.getInternationalSpInfos(spInfos);
            if (internationalSpInfos.isEmpty()) {
                logger.error("not find correct sp by international :" + form);
                return Optional.absent();
            }
            return this.getBestSpByFee(internationalSpInfos);
        }
        return Optional.absent();
    }

    public boolean isSatisfySpecialSp(SpInfo spInfo, SmsMessageRequest message) {
        String signatureNumber = message.getSignatureNumber();
        String form = message.getForm();
        String formSp = spInfo.getSmsForm();
        if (!StringUtils.isEmpty((Object)signatureNumber)) {
            return Boolean.FALSE;
        }
        if ((!StringUtils.isEmpty((Object)message.getExtJson()) || VOICE.equals(form)) && this.isSupportInternationalSms(message)) {
            String spClass = spInfo.getSpClass();
            if (RONGLIAN.equals(spClass)) {
                logger.info("find the satisfid specialSp :" + spInfo);
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (VOICE.equals(form)) {
            if (formSp.contains(form)) {
                logger.info("find the satisfid specialSp :" + spInfo);
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (this.isSupportInternationalSms(message)) {
            String supportCarriers = spInfo.getSupportCarriers();
            if (StringUtils.isEmpty((Object)supportCarriers)) {
                return Boolean.FALSE;
            }
            if (supportCarriers.contains(INTERNATIONAL)) {
                logger.info("find the satisfid specialSp :" + spInfo);
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private Optional<SpInfo> getBestSpFromQueueList(List<SpInfo> spInfos, List<SmsQueue> queueList) {
        LinkedList bestSpInfos = Lists.newLinkedList();
        for (SpInfo spInfo : spInfos) {
            String spId = spInfo.getSpId();
            if (!this.isInQueueList(spId, queueList)) continue;
            bestSpInfos.add(spInfo);
        }
        if (bestSpInfos.isEmpty()) {
            if (logger.isDebugEnabled()) {
                logger.debug("there are not the BestSp ");
            }
            return this.getBestSpByFee(spInfos);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("getBestSp :" + bestSpInfos);
        }
        return this.getBestSpByFee(bestSpInfos);
    }

    private Optional<SpInfo> getBestSpByFee(List<SpInfo> spInfos) {
        Collections.sort(spInfos, new Comparator<SpInfo>(){

            @Override
            public int compare(SpInfo o1, SpInfo o2) {
                return o1.getFee().compareTo(o2.getFee());
            }
        });
        if (logger.isDebugEnabled()) {
            logger.debug("sort by fee :" + spInfos);
        }
        return Optional.of((Object)spInfos.get(0));
    }

    private boolean isInQueueList(String spId, List<SmsQueue> queueList) {
        if (StringUtils.isEmpty((Object)spId)) {
            return Boolean.FALSE;
        }
        for (SmsQueue smsQueue : queueList) {
            if (!spId.equals(smsQueue.getSpId())) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private List<SpInfo> getSignatureSpInfos(List<SpInfo> spInfos, String signatureNumber) {
        LinkedList signatureSpInfos = Lists.newLinkedList();
        for (SpInfo spInfo : spInfos) {
            List<String> signatures = this.getSignatures(spInfo);
            for (String signatureStr : signatures) {
                if (!signatureStr.contains(signatureNumber)) continue;
                logger.info("find Signatur sp :" + spInfo + " by signatureNumber " + signatureNumber);
                signatureSpInfos.add(spInfo);
            }
        }
        return signatureSpInfos;
    }

    private List<String> getSignatures(SpInfo spInfo) {
        List signaturesList = Lists.newLinkedList();
        try {
            String signature = spInfo.getSignature();
            if (!StringUtils.isEmpty((Object)signature)) {
                Map result = JacksonHelper.convertJsonToMap((String)signature, String.class, List.class);
                signaturesList = (List)result.get("value");
            }
            return signaturesList;
        }
        catch (IOException e) {
            logger.error("getSignatureSpInfos encount an error :" + e, (Object)e.getMessage());
            return signaturesList;
        }
    }

    private List<SpInfo> getVoiceSpInfos(List<SpInfo> spInfos, String form) {
        LinkedList voiceSpInfos = Lists.newLinkedList();
        try {
            for (SpInfo spInfo : spInfos) {
                String smsForm = spInfo.getSmsForm();
                if (StringUtils.isEmpty((Object)smsForm) || !VOICE.equals(form) || !smsForm.contains(form)) continue;
                voiceSpInfos.add(spInfo);
            }
            return voiceSpInfos;
        }
        catch (Exception e) {
            logger.error("getVoiceSpInfos encount an error :" + e, (Object)e.getMessage());
            return voiceSpInfos;
        }
    }

    private List<SpInfo> getInternationalSpInfos(List<SpInfo> spInfos) {
        LinkedList spInfoList = Lists.newLinkedList();
        for (SpInfo spInfo : spInfos) {
            String supportCarriers = spInfo.getSupportCarriers();
            if (StringUtils.isEmpty((Object)supportCarriers) || !supportCarriers.contains(INTERNATIONAL)) continue;
            spInfoList.add(spInfo);
        }
        return spInfoList;
    }

    private boolean isSupportInternationalSms(SmsMessageRequest message) {
        String mobile = message.getMobile();
        String mobiles = message.getMobiles();
        if (!StringUtils.isEmpty((Object)mobile)) {
            return this.isContainInternationalInfo(mobile);
        }
        if (!StringUtils.isEmpty((Object)mobiles)) {
            String[] mobileArray;
            for (String mobileNum : mobileArray = mobiles.split(",")) {
                if (!this.isContainInternationalInfo(mobileNum)) continue;
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    private boolean isContainInternationalInfo(String mobile) {
        String internationalInfo = mobile.substring(0, 2);
        if (INTERNATIONAL_INFO.equals(internationalInfo)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public int priority() {
        return 0;
    }
}

