/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.chain.risk;

import com.xunlei.channel.sms.entity.SmsMessageRequest;
import com.xunlei.channel.sms.interceptor.PrioritySmsMessageInterceptor;
import com.xunlei.channel.sms.interceptor.result.InterceptResult;
import com.xunlei.channel.sms.risk.RiskClient;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class ThirdPartyRiskClientInterceptor
extends PrioritySmsMessageInterceptor {
    public static final int PRIORITY = 3;
    private static final Logger logger = LoggerFactory.getLogger(ThirdPartyRiskClientInterceptor.class);
    @Autowired
    private Collection<RiskClient> riskClients;

    protected int priority() {
        return 3;
    }

    public InterceptResult intercept(SmsMessageRequest message) {
        if (message.getNeedRisk() == null || !message.getNeedRisk().booleanValue()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Ignored third party risk with needRisk parameter: {}", (Object)message.getNeedRisk());
            }
            return InterceptResult.SUCCESS;
        }
        if (CollectionUtils.isEmpty(this.riskClients)) {
            logger.info("No risk clients found when use ThirdPartyRiskClientInterceptor!");
            return InterceptResult.SUCCESS;
        }
        for (RiskClient riskClient : this.riskClients) {
            InterceptResult intercept = riskClient.intercept(message);
            if (intercept.isSuccess()) continue;
            return intercept;
        }
        return InterceptResult.SUCCESS;
    }

    public Collection<RiskClient> getRiskClients() {
        return this.riskClients;
    }

    public void setRiskClients(Collection<RiskClient> riskClients) {
        this.riskClients = riskClients;
    }
}

