/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.chain.sp;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.xunlei.channel.sms.chain.sp.carriers.CarriersStatementSupport;
import com.xunlei.channel.sms.chain.sp.carriers.CarriersUtils;
import com.xunlei.channel.sms.constants.SmsCarriers;
import com.xunlei.channel.sms.constants.SmsType;
import com.xunlei.channel.sms.entity.BizInfo;
import com.xunlei.channel.sms.entity.SmsMessageRequest;
import com.xunlei.channel.sms.entity.SmsQueue;
import com.xunlei.channel.sms.entity.SpInfo;
import com.xunlei.channel.sms.interceptor.PrioritySmsMessageInterceptor;
import com.xunlei.channel.sms.interceptor.result.InterceptResult;
import com.xunlei.channel.sms.service.BizInfoService;
import com.xunlei.channel.sms.service.SmsQueueService;
import com.xunlei.channel.sms.service.SpInfoService;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class SmsQueueInterceptor
extends PrioritySmsMessageInterceptor {
    public static final int PRIORITY = 0;
    private static final Logger logger = LoggerFactory.getLogger(SmsQueueInterceptor.class);
    @Autowired
    private BizInfoService bizInfoService;
    @Autowired
    private SmsQueueService queueService;
    @Autowired
    private SpInfoService spInfoService;
    @Autowired
    private CarriersStatementSupport carriersStatementSupport;

    public InterceptResult intercept(SmsMessageRequest message) {
        String bizNo = message.getBizNo();
        if (Strings.isNullOrEmpty((String)bizNo)) {
            return InterceptResult.INTERCEPTOR_BIZ_NO_ERROR;
        }
        BizInfo bizInfo = this.bizInfoService.getBizInfoByBizNo(bizNo);
        if (bizInfo == null) {
            return InterceptResult.INTERCEPTOR_BIZ_INFO_NOT_FOUND;
        }
        String queueId = bizInfo.getQueueId();
        if (Strings.isNullOrEmpty((String)queueId)) {
            return InterceptResult.INTERCEPTOR_QUEUE_ID_NOT_FOUND;
        }
        List queueList = this.queueService.getSortedSmsQueueListByQueueId(queueId);
        if (CollectionUtils.isEmpty((Collection)queueList)) {
            return InterceptResult.INTERCEPTOR_QUEUE_NOT_FOUND;
        }
        Optional<SpInfo> bestSpInfoOp = this.findBestSpInfo(message, queueList);
        if (!bestSpInfoOp.isPresent()) {
            return InterceptResult.SUCCESS;
        }
        SpInfo spInfo = (SpInfo)bestSpInfoOp.get();
        message.setSpId(spInfo.getSpId());
        message.setSpClass(spInfo.getSpClass());
        String smsType = spInfo.getSmsType();
        if (Strings.isNullOrEmpty((String)smsType)) {
            logger.warn("Could'nt found SmsType in SpInfo: {}", (Object)spInfo);
            return InterceptResult.INTERCEPTOR_SMS_TYPE_NOT_FOUND;
        }
        message.setSmsType(SmsType.valueOf((String)smsType));
        return InterceptResult.SUCCESS;
    }

    private Optional<SpInfo> findBestSpInfo(SmsMessageRequest message, List<SmsQueue> queueList) {
        for (SmsQueue smsQueue : queueList) {
            Optional<SpInfo> found = this.findSpInfoByMessageInQueue(message, smsQueue);
            if (found.isPresent()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Use sp: {} from queue: {} by mobile: {}", new Object[]{found.get(), smsQueue, Strings.nullToEmpty((String)message.getMobile()) + Strings.nullToEmpty((String)message.getMobiles())});
                }
                return found;
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug("Could'nt found sp in queue: {}", (Object)smsQueue);
        }
        if (logger.isInfoEnabled()) {
            logger.info("Could'nt found spInfo by bizNo: {}, queues: {}", (Object)message.getBizNo(), queueList);
        }
        return Optional.absent();
    }

    private Optional<SpInfo> findSpInfoByMessageInQueue(SmsMessageRequest message, SmsQueue smsQueue) {
        String[] mobileArray;
        String spId = smsQueue.getSpId();
        SpInfo spInfo = this.spInfoService.getSpInfoBySpId(spId);
        if (spInfo == null || !spInfo.getAvailable().booleanValue()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Found not available sp: {}", (Object)spInfo);
            }
            return Optional.absent();
        }
        String supportCarriers = spInfo.getSupportCarriers();
        SmsCarriers[] smsCarriersArray = CarriersUtils.parseCarriers(supportCarriers);
        if (smsCarriersArray == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Found no carriers sp: {}", (Object)spInfo);
            }
            return Optional.absent();
        }
        if (SmsCarriers.isSupportAll((SmsCarriers[])smsCarriersArray)) {
            return Optional.of((Object)spInfo);
        }
        if (message.getMobile() != null) {
            if (this.supportMobile(message.getMobile(), smsCarriersArray)) {
                return Optional.of((Object)spInfo);
            }
            return Optional.absent();
        }
        String mobiles = message.getMobiles();
        for (String mobile : mobileArray = mobiles.split(",")) {
            if (this.supportMobile(mobile, smsCarriersArray)) continue;
            return Optional.absent();
        }
        return Optional.of((Object)spInfo);
    }

    private boolean supportMobile(String mobile, SmsCarriers[] smsCarriersArray) {
        Optional<SmsCarriers> carriersOp = this.carriersStatementSupport.findCarriersByMobile(mobile);
        if (!carriersOp.isPresent()) {
            if (SmsCarriers.isMainLandCarriers((String)mobile) && SmsCarriers.isSupportAllMainLandCarriers((SmsCarriers[])smsCarriersArray)) {
                logger.warn("Statement of mobile: {} is not record in our db! And because sp support all mainland carriers so use current sp.", (Object)mobile);
                return true;
            }
            logger.warn("Could'nt found carriers by mobile: {}", (Object)mobile);
            return false;
        }
        SmsCarriers smsCarriers = (SmsCarriers)carriersOp.get();
        for (SmsCarriers carriers : smsCarriersArray) {
            if (!smsCarriers.equals((Object)carriers)) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("Found carrier: {} by mobile: {}", (Object)smsCarriers, (Object)mobile);
            }
            return true;
        }
        return false;
    }

    public int priority() {
        return 0;
    }
}

