/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.chain.risk.limiter.mobile;

import com.xunlei.channel.sms.chain.risk.limiter.SmsMessageSingleFieldLimiter;
import com.xunlei.channel.sms.chain.risk.limiter.mobile.MobileLimiterConfig;
import com.xunlei.channel.sms.entity.SmsMessageRequest;
import com.xunlei.channel.sms.interceptor.result.InterceptResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class SmsMessageMobileLimiter
extends SmsMessageSingleFieldLimiter {
    private static final String CACHE_GROUP_PREFIX = "risk:mobile:";
    @Autowired
    private MobileLimiterConfig mobileLimiterConfig;

    @Override
    protected int getConfigOfLimiterTimes() {
        return this.mobileLimiterConfig.getLimiterTimes();
    }

    @Override
    protected Long getConfigOfLimiterTimeOut() {
        return this.mobileLimiterConfig.getLimiterTimeOut();
    }

    @Override
    protected String getCacheGroupIfMatchEvent(SmsMessageRequest message) {
        String mobile;
        if (message == null || StringUtils.isEmpty((Object)(mobile = message.getMobile()))) {
            return null;
        }
        return CACHE_GROUP_PREFIX + mobile;
    }

    @Override
    protected InterceptResult interceptResult(SmsMessageRequest message) {
        return InterceptResult.INTERCEPTOR_MOBILE_LIMITER;
    }
}

