/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.chain.sign;

import com.google.common.base.Strings;
import com.xunlei.channel.sms.entity.AbstractSmsMessage;
import com.xunlei.channel.sms.entity.BizInfo;
import com.xunlei.channel.sms.entity.SmsMessageRequest;
import com.xunlei.channel.sms.interceptor.SmsMessageInterceptor;
import com.xunlei.channel.sms.interceptor.result.InterceptResult;
import com.xunlei.channel.sms.service.BizInfoService;
import com.xunlei.channel.sms.util.reflect.ReflectionUtils;
import com.xunlei.channel.sms.util.sign.SignUtils;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;

public class SmsMessageCheckSignInterceptor
implements SmsMessageInterceptor<SmsMessageInterceptor> {
    @Autowired
    private BizInfoService bizInfoService;

    public InterceptResult intercept(SmsMessageRequest message) {
        String bizNo = message.getBizNo();
        if (Strings.isNullOrEmpty((String)bizNo)) {
            return InterceptResult.INTERCEPTOR_BIZ_NO_ERROR;
        }
        String signMsg = message.getSignMsg();
        if (Strings.isNullOrEmpty((String)signMsg)) {
            return InterceptResult.INTERCEPTOR_NO_SIGN_MESSAGE;
        }
        BizInfo bizInfo = this.bizInfoService.getBizInfoByBizNo(bizNo);
        if (bizInfo == null) {
            return InterceptResult.INTERCEPTOR_BIZ_INFO_NOT_FOUND;
        }
        String bizKey = bizInfo.getBizKey();
        if (Strings.isNullOrEmpty((String)bizKey)) {
            return InterceptResult.INTERCEPTOR_BIZ_INFO_NOT_FOUND;
        }
        Map<String, String> signParams = this.getSignParams(message);
        boolean match = SignUtils.checkSign((String)signMsg, signParams, this.ignoreFieldSet(), (String)bizKey, (String)"UTF-8", (boolean)true);
        if (!match) {
            return InterceptResult.INTERCEPTOR_CHECK_SIGN_ERROR;
        }
        return InterceptResult.SUCCESS;
    }

    private Map<String, String> getSignParams(SmsMessageRequest message) {
        Map map = ReflectionUtils.convertObjectFieldsToMap((Object)message);
        Map mapSuper = ReflectionUtils.convertObjectFieldsToMap((Object)message, AbstractSmsMessage.class);
        map.putAll(mapSuper);
        return map;
    }

    private Set<String> ignoreFieldSet() {
        HashSet<String> ignoreFieldSet = new HashSet<String>();
        ignoreFieldSet.add("signMsg");
        ignoreFieldSet.add("requestIp");
        return ignoreFieldSet;
    }

    public int compareTo(SmsMessageInterceptor o) {
        return -1;
    }
}

