/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.chain.risk.limiter.device;

import com.xunlei.channel.sms.chain.risk.limiter.SmsMessageSingleFieldLimiter;
import com.xunlei.channel.sms.chain.risk.limiter.device.DeviceLimiterConfig;
import com.xunlei.channel.sms.entity.SmsMessageRequest;
import com.xunlei.channel.sms.interceptor.result.InterceptResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class SmsMessageDeviceLimiter
extends SmsMessageSingleFieldLimiter {
    private static final String CACHE_GROUP_DEVICE_PREFIX = "risk:device:";
    @Autowired
    private DeviceLimiterConfig ipLimiterConfig;

    @Override
    protected int getConfigOfLimiterTimes() {
        return this.ipLimiterConfig.getDeviceLimiterTimes();
    }

    @Override
    protected Long getConfigOfLimiterTimeOut() {
        return this.ipLimiterConfig.getDeviceLimiterTimeOut();
    }

    @Override
    protected String getCacheGroupIfMatchEvent(SmsMessageRequest message) {
        String deviceId;
        if (message == null || StringUtils.isEmpty((Object)(deviceId = message.getDeviceId()))) {
            return null;
        }
        return CACHE_GROUP_DEVICE_PREFIX + deviceId;
    }

    @Override
    protected InterceptResult interceptResult(SmsMessageRequest message) {
        return InterceptResult.INTERCEPTOR_DEVICE_LIMITER;
    }
}

