/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.chain.merchant;

import com.xunlei.channel.sms.entity.SmsMessageRequest;
import com.xunlei.channel.sms.interceptor.PrioritySmsMessageInterceptor;
import com.xunlei.channel.sms.interceptor.result.InterceptResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MerchantsSignatureInterceptor
extends PrioritySmsMessageInterceptor {
    public static final String SIGN_START = "\u3010";
    public static final String SIGN_END = "\u3011";
    private static final Logger logger = LoggerFactory.getLogger(MerchantsSignatureInterceptor.class);

    protected int priority() {
        return 0;
    }

    public InterceptResult intercept(SmsMessageRequest message) {
        int start;
        int end;
        String content;
        String finalContent = content = message.getContent();
        if (content.startsWith(SIGN_START) && (end = content.indexOf(SIGN_END)) > 1 && end < content.length() - 1) {
            finalContent = content.substring(end + 1);
        }
        if (finalContent.endsWith(SIGN_END) && (start = finalContent.lastIndexOf(SIGN_START)) > 1) {
            finalContent = finalContent.substring(0, start);
        }
        if (!content.equals(finalContent)) {
            logger.warn("Replace content: {} to: {}, message: {}", new Object[]{content, finalContent, message});
        } else if (logger.isDebugEnabled()) {
            logger.debug("Content does'nt need to replace: {}", (Object)content);
        }
        message.setContent(finalContent);
        return InterceptResult.SUCCESS;
    }
}

