/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.chain.risk.limiter.ip;

import com.xunlei.channel.sms.chain.risk.limiter.SmsMessageSingleFieldLimiter;
import com.xunlei.channel.sms.chain.risk.limiter.ip.IpLimiterConfig;
import com.xunlei.channel.sms.entity.SmsMessageRequest;
import com.xunlei.channel.sms.interceptor.result.InterceptResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class SmsMessageIpLimiter
extends SmsMessageSingleFieldLimiter {
    private static final String CACHE_GROUP_IP_PREFIX = "risk:ip:";
    @Autowired
    private IpLimiterConfig ipLimiterConfig;

    @Override
    protected int getConfigOfLimiterTimes() {
        return this.ipLimiterConfig.getLimiterTimes();
    }

    @Override
    protected Long getConfigOfLimiterTimeOut() {
        return this.ipLimiterConfig.getLimiterTimeOut();
    }

    @Override
    protected String getCacheGroupIfMatchEvent(SmsMessageRequest message) {
        String userIp;
        if (message == null || StringUtils.isEmpty((Object)(userIp = message.getUserIp()))) {
            return null;
        }
        return CACHE_GROUP_IP_PREFIX + userIp;
    }

    @Override
    protected InterceptResult interceptResult(SmsMessageRequest message) {
        return InterceptResult.INTERCEPTOR_IP_LIMITER;
    }
}

