/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.chain.sp;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.xunlei.channel.sms.entity.ReturnResult;
import com.xunlei.channel.sms.entity.SmsMessageRequest;
import com.xunlei.channel.sms.interceptor.SmsMessageInterceptor;
import com.xunlei.channel.sms.interceptor.result.InterceptResult;
import com.xunlei.channel.sms.util.JacksonHelper;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class SpParamterCheckInterceptor
implements SmsMessageInterceptor<SmsMessageInterceptor> {
    private static final Logger logger = LoggerFactory.getLogger(SpParamterCheckInterceptor.class);
    private static final String EXT_JSON_RONGLIAN = "ronglian";
    private static final String RONGLIAN = "ronglian";
    private static final String ZERO = "0";
    private static final int MIN_LEN = 4;
    private static final int MAX_LEN = 8;

    public InterceptResult intercept(SmsMessageRequest message) {
        String spClass = message.getSpClass();
        if (StringUtils.isEmpty((Object)spClass)) {
            logger.error("Sp con't null or Empty and message:{}", (Object)message);
            return (InterceptResult)ReturnResult.SYSTEM_ERROR;
        }
        if ("ronglian".equals(spClass)) {
            return this.rongLianSpParamterCheck(message);
        }
        return InterceptResult.SUCCESS;
    }

    public int compareTo(SmsMessageInterceptor o) {
        return 0;
    }

    private InterceptResult rongLianSpParamterCheck(SmsMessageRequest message) {
        block11: {
            String extJson = message.getExtJson();
            String content = message.getContent();
            Optional<Boolean> needCodeOpt = Optional.ofNullable(message.getNeedCode());
            Boolean needCode = needCodeOpt.orElse(false);
            Optional<Integer> codeLenOpt = Optional.ofNullable(message.getCodeLen());
            Integer codeLen = codeLenOpt.orElse(new Integer(6));
            if (StringUtils.isEmpty((Object)extJson)) {
                return InterceptResult.SUCCESS;
            }
            try {
                Map JextJson = JacksonHelper.convertJsonToMapByRawType((String)extJson, String.class, String.class);
                String state = (String)JextJson.get("ronglian");
                if (StringUtils.isEmpty((Object)state)) {
                    return InterceptResult.PARAMETER_ERROR;
                }
                if (ZERO.equals(state)) {
                    if (needCode.booleanValue() && !content.matches("\\{}")) {
                        return InterceptResult.CONTENT_ERROR_FORMAT;
                    }
                    if (needCode.booleanValue() && 4 <= codeLen && codeLen <= 8) {
                        return InterceptResult.SUCCESS;
                    }
                    if (needCode.booleanValue() && (4 > codeLen || codeLen > 8)) {
                        logger.warn("message:{},the length of content is too long or too short", (Object)message);
                        return InterceptResult.CONTENT_ERROR_FORMAT;
                    }
                    if (StringUtils.isEmpty((Object)content)) {
                        logger.warn("message:{},content is null", (Object)message);
                        return InterceptResult.PARAMETER_ERROR;
                    }
                    if (!content.matches("\\w{4,8}")) {
                        logger.warn("message:{},content is not format", (Object)message);
                        return InterceptResult.CONTENT_ERROR_FORMAT;
                    }
                    break block11;
                }
                return InterceptResult.PARAMETER_ERROR;
            }
            catch (Exception ex) {
                if (ex instanceof JsonProcessingException) {
                    logger.error("Jason :{} ,format is error :" + ex.getMessage(), (Object)extJson, (Object)ex);
                    return InterceptResult.PARAMETER_ERROR;
                }
                logger.error("rongLianSpParamterCheck encounter Error:" + ex.getMessage(), (Throwable)ex);
                return (InterceptResult)InterceptResult.SYSTEM_ERROR;
            }
        }
        return InterceptResult.SUCCESS;
    }
}

