/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.chain.risk.limiter;

import com.google.common.base.Strings;
import com.xunlei.channel.sms.cache.CacheException;
import com.xunlei.channel.sms.cache.CacheService;
import com.xunlei.channel.sms.cache.CacheServiceProvider;
import com.xunlei.channel.sms.cache.vo.Cache;
import com.xunlei.channel.sms.entity.SmsMessageRequest;
import com.xunlei.channel.sms.event.SmsMessageAcceptEvent;
import com.xunlei.channel.sms.interceptor.PrioritySmsMessageInterceptor;
import com.xunlei.channel.sms.interceptor.result.InterceptResult;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class SmsMessageSingleFieldLimiter
extends PrioritySmsMessageInterceptor
implements SmsMessageAcceptEvent {
    public static final int PRIORITY = 2;
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String CACHE_NAME_SIZE = "size";
    @Autowired
    private CacheServiceProvider cacheServiceProvider;

    public boolean acceptedSmsMessage(SmsMessageRequest message) throws CacheException {
        String ipSize;
        if (message.getNeedRisk() == null || !message.getNeedRisk().booleanValue()) {
            return true;
        }
        CacheService cacheService = this.cacheServiceProvider.getCacheService();
        String cacheGroup = this.getCacheGroupIfMatchEvent(message);
        if (cacheGroup == null) {
            return true;
        }
        Cache cache = cacheService.getCache(cacheGroup, CACHE_NAME_SIZE);
        if (cache == null || Strings.isNullOrEmpty((String)(ipSize = cache.getCacheValue()))) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Initializing limiter cache: {}", (Object)cacheGroup);
            }
            this.newCache(cacheGroup, CACHE_NAME_SIZE, 1);
            return true;
        }
        long ipSizeLong = Long.valueOf(ipSize) + 1L;
        cache.setCacheValue(ipSizeLong + "");
        cacheService.setCache(cache);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Increase times: {} cache: {}", (Object)ipSizeLong, (Object)cacheGroup);
        }
        return true;
    }

    public InterceptResult intercept(SmsMessageRequest message) {
        if (message.getNeedRisk() == null || !message.getNeedRisk().booleanValue()) {
            return InterceptResult.SUCCESS;
        }
        Long size = this.getSizeInCache(message);
        if (size == null) {
            return InterceptResult.SUCCESS;
        }
        int ipLimiterTimes = this.getConfigOfLimiterTimes();
        if (size >= (long)ipLimiterTimes) {
            InterceptResult interceptResult = this.interceptResult(message);
            this.logger.warn("Intercepted a message with size: {}. message: {}, result: {}", new Object[]{size, message, interceptResult});
            return interceptResult;
        }
        return InterceptResult.SUCCESS;
    }

    private Long getSizeInCache(SmsMessageRequest message) {
        String sizeString;
        Cache cache;
        CacheService cacheService = this.cacheServiceProvider.getCacheService();
        String cacheGroup = this.getCacheGroupIfMatchEvent(message);
        if (cacheGroup == null) {
            this.logger.warn("No cache group found in message: {}", (Object)message);
            return null;
        }
        try {
            cache = cacheService.getCache(cacheGroup, CACHE_NAME_SIZE);
        }
        catch (CacheException e) {
            this.logger.error("", (Throwable)e);
            return null;
        }
        if (cache == null || Strings.isNullOrEmpty((String)(sizeString = cache.getCacheValue()))) {
            return null;
        }
        Long size = Long.valueOf(sizeString);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Getting cache size: {}", (Object)size);
        }
        return size;
    }

    private void newCache(String cacheGroup, String cacheName, int value) throws CacheException {
        CacheService cacheService = this.cacheServiceProvider.getCacheService();
        Cache cache = new Cache(cacheGroup, cacheName, value + "");
        cacheService.setCache(cache);
        Long ipLimiterTimeOut = this.getConfigOfLimiterTimeOut();
        cacheService.setExpire(cacheGroup, ipLimiterTimeOut.longValue(), TimeUnit.SECONDS);
    }

    protected int priority() {
        return 2;
    }

    protected abstract int getConfigOfLimiterTimes();

    protected abstract Long getConfigOfLimiterTimeOut();

    protected abstract String getCacheGroupIfMatchEvent(SmsMessageRequest var1);

    protected abstract InterceptResult interceptResult(SmsMessageRequest var1);
}

