/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.chain.ip;

import com.xunlei.channel.sms.entity.BizIpInfo;
import com.xunlei.channel.sms.entity.SmsMessageRequest;
import com.xunlei.channel.sms.interceptor.PrioritySmsMessageInterceptor;
import com.xunlei.channel.sms.interceptor.result.InterceptResult;
import com.xunlei.channel.sms.service.BizIpInfoService;
import com.xunlei.channel.sms.util.ip.IpMaskUtils;
import java.net.UnknownHostException;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class IpSafeInterceptor
extends PrioritySmsMessageInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(IpSafeInterceptor.class);
    public static final int PRIORITY = -10;
    @Autowired
    private BizIpInfoService bizIpInfoService;

    protected int priority() {
        return -10;
    }

    public InterceptResult intercept(SmsMessageRequest message) {
        String remoteIp = message.getRequestIp();
        if (StringUtils.isEmpty((Object)remoteIp)) {
            logger.warn("Could'nt found remote ip by request: {}", (Object)message.getUniqueNumber());
            return InterceptResult.SUCCESS;
        }
        String bizNo = message.getBizNo();
        Collection bizIpInfoCollection = this.bizIpInfoService.findBizIpInfoCollection(bizNo);
        if (CollectionUtils.isEmpty((Collection)bizIpInfoCollection)) {
            logger.warn("Not present safe ip config with bizNo: {}", (Object)bizNo);
            return InterceptResult.SUCCESS;
        }
        boolean isMatch = this.matchIp(remoteIp, bizIpInfoCollection);
        if (isMatch) {
            logger.info("Found match ip: {} in bizNo: {}", (Object)remoteIp, (Object)bizNo);
            return InterceptResult.SUCCESS;
        }
        logger.warn("Unsafe ip: {} in bizNo: {}", (Object)remoteIp, (Object)bizNo);
        return InterceptResult.MISMATCH_SAFE_IP;
    }

    private boolean matchIp(String remoteIp, Collection<BizIpInfo> bizIpInfoCollection) {
        for (BizIpInfo bizIpInfo : bizIpInfoCollection) {
            boolean b = this.matchOneIpConfig(remoteIp, bizIpInfo);
            if (!b) continue;
            return true;
        }
        return false;
    }

    private boolean matchOneIpConfig(String remoteIp, BizIpInfo bizIpInfo) {
        String ipConfig;
        if (bizIpInfo == null || StringUtils.isEmpty((Object)(ipConfig = bizIpInfo.getIpConfig()))) {
            return false;
        }
        try {
            boolean ipInMask = IpMaskUtils.isIpInMask((String)remoteIp, (String)ipConfig);
            if (ipInMask) {
                logger.info("Match ip: {} with config: {}", (Object)remoteIp, (Object)ipConfig);
                return true;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Mismatch ip: {} with config: {}", (Object)remoteIp, (Object)ipConfig);
            }
        }
        catch (UnknownHostException e) {
            logger.error("", (Throwable)e);
        }
        return false;
    }
}

