/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.server.usercentre.util;

import com.xunlei.server.usercentre.util.StringTools;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Validator {
    private static final Pattern pcharanddigit = Pattern.compile("[0-9a-zA-Z_]+");
    private static final Pattern pdatey_m_d = Pattern.compile("\\d{4}\\-\\d{2}\\-\\d{2}");
    private static final Pattern pip4 = Pattern.compile("\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}");
    private static final Pattern pdomain = Pattern.compile("[a-zA-Z0-9-\\u4e00-\\u9fa5]+(.[a-zA-Z0-9-]+)+");
    private static final Pattern pinteger = Pattern.compile("[+-]?\\d+");
    private static final Pattern pnumber = Pattern.compile("\\d+");
    private static final Pattern purl = Pattern.compile("(http:\\/\\/)?+[a-z0-9-]+(\\.[a-z0-9-]+)+(\\/[\\w-\\.\\\\/?%&=]*)?");
    private static final Pattern pemail = Pattern.compile("^[\\w]+[\\w-\\.]*\\@[\\w]+[\\w\\.-]*[\\w]+$");
    private static final Pattern pserialno = Pattern.compile("[a-z0-9-_]+");
    private static final Pattern pdateymd = Pattern.compile("\\d{8}");
    private static final Pattern pidcardno = Pattern.compile("^\\d{17}[xX0-9]{1}|\\d{15}$");
    private static final String DOMAINS = ".com.cn|.net.cn|.org.cn|.gov.cn|.com|.net|.tv|.gd|.org|.cc|.vc|.mobi|.cd|.info|.name|.asia|.hk|.me|.la|.sh|.biz|.li|.kr|.in|.us|.io|.ac.cn|.bj.cn|.sh.cn|.tj.cn|.cq.cn|.he.cn|.sx.cn|.nm.cn|.ln.cn|.jl.cn|.hl.cn|.js.cn|.zj.cn|.ah.cn|.fj.cn|.jx.cn|.sd.cn|.ha.cn|.hb.cn|.hn.cn|.gd.cn|.gx.cn|.hi.cn|.sc.cn|.gz.cn|.yn.cn|.xz.cn|.sn.cn|.gs.cn|.qh.cn|.nx.cn|.xj.cn|.tw.cn|.hk.cn|.mo.cn|.cn";
    private static final int[] areas = new int[]{11, 12, 13, 14, 15, 21, 22, 23, 31, 32, 33, 34, 35, 36, 37, 41, 42, 43, 44, 45, 46, 50, 51, 52, 53, 54, 61, 62, 63, 64, 65, 71, 81, 82, 91};

    public static boolean isInteger(String s) {
        if (Validator.isEmpty(s)) {
            return false;
        }
        Matcher m = pinteger.matcher(s);
        return m.matches();
    }

    public static boolean isNumber(String s) {
        if (Validator.isEmpty(s)) {
            return false;
        }
        Matcher m = pnumber.matcher(s);
        return m.matches();
    }

    public static boolean isURL(String str) {
        if (Validator.isEmpty(str)) {
            return false;
        }
        Matcher m = purl.matcher(str);
        return m.matches();
    }

    public static boolean isEmail(String str) {
        if (Validator.isEmpty(str)) {
            return false;
        }
        str = str.toLowerCase().trim();
        Matcher m = pemail.matcher(str);
        return m.matches();
    }

    public static boolean isSerialNo(String str) {
        if (Validator.isEmpty(str)) {
            return false;
        }
        str = str.toLowerCase().trim();
        Matcher isSerialNo = pserialno.matcher(str);
        return isSerialNo.matches();
    }

    public static boolean isForbid(String str) {
        String[] forbids;
        if (Validator.isEmpty(str)) {
            return false;
        }
        str = str.toLowerCase().trim();
        for (String s : forbids = new String[]{"%", "\\", "'", "*"}) {
            if (str.indexOf(s) <= -1) continue;
            return true;
        }
        return false;
    }

    public static boolean isDateYMD(String s) {
        if (Validator.isEmpty(s)) {
            return false;
        }
        Matcher m = pdateymd.matcher(s);
        return m.matches();
    }

    public static boolean isDateY_M_D(String s) {
        if (Validator.isEmpty(s)) {
            return false;
        }
        Matcher m = pdatey_m_d.matcher(s);
        return m.matches();
    }

    public static boolean isCharAndDigit(String s) {
        if (Validator.isEmpty(s)) {
            return false;
        }
        Matcher m = pcharanddigit.matcher(s);
        return m.matches();
    }

    public static boolean isEmpty(String s) {
        return null == s || s.trim().equals("");
    }

    public static boolean isNotEmpty(String s) {
        return !Validator.isEmpty(s);
    }

    public static boolean isIP(String s) {
        Matcher m = pip4.matcher(s);
        return m.matches();
    }

    public static boolean isDomain(String s) {
        if (Validator.isEmpty(s)) {
            return false;
        }
        Matcher m = pdomain.matcher(s);
        return m.matches();
    }

    public static boolean isNotDomain(String s) {
        return !Validator.isDomain(s);
    }

    public static boolean isMainDomain(String str) {
        String[] domains;
        if (null == str || "".equals(str.trim())) {
            return false;
        }
        for (String s : domains = DOMAINS.split("\\|")) {
            if (null == s || s.trim().equals("") || str.indexOf(s) <= 0) continue;
            return Validator.isSerialNo(str = str.replace(s, ""));
        }
        return false;
    }

    public static boolean isChinaIdCardNoSimple(String no) {
        Matcher m;
        return StringTools.isNotEmpty(no) && (m = pidcardno.matcher(no)).matches();
    }

    public static boolean isChinaIdCardNo18(String no) {
        char[] lastnum = new char[]{'1', '0', 'X', '9', '8', '7', '6', '5', '4', '3', '2'};
        int[] weight = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2, 1};
        if (StringTools.isNotEmpty(no = no.toUpperCase()) && no.length() == 18) {
            String[] strs = no.split("");
            int sum = 0;
            for (int i = 1; i < strs.length - 1; ++i) {
                sum += Integer.parseInt(strs[i]) * weight[i - 1];
            }
            System.out.println(strs[18].charAt(0));
            System.out.println(lastnum[sum % 11]);
            if (strs[18].charAt(0) == lastnum[sum % 11]) {
                return true;
            }
        }
        return false;
    }

    public static boolean isChinaIdCardNoDetail(String no) {
        int zonecode = Integer.parseInt(no.substring(0, 2));
        boolean isok = false;
        for (int code : areas) {
            if (code != zonecode) continue;
            isok = true;
            break;
        }
        int year = Integer.parseInt(no.substring(6, 10));
        int month = Integer.parseInt(no.substring(10, 12));
        int day = Integer.parseInt(no.substring(12, 14));
        if (no.length() == 15) {
            year = 1900 + Integer.parseInt(no.substring(6, 8));
            month = Integer.parseInt(no.substring(8, 10));
            day = Integer.parseInt(no.substring(10, 12));
            if (year > 1980) {
                return false;
            }
        }
        if (year < 1800 || month <= 0 || month > 12 || day <= 0 || day > 31) {
            isok = false;
        }
        if (isok) {
            if (year % 4 == 0 && year % 100 != 0 || year % 400 == 0) {
                if (month == 2 && day > 29) {
                    isok = false;
                }
            } else {
                switch (month) {
                    case 1: 
                    case 3: 
                    case 5: 
                    case 7: 
                    case 8: 
                    case 10: 
                    case 12: {
                        if (day <= 31) break;
                        isok = false;
                        break;
                    }
                    case 4: 
                    case 6: 
                    case 9: 
                    case 11: {
                        if (day <= 30) break;
                        isok = false;
                        break;
                    }
                    case 2: {
                        if (day <= 28) break;
                        isok = false;
                        break;
                    }
                    default: {
                        isok = false;
                    }
                }
            }
        }
        return isok;
    }

    public static boolean isChinaIdCardNo(String no) {
        if (Validator.isChinaIdCardNoSimple(no)) {
            if (no.length() == 18) {
                return Validator.isChinaIdCardNo18(no) && Validator.isChinaIdCardNoDetail(no);
            }
            if (no.length() == 15) {
                return Validator.isChinaIdCardNoDetail(no);
            }
        }
        return false;
    }

    public static boolean isAdult(int birthdate) {
        if (birthdate <= 18000101) {
            return false;
        }
        if (birthdate <= 19920101) {
            return true;
        }
        Calendar now = Calendar.getInstance(TimeZone.getTimeZone("GMT+8:00"));
        String strdate = String.valueOf(birthdate);
        int birthyear = birthdate / 10000;
        int birthmonth = Integer.parseInt(strdate.substring(4, 6));
        int birthday = Integer.parseInt(strdate.substring(6, 8));
        if (now.get(1) - birthyear > 18) {
            return true;
        }
        if (now.get(1) - birthyear == 18) {
            if (birthmonth > 0 && birthmonth < 13) {
                if (birthmonth < now.get(2) + 1) {
                    return true;
                }
                if (birthmonth == now.get(2) + 1) {
                    return birthday > 0 && birthday <= 31 && birthday <= now.get(5);
                }
                return false;
            }
            return false;
        }
        return false;
    }

    public static boolean isAdultFromCardNo(String cardNo) {
        if (StringTools.isEmpty(cardNo)) {
            return false;
        }
        if (!Validator.isInteger(cardNo.trim().substring(0, 1))) {
            return true;
        }
        String strday = null;
        if (cardNo.length() == 15) {
            strday = "19" + cardNo.substring(6, 12);
        } else if (cardNo.length() == 18) {
            strday = cardNo.substring(6, 14);
        }
        if (Validator.isInteger(strday)) {
            return Validator.isAdult(Integer.parseInt(strday));
        }
        return false;
    }

    public static void main(String[] a) {
        System.out.println(Validator.isChinaIdCardNo("420702198405048092"));
    }
}

