/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.server.usercentre.proxy;

import com.xunlei.server.register.proxy.XLUsrInfo;
import com.xunlei.server.usercentre.exception.XunLeiUserCentreProxyException;
import com.xunlei.server.usercentre.util.SocketUtil;
import java.io.IOException;

public class XunLeiUserServerProxy {
    private String server;
    private int port;
    private int timeout;

    public XunLeiUserServerProxy(String server, int port, int timeout) {
        this.server = server;
        this.port = port;
        this.timeout = timeout;
    }

    public XLUsrInfo getUserInfo(XLUsrInfo userinfo, int getflag) throws XunLeiUserCentreProxyException {
        StringBuilder request = new StringBuilder();
        request.append("request:getuserinfo");
        request.append("\tusername:");
        switch (getflag) {
            case 0: {
                request.append(userinfo.getUsername());
                break;
            }
            case 1: {
                request.append(userinfo.getUsernewno());
                break;
            }
            case 2: {
                request.append(userinfo.getNo());
                break;
            }
            case 3: {
                request.append(userinfo.getIdcardno());
                break;
            }
            default: {
                return null;
            }
        }
        request.append("\tusertype:");
        request.append(getflag);
        request.append("\t\n\n");
        String result = null;
        try {
            byte[] retBytes = SocketUtil.commonRequest(this.server, this.port, this.timeout, request.toString().getBytes("gbk"));
            result = new String(retBytes, "GBK");
        }
        catch (IOException e) {
            throw new XunLeiUserCentreProxyException("\u7f51\u7edc\u901a\u4fe1\u9519\u8bef");
        }
        XLUsrInfo info = new XLUsrInfo();
        info.setUserInfo(result);
        if (null == info) {
            return null;
        }
        if (result.startsWith("result:200")) {
            return info;
        }
        throw new XunLeiUserCentreProxyException(info.getStrerr());
    }
}

