/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.server.usercentre.client;

import com.xunlei.server.common.util.CommonUtil;
import com.xunlei.server.register.proxy.GameUserException;
import com.xunlei.server.register.proxy.XLUsrInfo;
import com.xunlei.server.register.proxy.result.UserExistsResult;
import com.xunlei.server.usercentre.exception.XunLeiUserCentreProxyException;
import com.xunlei.server.usercentre.proxy.XunLeiUserServerProxy;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Random;

public class XunLeiUserCentre {
    private int timeout;
    private String server;
    private boolean ismain;
    private String[] backupserver;
    private Random random;
    private int port;
    private static final String charset = "gbk";
    private static byte[] existCommandBytes = "EXISTS_USR".getBytes();

    public XunLeiUserCentre(String server, int port, int timeout, String ... backupserver) {
        this.server = server;
        this.port = port;
        this.timeout = timeout;
        if (backupserver != null && backupserver.length > 0) {
            this.backupserver = backupserver;
        }
        this.random = new Random();
    }

    public XLUsrInfo getXunLeiUserInfo(XLUsrInfo userinfo, int getflag) throws XunLeiUserCentreProxyException {
        XunLeiUserServerProxy proxy = new XunLeiUserServerProxy(this.server, this.port, this.timeout);
        return proxy.getUserInfo(userinfo, getflag);
    }

    public int login(String username, String pwd) {
        return 1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private UserExistsResult userExistsNew(String account, int getflag, String socketAddress) throws GameUserException {
        UserExistsResult userExistsResult = new UserExistsResult();
        byte[] sn = new byte[2];
        this.random.nextBytes(sn);
        byte[] data = new byte[32];
        data[0] = sn[0];
        data[1] = sn[1];
        System.arraycopy(existCommandBytes, 0, data, 2, 10);
        account = CommonUtil.formatString((String)account, (int)20, (char)' ', (boolean)true);
        System.arraycopy(account.getBytes(), 0, data, 12, 20);
        byte[] lengthBytes = CommonUtil.intToByteArray((int)data.length);
        Socket socket = null;
        try {
            socket = new Socket(socketAddress, this.port);
            socket.setReuseAddress(true);
            socket.setSoLinger(false, 0);
            socket.setSoTimeout(this.timeout);
            InputStream input = socket.getInputStream();
            OutputStream output = socket.getOutputStream();
            output.write(lengthBytes);
            output.write(data);
            byte[] readLengthBytes = new byte[4];
            input.read(readLengthBytes);
            int readLength = CommonUtil.byteArrayToInt((byte[])readLengthBytes);
            if (readLength <= 0 || readLength > 1024) {
                userExistsResult.setCode(9999);
                UserExistsResult userExistsResult2 = userExistsResult;
                return userExistsResult2;
            }
            byte[] readData = new byte[readLength];
            input.read(readData);
            byte[] readSn = new byte[]{readData[0], readData[1]};
            if (readSn[0] != sn[0] || readSn[1] != sn[1]) {
                userExistsResult.setCode(9999);
                UserExistsResult userExistsResult3 = userExistsResult;
                return userExistsResult3;
            }
            byte[] returnCode = new byte[4];
            System.arraycopy(readData, 2, returnCode, 0, 4);
            String retCode = new String(returnCode);
            int code = Integer.parseInt(retCode);
            userExistsResult.setCode(code);
            if (code == 0) {
                userExistsResult.setCode(0);
                byte[] accountTypeBytes = new byte[1];
                System.arraycopy(readData, 6, accountTypeBytes, 0, 1);
                byte accountType = Byte.parseByte(new String(accountTypeBytes));
                userExistsResult.setAccountType(accountType);
                byte[] userIdBytes = new byte[16];
                System.arraycopy(readData, 7, userIdBytes, 0, 16);
                String userId = new String(userIdBytes);
                userExistsResult.setUserId(userId.trim());
                byte[] newAccountBytes = new byte[11];
                System.arraycopy(readData, 23, newAccountBytes, 0, 11);
                String newAccount = new String(newAccountBytes);
                userExistsResult.setNewAccount(newAccount.trim());
                byte[] oldAccountBytes = new byte[20];
                System.arraycopy(readData, 34, oldAccountBytes, 0, 20);
                String oldAccount = new String(oldAccountBytes);
                userExistsResult.setOldAccount(oldAccount.trim());
            }
            UserExistsResult userExistsResult4 = userExistsResult;
            return userExistsResult4;
        }
        catch (Exception e1) {
            throw new GameUserException(e1);
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static void main(String[] args) throws XunLeiUserCentreProxyException {
        XunLeiUserCentre centre = new XunLeiUserCentre("10.10.3.117", 39527, 10000, new String[0]);
        XLUsrInfo userinfo = new XLUsrInfo();
        userinfo.setUsername("fontong");
        XLUsrInfo info = centre.getXunLeiUserInfo(userinfo, 0);
        System.out.println(info);
    }
}

