/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.server.register.proxy;

import com.xunlei.server.common.util.CommonUtil;
import com.xunlei.server.common.util.MD5Util;
import com.xunlei.server.register.proxy.GameUserException;
import com.xunlei.server.register.proxy.IGameUserProxy;
import com.xunlei.server.register.proxy.XLUsrInfo;
import com.xunlei.server.register.proxy.result.AuthenticateResult;
import com.xunlei.server.register.proxy.result.GetUserInfoByUserIdResult;
import com.xunlei.server.register.proxy.result.RefergetInfo;
import com.xunlei.server.register.proxy.result.UserExistsResult;
import com.xunlei.server.register.usrproxy.ProxyUtil;
import com.xunlei.server.usercentre.client.GameUserCentreClient;
import com.xunlei.server.usercentre.util.ConstantsRetCode;
import com.xunlei.server.usercentre.util.StringTools;
import com.xunlei.server.usercentre.vo.GameUserInfo;
import com.xunlei.server.usercentre.vo.ResGameUserInfo;
import com.xunlei.server.usercentre.vo.SimpleUserInfo;
import com.xunlei.server.usercentre.vo.UserInfoDetail;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class GameUserProxy
implements IGameUserProxy {
    private int timeout;
    private String socketAddress;
    private int port;
    private Random random;
    private static final String charset = "gbk";
    private static byte[] remtAuthCommandBytes = "AUTH_RMTE ".getBytes();
    private static byte[] authCommandBytes = "AUTH_USR  ".getBytes();
    private static byte[] existCommandBytes = "EXISTS_USR".getBytes();
    private static byte[] queryInfoByUserIdCommandBytes = "QRY_USRID ".getBytes();
    private static byte[] turnOnCommandBytes = "TMPPWD_ON ".getBytes();
    private static byte[] turnOffCommandBytes = "TMPPWD_OFF".getBytes();
    private static byte[] updPwdCommandBytes = "UPD_PWD   ".getBytes();
    private static byte[] auth2CommandBytes = "AUTH_USR_2".getBytes();
    private static byte[] bindCIDCommandBytes = "BIND_CID  ".getBytes();
    private static byte[] unBindCIDCommandBytes = "UNBIND_CID".getBytes();
    private static byte[] queryCIDCommandBytes = "QUERY_CID ".getBytes();
    private static byte[] getUsrCommandBytes = "GET_USR   ".getBytes();
    private static byte[] updUsrCommandBytes = "UPDATE_USR".getBytes();
    private static byte[] getXLUsrUsrCommandBytes = "GET_XL_USR".getBytes();
    private static byte[] addBLKCommandBytes = "ADD_BLK   ".getBytes();
    private static byte[] rmBLKCommandBytes = "RM_BLK    ".getBytes();
    private static byte[] getBLKCommandBytes = "GET_BLK   ".getBytes();
    private static byte[] vipCommandBytes = "QUERY_VIP ".getBytes();
    private static byte[] addEdcstCommandBytes = "ADD_ED_CST".getBytes();
    private static byte[] rmEdcstCommandBytes = "RM_ED_CST ".getBytes();
    private static byte[] getEdcstCommandBytes = "GET_ED_CST".getBytes();
    private static byte[] clrEdcstCommandBytes = "CLR_ED_CST".getBytes();
    private static byte[] checkAndUpdPwdCommandBytes = "ChekUpdPwd".getBytes();
    private static byte[] qryUtypeCommandBytes = "QRY_UTYPE ".getBytes();
    private static byte[] regis_UsrCommandBytes = "REGIS_USR ".getBytes();
    private static byte[] checkXLUsrCommandBytes = "CHECK_USR ".getBytes();
    private static byte[] reTakePassCommandBytes = "RETAKEPASS".getBytes();
    private static byte[] GEN_DIGICommandBytes = "GEN_DIGI  ".getBytes();
    private static byte[] RECM_DIGICommandBytes = "RECM_DIGI ".getBytes();
    private static byte[] JUDG_DIGICommandBytes = "JUDG_DIGI ".getBytes();
    private static byte[] REGI_DIGICommandBytes = "REGI_DIGI ".getBytes();
    private static byte[] SECT_PROTCommandBytes = "SECT_PROT ".getBytes();
    private static byte[] rmMemCommandBytes = "RM_MEM    ".getBytes();
    private static byte[] upduidCommandBytes = "UPD_UID   ".getBytes();
    private static byte[] USER_REGISTER_CMD = "NEW_REG   ".getBytes();
    private Logger logger = Logger.getLogger(this.getClass());
    private String socketAddress1;
    private String socketAddress2;
    private ScheduledExecutorService scheduledExecutor;

    private void init(final String user) {
        if (this.socketAddress2 != null) {
            this.detect(user);
            this.scheduledExecutor = Executors.newScheduledThreadPool(3);
            this.scheduledExecutor.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    GameUserProxy.this.detect(user);
                }
            }, 5L, 5L, TimeUnit.SECONDS);
        }
    }

    @Override
    public void destroyExecutor() {
        if (this.scheduledExecutor != null) {
            this.scheduledExecutor.shutdownNow();
        }
    }

    private void detect(String user) {
        boolean mainOk = false;
        for (int i = 0; i < 3; ++i) {
            try {
                this.userExistsNew(user, this.socketAddress1);
                mainOk = true;
                break;
            }
            catch (GameUserException e) {
                if (i != 2) continue;
                e.printStackTrace();
                continue;
            }
        }
        this.socketAddress = mainOk ? this.socketAddress1 : this.socketAddress2;
    }

    @Override
    public void setSocketAddress2(String socketAddress2) {
        this.socketAddress2 = socketAddress2;
    }

    public GameUserProxy(String socketAddress, int port, int timeout) {
        this(socketAddress, port, timeout, null);
    }

    public GameUserProxy(String socketAddress, int port, int timeout, String socketAddress2) {
        this.timeout = timeout;
        this.random = new Random();
        this.socketAddress = socketAddress;
        this.port = port;
        this.socketAddress1 = socketAddress;
        this.socketAddress2 = socketAddress2;
        this.init("fengtong");
    }

    @Override
    @Deprecated
    public int authenticateUser(String user, String password, String sourceId) throws GameUserException {
        return this.authenticateUser(user, password, sourceId, false);
    }

    @Override
    public int authenticateUser(String user, String password, String sourceId, int invokeBy) throws GameUserException {
        return this.authenticateUser(user, password, sourceId, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int authenticateUser(String user, String password, String sourceId, boolean checkAdult, int invokeBy) throws GameUserException {
        if (sourceId == null) {
            sourceId = "";
        }
        byte[] sn = new byte[2];
        this.random.nextBytes(sn);
        byte[] data = new byte[76];
        data[0] = sn[0];
        data[1] = sn[1];
        System.arraycopy(authCommandBytes, 0, data, 2, 10);
        user = CommonUtil.formatString((String)user, (int)20, (char)' ', (boolean)true);
        password = CommonUtil.formatString((String)password, (int)20, (char)' ', (boolean)true);
        sourceId = CommonUtil.formatString((String)sourceId, (int)20, (char)' ', (boolean)true);
        System.arraycopy(user.getBytes(), 0, data, 12, 20);
        System.arraycopy(password.getBytes(), 0, data, 32, 20);
        System.arraycopy(sourceId.getBytes(), 0, data, 52, 20);
        String t = String.valueOf(invokeBy);
        String utype = "0000".substring(t.length()) + t;
        System.arraycopy(utype.getBytes(), 0, data, 72, 4);
        byte[] lengthBytes = CommonUtil.intToByteArray((int)data.length);
        Socket socket = null;
        try {
            socket = new Socket(this.socketAddress, this.port);
            socket.setReuseAddress(true);
            socket.setSoLinger(false, 0);
            socket.setSoTimeout(this.timeout);
            InputStream input = socket.getInputStream();
            OutputStream output = socket.getOutputStream();
            output.write(lengthBytes);
            output.write(data);
            byte[] readLengthBytes = new byte[4];
            input.read(readLengthBytes);
            int readLength = CommonUtil.byteArrayToInt((byte[])readLengthBytes);
            if (readLength <= 0 || readLength > 1024) {
                this.logger.error((Object)("Invalid package length: " + readLength));
                int n = 5;
                return n;
            }
            byte[] readData = new byte[readLength];
            input.read(readData);
            byte[] readSn = new byte[]{readData[0], readData[1]};
            if (readSn[0] != sn[0] || readSn[1] != sn[1]) {
                this.logger.error((Object)"Invalid sn. ");
                int n = 5;
                return n;
            }
            byte[] returnCode = new byte[4];
            System.arraycopy(readData, 2, returnCode, 0, 4);
            String retCode = new String(returnCode);
            int code = Integer.parseInt(retCode);
            if (!checkAdult && code == 8) {
                code = 0;
            }
            int n = code;
            return n;
        }
        catch (Exception e1) {
            throw new GameUserException(e1);
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Deprecated
    public int authenticateUser(String user, String password, String sourceId, boolean checkAdult) throws GameUserException {
        if (sourceId == null) {
            sourceId = "";
        }
        byte[] sn = new byte[2];
        this.random.nextBytes(sn);
        byte[] data = new byte[72];
        data[0] = sn[0];
        data[1] = sn[1];
        System.arraycopy(authCommandBytes, 0, data, 2, 10);
        user = CommonUtil.formatString((String)user, (int)20, (char)' ', (boolean)true);
        password = CommonUtil.formatString((String)password, (int)20, (char)' ', (boolean)true);
        sourceId = CommonUtil.formatString((String)sourceId, (int)20, (char)' ', (boolean)true);
        System.arraycopy(user.getBytes(), 0, data, 12, 20);
        System.arraycopy(password.getBytes(), 0, data, 32, 20);
        System.arraycopy(sourceId.getBytes(), 0, data, 52, 20);
        byte[] lengthBytes = CommonUtil.intToByteArray((int)data.length);
        Socket socket = null;
        try {
            socket = new Socket(this.socketAddress, this.port);
            socket.setReuseAddress(true);
            socket.setSoLinger(false, 0);
            socket.setSoTimeout(this.timeout);
            InputStream input = socket.getInputStream();
            OutputStream output = socket.getOutputStream();
            output.write(lengthBytes);
            output.write(data);
            byte[] readLengthBytes = new byte[4];
            input.read(readLengthBytes);
            int readLength = CommonUtil.byteArrayToInt((byte[])readLengthBytes);
            if (readLength <= 0 || readLength > 1024) {
                this.logger.error((Object)("Invalid package length: " + readLength));
                int n = 5;
                return n;
            }
            byte[] readData = new byte[readLength];
            input.read(readData);
            byte[] readSn = new byte[]{readData[0], readData[1]};
            if (readSn[0] != sn[0] || readSn[1] != sn[1]) {
                this.logger.error((Object)"Invalid sn. ");
                int n = 5;
                return n;
            }
            byte[] returnCode = new byte[4];
            System.arraycopy(readData, 2, returnCode, 0, 4);
            String retCode = new String(returnCode);
            int code = Integer.parseInt(retCode);
            if (!checkAdult && code == 8) {
                code = 0;
            }
            int n = code;
            return n;
        }
        catch (Exception e1) {
            throw new GameUserException(e1);
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int userExists(String user) throws GameUserException {
        byte[] sn = new byte[2];
        this.random.nextBytes(sn);
        byte[] data = new byte[32];
        data[0] = sn[0];
        data[1] = sn[1];
        System.arraycopy(existCommandBytes, 0, data, 2, 10);
        user = CommonUtil.formatString((String)user, (int)20, (char)' ', (boolean)true);
        System.arraycopy(user.getBytes(), 0, data, 12, 20);
        byte[] lengthBytes = CommonUtil.intToByteArray((int)data.length);
        Socket socket = null;
        try {
            int code;
            socket = new Socket(this.socketAddress, this.port);
            socket.setReuseAddress(true);
            socket.setSoLinger(false, 0);
            socket.setSoTimeout(this.timeout);
            InputStream input = socket.getInputStream();
            OutputStream output = socket.getOutputStream();
            output.write(lengthBytes);
            output.write(data);
            byte[] readLengthBytes = new byte[4];
            input.read(readLengthBytes);
            int readLength = CommonUtil.byteArrayToInt((byte[])readLengthBytes);
            if (readLength <= 0 || readLength > 1024) {
                this.logger.error((Object)("Invalid package length: " + readLength));
                int n = 9999;
                return n;
            }
            byte[] readData = new byte[readLength];
            input.read(readData);
            byte[] readSn = new byte[]{readData[0], readData[1]};
            if (readSn[0] != sn[0] || readSn[1] != sn[1]) {
                this.logger.error((Object)"Invalid sn. ");
                int n = 9999;
                return n;
            }
            byte[] returnCode = new byte[4];
            System.arraycopy(readData, 2, returnCode, 0, 4);
            String retCode = new String(returnCode);
            int n = code = Integer.parseInt(retCode);
            return n;
        }
        catch (Exception e1) {
            throw new GameUserException(e1);
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean turnOnTmpPwd(String user, String tmpPwd, String gameId, String operateBy) throws GameUserException {
        byte[] sn = new byte[2];
        this.random.nextBytes(sn);
        byte[] data = new byte[92];
        data[0] = sn[0];
        data[1] = sn[1];
        System.arraycopy(turnOnCommandBytes, 0, data, 2, 10);
        user = CommonUtil.formatString((String)user, (int)20, (char)' ', (boolean)true);
        tmpPwd = CommonUtil.formatString((String)tmpPwd, (int)20, (char)' ', (boolean)true);
        gameId = CommonUtil.formatString((String)gameId, (int)20, (char)' ', (boolean)true);
        operateBy = CommonUtil.formatString((String)operateBy, (int)20, (char)' ', (boolean)true);
        System.arraycopy(user.getBytes(), 0, data, 12, 20);
        System.arraycopy(tmpPwd.getBytes(), 0, data, 32, 20);
        System.arraycopy(gameId.getBytes(), 0, data, 52, 20);
        System.arraycopy(operateBy.getBytes(), 0, data, 72, 20);
        byte[] lengthBytes = CommonUtil.intToByteArray((int)data.length);
        Socket socket = null;
        try {
            socket = new Socket(this.socketAddress, this.port);
            socket.setReuseAddress(true);
            socket.setSoLinger(false, 0);
            socket.setSoTimeout(this.timeout);
            InputStream input = socket.getInputStream();
            OutputStream output = socket.getOutputStream();
            output.write(lengthBytes);
            output.write(data);
            byte[] readLengthBytes = new byte[4];
            input.read(readLengthBytes);
            int readLength = CommonUtil.byteArrayToInt((byte[])readLengthBytes);
            if (readLength <= 0 || readLength > 1024) {
                this.logger.error((Object)("Invalid package length: " + readLength));
                boolean bl = false;
                return bl;
            }
            byte[] readData = new byte[readLength];
            input.read(readData);
            byte[] readSn = new byte[]{readData[0], readData[1]};
            if (readSn[0] != sn[0] || readSn[1] != sn[1]) {
                this.logger.error((Object)"Invalid sn. ");
                boolean bl = false;
                return bl;
            }
            byte[] returnCode = new byte[4];
            System.arraycopy(readData, 2, returnCode, 0, 4);
            if (returnCode[0] == 48 && returnCode[1] == 48 && returnCode[2] == 48 && returnCode[3] == 48) {
                boolean e = true;
                return e;
            }
            try {
                this.logger.info((Object)("turn temporary password on failed:" + new String(readData, 6, readData.length - 6, "GBK")));
            }
            catch (UnsupportedEncodingException e) {
                this.logger.info((Object)"GBK not supported.", (Throwable)e);
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e1) {
            throw new GameUserException(e1);
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean turnOffTmpPwd(String user, String gameId, String operateBy) throws GameUserException {
        byte[] sn = new byte[2];
        this.random.nextBytes(sn);
        byte[] data = new byte[72];
        data[0] = sn[0];
        data[1] = sn[1];
        System.arraycopy(turnOffCommandBytes, 0, data, 2, 10);
        user = CommonUtil.formatString((String)user, (int)20, (char)' ', (boolean)true);
        gameId = CommonUtil.formatString((String)gameId, (int)20, (char)' ', (boolean)true);
        operateBy = CommonUtil.formatString((String)operateBy, (int)20, (char)' ', (boolean)true);
        System.arraycopy(user.getBytes(), 0, data, 12, 20);
        System.arraycopy(gameId.getBytes(), 0, data, 32, 20);
        System.arraycopy(operateBy.getBytes(), 0, data, 52, 20);
        byte[] lengthBytes = CommonUtil.intToByteArray((int)data.length);
        Socket socket = null;
        try {
            socket = new Socket(this.socketAddress, this.port);
            socket.setReuseAddress(true);
            socket.setSoLinger(false, 0);
            socket.setSoTimeout(this.timeout);
            InputStream input = socket.getInputStream();
            OutputStream output = socket.getOutputStream();
            output.write(lengthBytes);
            output.write(data);
            byte[] readLengthBytes = new byte[4];
            input.read(readLengthBytes);
            int readLength = CommonUtil.byteArrayToInt((byte[])readLengthBytes);
            if (readLength <= 0 || readLength > 1024) {
                this.logger.error((Object)("Invalid package length: " + readLength));
                boolean bl = false;
                return bl;
            }
            byte[] readData = new byte[readLength];
            input.read(readData);
            byte[] readSn = new byte[]{readData[0], readData[1]};
            if (readSn[0] != sn[0] || readSn[1] != sn[1]) {
                this.logger.error((Object)"Invalid sn. ");
                boolean bl = false;
                return bl;
            }
            byte[] returnCode = new byte[4];
            System.arraycopy(readData, 2, returnCode, 0, 4);
            if (returnCode[0] == 48 && returnCode[1] == 48 && returnCode[2] == 48 && returnCode[3] == 48) {
                boolean e = true;
                return e;
            }
            try {
                this.logger.info((Object)("turn temporary password off failed:" + new String(readData, 6, readData.length - 6, "GBK")));
            }
            catch (UnsupportedEncodingException e) {
                this.logger.info((Object)"GBK not supported.", (Throwable)e);
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e1) {
            throw new GameUserException(e1);
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {}
            }
        }
    }

    @Override
    public boolean updateEncodedPassword(String user, String password, String usertype) throws GameUserException {
        return this.updateUserPassword(user, password, true, usertype);
    }

    @Override
    @Deprecated
    public boolean updatePassword(String user, String password) throws GameUserException {
        return this.updateUserPassword(user, password, false, "0");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean updateUserPassword(String user, String password, boolean isEncoded, String usertype) throws GameUserException {
        byte[] sn = new byte[2];
        this.random.nextBytes(sn);
        byte[] data = new byte[64];
        data[0] = sn[0];
        data[1] = sn[1];
        System.arraycopy(updPwdCommandBytes, 0, data, 2, 10);
        if (usertype.equals("2")) {
            XLUsrInfo userinfo = this.getXLUsrInfo(user, 2);
            if (userinfo == null) return false;
            if (userinfo.getUsername() != null && !userinfo.getUsername().trim().equals("")) {
                user = userinfo.getUsername().trim();
            } else {
                if (userinfo.getUsernewno() == null) return false;
                if (userinfo.getUsernewno().trim().equals("")) return false;
                user = userinfo.getUsernewno().trim();
            }
        }
        user = CommonUtil.formatString((String)user, (int)20, (char)' ', (boolean)true);
        String pass = null;
        if (!isEncoded) {
            String y = CommonUtil.byteArrayToHexString((byte[])MD5Util.MD5Encode((byte[])password.getBytes())).toLowerCase();
            pass = CommonUtil.byteArrayToHexString((byte[])MD5Util.MD5Encode((byte[])y.getBytes())).toLowerCase();
        } else {
            pass = password;
        }
        try {
            System.arraycopy(user.getBytes(charset), 0, data, 12, 20);
            System.arraycopy(pass.getBytes(charset), 0, data, 32, 32);
        }
        catch (UnsupportedEncodingException e2) {
            throw new GameUserException(e2);
        }
        byte[] lengthBytes = CommonUtil.intToByteArray((int)data.length);
        Socket socket = null;
        try {
            socket = new Socket(this.socketAddress, this.port);
            socket.setReuseAddress(true);
            socket.setSoLinger(false, 0);
            socket.setSoTimeout(this.timeout);
            InputStream input = socket.getInputStream();
            OutputStream output = socket.getOutputStream();
            output.write(lengthBytes);
            output.write(data);
            byte[] readLengthBytes = new byte[4];
            input.read(readLengthBytes);
            int readLength = CommonUtil.byteArrayToInt((byte[])readLengthBytes);
            if (readLength <= 0 || readLength > 1024) {
                this.logger.error((Object)("Invalid package length: " + readLength));
                boolean bl = false;
                return bl;
            }
            byte[] readData = new byte[readLength];
            input.read(readData);
            byte[] readSn = new byte[]{readData[0], readData[1]};
            if (readSn[0] != sn[0] || readSn[1] != sn[1]) {
                this.logger.error((Object)"Invalid sn. ");
                boolean bl = false;
                return bl;
            }
            byte[] returnCode = new byte[4];
            System.arraycopy(readData, 2, returnCode, 0, 4);
            if (returnCode[0] == 48 && returnCode[1] == 48 && returnCode[2] == 48 && returnCode[3] == 48) {
                boolean e = true;
                return e;
            }
            try {
                this.logger.info((Object)("update password failed:" + new String(readData, 6, readData.length - 6, "GBK")));
            }
            catch (UnsupportedEncodingException e) {
                this.logger.info((Object)"GBK not supported.", (Throwable)e);
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e1) {
            throw new GameUserException(e1);
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean authenticateUser_2(String user, String password, String nToVerify) throws GameUserException {
        byte[] sn = new byte[2];
        this.random.nextBytes(sn);
        byte[] data = new byte[65];
        data[0] = sn[0];
        data[1] = sn[1];
        System.arraycopy(auth2CommandBytes, 0, data, 2, 10);
        user = CommonUtil.formatString((String)user, (int)20, (char)' ', (boolean)true);
        password = CommonUtil.formatString((String)password, (int)32, (char)' ', (boolean)true);
        System.arraycopy(nToVerify.getBytes(), 0, data, 12, 1);
        System.arraycopy(user.getBytes(), 0, data, 13, 20);
        System.arraycopy(password.getBytes(), 0, data, 33, 32);
        byte[] lengthBytes = CommonUtil.intToByteArray((int)data.length);
        Socket socket = null;
        try {
            socket = new Socket(this.socketAddress, this.port);
            socket.setReuseAddress(true);
            socket.setSoLinger(false, 0);
            socket.setSoTimeout(this.timeout);
            InputStream input = socket.getInputStream();
            OutputStream output = socket.getOutputStream();
            output.write(lengthBytes);
            output.write(data);
            byte[] readLengthBytes = new byte[4];
            input.read(readLengthBytes);
            int readLength = CommonUtil.byteArrayToInt((byte[])readLengthBytes);
            if (readLength <= 0 || readLength > 1024) {
                this.logger.error((Object)("Invalid package length: " + readLength));
                boolean bl = false;
                return bl;
            }
            byte[] readData = new byte[readLength];
            input.read(readData);
            byte[] readSn = new byte[]{readData[0], readData[1]};
            if (readSn[0] != sn[0] || readSn[1] != sn[1]) {
                this.logger.error((Object)"Invalid sn. ");
                boolean bl = false;
                return bl;
            }
            byte[] returnCode = new byte[4];
            System.arraycopy(readData, 2, returnCode, 0, 4);
            if (returnCode[0] == 48 && returnCode[1] == 48 && returnCode[2] == 48 && returnCode[3] == 48) {
                boolean e = true;
                return e;
            }
            try {
                this.logger.info((Object)("AUTH_2 failed:" + new String(readData, 6, readData.length - 6, "GBK")));
            }
            catch (UnsupportedEncodingException e) {
                this.logger.info((Object)"GBK not supported.", (Throwable)e);
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e1) {
            throw new GameUserException(e1);
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean bindCID(String user, String clitId, String bindedIp) throws GameUserException {
        byte[] sn = new byte[2];
        this.random.nextBytes(sn);
        byte[] data = new byte[57];
        data[0] = sn[0];
        data[1] = sn[1];
        System.arraycopy(bindCIDCommandBytes, 0, data, 2, 10);
        user = CommonUtil.formatString((String)user, (int)20, (char)' ', (boolean)true);
        clitId = CommonUtil.formatString((String)clitId, (int)10, (char)' ', (boolean)true);
        bindedIp = CommonUtil.formatString((String)bindedIp, (int)15, (char)' ', (boolean)true);
        System.arraycopy(user.getBytes(), 0, data, 12, 20);
        System.arraycopy(clitId.getBytes(), 0, data, 32, 10);
        System.arraycopy(bindedIp.getBytes(), 0, data, 42, 15);
        byte[] lengthBytes = CommonUtil.intToByteArray((int)data.length);
        Socket socket = null;
        try {
            socket = new Socket(this.socketAddress, this.port);
            socket.setReuseAddress(true);
            socket.setSoLinger(false, 0);
            socket.setSoTimeout(this.timeout);
            InputStream input = socket.getInputStream();
            OutputStream output = socket.getOutputStream();
            output.write(lengthBytes);
            output.write(data);
            byte[] readLengthBytes = new byte[4];
            input.read(readLengthBytes);
            int readLength = CommonUtil.byteArrayToInt((byte[])readLengthBytes);
            if (readLength <= 0 || readLength > 1024) {
                this.logger.error((Object)("Invalid package length: " + readLength));
                boolean bl = false;
                return bl;
            }
            byte[] readData = new byte[readLength];
            input.read(readData);
            byte[] readSn = new byte[]{readData[0], readData[1]};
            if (readSn[0] != sn[0] || readSn[1] != sn[1]) {
                this.logger.error((Object)"Invalid sn. ");
                boolean bl = false;
                return bl;
            }
            byte[] returnCode = new byte[4];
            System.arraycopy(readData, 2, returnCode, 0, 4);
            if (returnCode[0] == 48 && returnCode[1] == 48 && returnCode[2] == 48 && returnCode[3] == 48) {
                boolean e = true;
                return e;
            }
            try {
                this.logger.info((Object)("bind CID failed:" + new String(readData, 6, readData.length - 6, "GBK")));
            }
            catch (UnsupportedEncodingException e) {
                this.logger.info((Object)"GBK not supported.", (Throwable)e);
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e1) {
            throw new GameUserException(e1);
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean unBindCID(String user) throws GameUserException {
        byte[] sn = new byte[2];
        this.random.nextBytes(sn);
        byte[] data = new byte[32];
        data[0] = sn[0];
        data[1] = sn[1];
        System.arraycopy(unBindCIDCommandBytes, 0, data, 2, 10);
        user = CommonUtil.formatString((String)user, (int)20, (char)' ', (boolean)true);
        System.arraycopy(user.getBytes(), 0, data, 12, 20);
        byte[] lengthBytes = CommonUtil.intToByteArray((int)data.length);
        Socket socket = null;
        try {
            socket = new Socket(this.socketAddress, this.port);
            socket.setReuseAddress(true);
            socket.setSoLinger(false, 0);
            socket.setSoTimeout(this.timeout);
            InputStream input = socket.getInputStream();
            OutputStream output = socket.getOutputStream();
            output.write(lengthBytes);
            output.write(data);
            byte[] readLengthBytes = new byte[4];
            input.read(readLengthBytes);
            int readLength = CommonUtil.byteArrayToInt((byte[])readLengthBytes);
            if (readLength <= 0 || readLength > 1024) {
                this.logger.error((Object)("Invalid package length: " + readLength));
                boolean bl = false;
                return bl;
            }
            byte[] readData = new byte[readLength];
            input.read(readData);
            byte[] readSn = new byte[]{readData[0], readData[1]};
            if (readSn[0] != sn[0] || readSn[1] != sn[1]) {
                this.logger.error((Object)"Invalid sn. ");
                boolean bl = false;
                return bl;
            }
            byte[] returnCode = new byte[4];
            System.arraycopy(readData, 2, returnCode, 0, 4);
            if (returnCode[0] == 48 && returnCode[1] == 48 && returnCode[2] == 48 && returnCode[3] == 48) {
                boolean e = true;
                return e;
            }
            try {
                this.logger.info((Object)("unBind CID failed:" + new String(readData, 6, readData.length - 6, "GBK")));
            }
            catch (UnsupportedEncodingException e) {
                this.logger.info((Object)"GBK not supported.", (Throwable)e);
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e1) {
            throw new GameUserException(e1);
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public String queryCID(String user) throws GameUserException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 26[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public String getUsrInfo(String user, String fieldsToGet) throws GameUserException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 26[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean updateUserInfo(String user, String operateBy, String fieldsToUpd) throws GameUserException {
        if (fieldsToUpd == null || fieldsToUpd.trim().length() == 0) {
            this.logger.error((Object)"Invalid fieldsToUpd.");
            return false;
        }
        byte[] sn = new byte[2];
        this.random.nextBytes(sn);
        byte[] data = null;
        try {
            data = new byte[52 + fieldsToUpd.getBytes(charset).length];
        }
        catch (UnsupportedEncodingException e3) {
            throw new GameUserException(e3);
        }
        data[0] = sn[0];
        data[1] = sn[1];
        System.arraycopy(updUsrCommandBytes, 0, data, 2, 10);
        user = CommonUtil.formatString((String)user, (int)20, (char)' ', (boolean)true);
        operateBy = CommonUtil.formatString((String)operateBy, (int)20, (char)' ', (boolean)true);
        System.arraycopy(user.getBytes(), 0, data, 12, 20);
        System.arraycopy(operateBy.getBytes(), 0, data, 32, 20);
        try {
            System.arraycopy(fieldsToUpd.getBytes(charset), 0, data, 52, fieldsToUpd.getBytes(charset).length);
        }
        catch (UnsupportedEncodingException e2) {
            throw new GameUserException(e2);
        }
        byte[] lengthBytes = CommonUtil.intToByteArray((int)data.length);
        Socket socket = null;
        try {
            socket = new Socket(this.socketAddress, this.port);
            socket.setReuseAddress(true);
            socket.setSoLinger(false, 0);
            socket.setSoTimeout(this.timeout);
            InputStream input = socket.getInputStream();
            OutputStream output = socket.getOutputStream();
            output.write(lengthBytes);
            output.write(data);
            byte[] readLengthBytes = new byte[4];
            input.read(readLengthBytes);
            int readLength = CommonUtil.byteArrayToInt((byte[])readLengthBytes);
            if (readLength <= 0 || readLength > 1024) {
                this.logger.error((Object)("Invalid package length: " + readLength));
                boolean bl = false;
                return bl;
            }
            byte[] readData = new byte[readLength];
            input.read(readData);
            byte[] readSn = new byte[]{readData[0], readData[1]};
            if (readSn[0] != sn[0] || readSn[1] != sn[1]) {
                this.logger.error((Object)"Invalid sn. ");
                boolean bl = false;
                return bl;
            }
            byte[] returnCode = new byte[4];
            System.arraycopy(readData, 2, returnCode, 0, 4);
            if (returnCode[0] == 48 && returnCode[1] == 48 && returnCode[2] == 48 && returnCode[3] == 48) {
                boolean e = true;
                return e;
            }
            try {
                this.logger.info((Object)("update user info failed:" + new String(readData, 6, readData.length - 6, "GBK")));
            }
            catch (UnsupportedEncodingException e) {
                this.logger.info((Object)"GBK not supported.", (Throwable)e);
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e1) {
            throw new GameUserException(e1);
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean addBlkUsr(String user, String gameId, String operateBy) throws GameUserException {
        if (gameId == null) {
            gameId = "";
        }
        byte[] sn = new byte[2];
        this.random.nextBytes(sn);
        byte[] data = new byte[72];
        data[0] = sn[0];
        data[1] = sn[1];
        System.arraycopy(addBLKCommandBytes, 0, data, 2, 10);
        user = CommonUtil.formatString((String)user, (int)20, (char)' ', (boolean)true);
        gameId = CommonUtil.formatString((String)gameId, (int)20, (char)' ', (boolean)true);
        operateBy = CommonUtil.formatString((String)operateBy, (int)20, (char)' ', (boolean)true);
        System.arraycopy(user.getBytes(), 0, data, 12, 20);
        System.arraycopy(gameId.getBytes(), 0, data, 32, 20);
        System.arraycopy(operateBy.getBytes(), 0, data, 52, 20);
        byte[] lengthBytes = CommonUtil.intToByteArray((int)data.length);
        Socket socket = null;
        try {
            socket = new Socket(this.socketAddress, this.port);
            socket.setReuseAddress(true);
            socket.setSoLinger(false, 0);
            socket.setSoTimeout(this.timeout);
            InputStream input = socket.getInputStream();
            OutputStream output = socket.getOutputStream();
            output.write(lengthBytes);
            output.write(data);
            byte[] readLengthBytes = new byte[4];
            input.read(readLengthBytes);
            int readLength = CommonUtil.byteArrayToInt((byte[])readLengthBytes);
            if (readLength <= 0 || readLength > 1024) {
                this.logger.error((Object)("Invalid package length: " + readLength));
                boolean bl = false;
                return bl;
            }
            byte[] readData = new byte[readLength];
            input.read(readData);
            byte[] readSn = new byte[]{readData[0], readData[1]};
            if (readSn[0] != sn[0] || readSn[1] != sn[1]) {
                this.logger.error((Object)"Invalid sn. ");
                boolean bl = false;
                return bl;
            }
            byte[] returnCode = new byte[4];
            System.arraycopy(readData, 2, returnCode, 0, 4);
            if (returnCode[0] == 48 && returnCode[1] == 48 && returnCode[2] == 48 && returnCode[3] == 48) {
                boolean e = true;
                return e;
            }
            try {
                this.logger.info((Object)("add black user failed:" + new String(readData, 6, readData.length - 6, "GBK")));
            }
            catch (UnsupportedEncodingException e) {
                this.logger.info((Object)"GBK not supported.", (Throwable)e);
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e1) {
            throw new GameUserException(e1);
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean rmBlkUsr(String user, String gameId, String operateBy) throws GameUserException {
        if (gameId == null) {
            gameId = "";
        }
        byte[] sn = new byte[2];
        this.random.nextBytes(sn);
        byte[] data = new byte[72];
        data[0] = sn[0];
        data[1] = sn[1];
        System.arraycopy(rmBLKCommandBytes, 0, data, 2, 10);
        user = CommonUtil.formatString((String)user, (int)20, (char)' ', (boolean)true);
        gameId = CommonUtil.formatString((String)gameId, (int)20, (char)' ', (boolean)true);
        operateBy = CommonUtil.formatString((String)operateBy, (int)20, (char)' ', (boolean)true);
        System.arraycopy(user.getBytes(), 0, data, 12, 20);
        System.arraycopy(gameId.getBytes(), 0, data, 32, 20);
        System.arraycopy(operateBy.getBytes(), 0, data, 52, 20);
        byte[] lengthBytes = CommonUtil.intToByteArray((int)data.length);
        Socket socket = null;
        try {
            socket = new Socket(this.socketAddress, this.port);
            socket.setReuseAddress(true);
            socket.setSoLinger(false, 0);
            socket.setSoTimeout(this.timeout);
            InputStream input = socket.getInputStream();
            OutputStream output = socket.getOutputStream();
            output.write(lengthBytes);
            output.write(data);
            byte[] readLengthBytes = new byte[4];
            input.read(readLengthBytes);
            int readLength = CommonUtil.byteArrayToInt((byte[])readLengthBytes);
            if (readLength <= 0 || readLength > 1024) {
                this.logger.error((Object)("Invalid package length: " + readLength));
                boolean bl = false;
                return bl;
            }
            byte[] readData = new byte[readLength];
            input.read(readData);
            byte[] readSn = new byte[]{readData[0], readData[1]};
            if (readSn[0] != sn[0] || readSn[1] != sn[1]) {
                this.logger.error((Object)"Invalid sn. ");
                boolean bl = false;
                return bl;
            }
            byte[] returnCode = new byte[4];
            System.arraycopy(readData, 2, returnCode, 0, 4);
            if (returnCode[0] == 48 && returnCode[1] == 48 && returnCode[2] == 48 && returnCode[3] == 48) {
                boolean e = true;
                return e;
            }
            try {
                this.logger.info((Object)("remove black user failed:" + new String(readData, 6, readData.length - 6, "GBK")));
            }
            catch (UnsupportedEncodingException e) {
                this.logger.info((Object)"GBK not supported.", (Throwable)e);
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e1) {
            throw new GameUserException(e1);
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<String> getBlkList(String gameId) throws GameUserException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 27[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean addEdcstUsr(String user, String gameId, String operateBy) throws GameUserException {
        byte[] sn = new byte[2];
        this.random.nextBytes(sn);
        byte[] data = new byte[72];
        data[0] = sn[0];
        data[1] = sn[1];
        System.arraycopy(addEdcstCommandBytes, 0, data, 2, 10);
        user = CommonUtil.formatString((String)user, (int)20, (char)' ', (boolean)true);
        gameId = CommonUtil.formatString((String)gameId, (int)20, (char)' ', (boolean)true);
        operateBy = CommonUtil.formatString((String)operateBy, (int)20, (char)' ', (boolean)true);
        System.arraycopy(user.getBytes(), 0, data, 12, 20);
        System.arraycopy(gameId.getBytes(), 0, data, 32, 20);
        System.arraycopy(operateBy.getBytes(), 0, data, 52, 20);
        byte[] lengthBytes = CommonUtil.intToByteArray((int)data.length);
        Socket socket = null;
        try {
            socket = new Socket(this.socketAddress, this.port);
            socket.setReuseAddress(true);
            socket.setSoLinger(false, 0);
            socket.setSoTimeout(this.timeout);
            InputStream input = socket.getInputStream();
            OutputStream output = socket.getOutputStream();
            output.write(lengthBytes);
            output.write(data);
            byte[] readLengthBytes = new byte[4];
            input.read(readLengthBytes);
            int readLength = CommonUtil.byteArrayToInt((byte[])readLengthBytes);
            if (readLength <= 0 || readLength > 1024) {
                this.logger.error((Object)("Invalid package length: " + readLength));
                boolean bl = false;
                return bl;
            }
            byte[] readData = new byte[readLength];
            input.read(readData);
            byte[] readSn = new byte[]{readData[0], readData[1]};
            if (readSn[0] != sn[0] || readSn[1] != sn[1]) {
                this.logger.error((Object)"Invalid sn. ");
                boolean bl = false;
                return bl;
            }
            byte[] returnCode = new byte[4];
            System.arraycopy(readData, 2, returnCode, 0, 4);
            if (returnCode[0] == 48 && returnCode[1] == 48 && returnCode[2] == 48 && returnCode[3] == 48) {
                boolean e = true;
                return e;
            }
            try {
                this.logger.info((Object)("add enabledcustomer user failed:" + new String(readData, 6, readData.length - 6, "GBK")));
            }
            catch (UnsupportedEncodingException e) {
                this.logger.info((Object)"GBK not supported.", (Throwable)e);
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e1) {
            throw new GameUserException(e1);
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean rmEdcstUsr(String user, String gameId, String operateBy) throws GameUserException {
        byte[] sn = new byte[2];
        this.random.nextBytes(sn);
        byte[] data = new byte[72];
        data[0] = sn[0];
        data[1] = sn[1];
        System.arraycopy(rmEdcstCommandBytes, 0, data, 2, 10);
        user = CommonUtil.formatString((String)user, (int)20, (char)' ', (boolean)true);
        gameId = CommonUtil.formatString((String)gameId, (int)20, (char)' ', (boolean)true);
        operateBy = CommonUtil.formatString((String)operateBy, (int)20, (char)' ', (boolean)true);
        System.arraycopy(user.getBytes(), 0, data, 12, 20);
        System.arraycopy(gameId.getBytes(), 0, data, 32, 20);
        System.arraycopy(operateBy.getBytes(), 0, data, 52, 20);
        byte[] lengthBytes = CommonUtil.intToByteArray((int)data.length);
        Socket socket = null;
        try {
            socket = new Socket(this.socketAddress, this.port);
            socket.setReuseAddress(true);
            socket.setSoLinger(false, 0);
            socket.setSoTimeout(this.timeout);
            InputStream input = socket.getInputStream();
            OutputStream output = socket.getOutputStream();
            output.write(lengthBytes);
            output.write(data);
            byte[] readLengthBytes = new byte[4];
            input.read(readLengthBytes);
            int readLength = CommonUtil.byteArrayToInt((byte[])readLengthBytes);
            if (readLength <= 0 || readLength > 1024) {
                this.logger.error((Object)("Invalid package length: " + readLength));
                boolean bl = false;
                return bl;
            }
            byte[] readData = new byte[readLength];
            input.read(readData);
            byte[] readSn = new byte[]{readData[0], readData[1]};
            if (readSn[0] != sn[0] || readSn[1] != sn[1]) {
                this.logger.error((Object)"Invalid sn. ");
                boolean bl = false;
                return bl;
            }
            byte[] returnCode = new byte[4];
            System.arraycopy(readData, 2, returnCode, 0, 4);
            if (returnCode[0] == 48 && returnCode[1] == 48 && returnCode[2] == 48 && returnCode[3] == 48) {
                boolean e = true;
                return e;
            }
            try {
                this.logger.info((Object)("remove enabledcustomer user failed:" + new String(readData, 6, readData.length - 6, "GBK")));
            }
            catch (UnsupportedEncodingException e) {
                this.logger.info((Object)"GBK not supported.", (Throwable)e);
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e1) {
            throw new GameUserException(e1);
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean clrEdcstUsr(String gameId, String operateBy) throws GameUserException {
        byte[] sn = new byte[2];
        this.random.nextBytes(sn);
        byte[] data = new byte[52];
        data[0] = sn[0];
        data[1] = sn[1];
        System.arraycopy(clrEdcstCommandBytes, 0, data, 2, 10);
        gameId = CommonUtil.formatString((String)gameId, (int)20, (char)' ', (boolean)true);
        operateBy = CommonUtil.formatString((String)operateBy, (int)20, (char)' ', (boolean)true);
        System.arraycopy(gameId.getBytes(), 0, data, 12, 20);
        System.arraycopy(operateBy.getBytes(), 0, data, 32, 20);
        byte[] lengthBytes = CommonUtil.intToByteArray((int)data.length);
        Socket socket = null;
        try {
            socket = new Socket(this.socketAddress, this.port);
            socket.setReuseAddress(true);
            socket.setSoLinger(false, 0);
            socket.setSoTimeout(this.timeout);
            InputStream input = socket.getInputStream();
            OutputStream output = socket.getOutputStream();
            output.write(lengthBytes);
            output.write(data);
            byte[] readLengthBytes = new byte[4];
            input.read(readLengthBytes);
            int readLength = CommonUtil.byteArrayToInt((byte[])readLengthBytes);
            if (readLength <= 0 || readLength > 1024) {
                this.logger.error((Object)("Invalid package length: " + readLength));
                boolean bl = false;
                return bl;
            }
            byte[] readData = new byte[readLength];
            input.read(readData);
            byte[] readSn = new byte[]{readData[0], readData[1]};
            if (readSn[0] != sn[0] || readSn[1] != sn[1]) {
                this.logger.error((Object)"Invalid sn. ");
                boolean bl = false;
                return bl;
            }
            byte[] returnCode = new byte[4];
            System.arraycopy(readData, 2, returnCode, 0, 4);
            if (returnCode[0] == 48 && returnCode[1] == 48 && returnCode[2] == 48 && returnCode[3] == 48) {
                boolean e = true;
                return e;
            }
            try {
                this.logger.info((Object)("remove enabledcustomer user failed:" + new String(readData, 6, readData.length - 6, "GBK")));
            }
            catch (UnsupportedEncodingException e) {
                this.logger.info((Object)"GBK not supported.", (Throwable)e);
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e1) {
            throw new GameUserException(e1);
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<String> getEdcstList(String gameId) throws GameUserException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 27[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean checkAndUpdPwd(String user, String password) throws GameUserException {
        byte[] sn = new byte[2];
        this.random.nextBytes(sn);
        byte[] data = new byte[52];
        data[0] = sn[0];
        data[1] = sn[1];
        System.arraycopy(checkAndUpdPwdCommandBytes, 0, data, 2, 10);
        user = CommonUtil.formatString((String)user, (int)20, (char)' ', (boolean)true);
        password = CommonUtil.formatString((String)password, (int)20, (char)' ', (boolean)true);
        System.arraycopy(user.getBytes(), 0, data, 12, 20);
        System.arraycopy(password.getBytes(), 0, data, 32, 20);
        byte[] lengthBytes = CommonUtil.intToByteArray((int)data.length);
        Socket socket = null;
        try {
            socket = new Socket(this.socketAddress, this.port);
            socket.setReuseAddress(true);
            socket.setSoLinger(false, 0);
            socket.setSoTimeout(this.timeout);
            InputStream input = socket.getInputStream();
            OutputStream output = socket.getOutputStream();
            output.write(lengthBytes);
            output.write(data);
            byte[] readLengthBytes = new byte[4];
            input.read(readLengthBytes);
            int readLength = CommonUtil.byteArrayToInt((byte[])readLengthBytes);
            if (readLength <= 0 || readLength > 1024) {
                this.logger.error((Object)("Invalid package length: " + readLength));
                boolean bl = false;
                return bl;
            }
            byte[] readData = new byte[readLength];
            input.read(readData);
            byte[] readSn = new byte[]{readData[0], readData[1]};
            if (readSn[0] != sn[0] || readSn[1] != sn[1]) {
                this.logger.error((Object)"Invalid sn. ");
                boolean bl = false;
                return bl;
            }
            byte[] returnCode = new byte[4];
            System.arraycopy(readData, 2, returnCode, 0, 4);
            if (returnCode[0] == 48 && returnCode[1] == 48 && returnCode[2] == 48 && returnCode[3] == 48) {
                boolean e = true;
                return e;
            }
            try {
                this.logger.info((Object)("checkAndUpdPwd password failed:" + new String(readData, 6, readData.length - 6, "GBK")));
            }
            catch (UnsupportedEncodingException e) {
                this.logger.info((Object)"GBK not supported.", (Throwable)e);
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e1) {
            throw new GameUserException(e1);
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int qryUsertype(String userAccount) throws GameUserException {
        byte[] sn = new byte[2];
        this.random.nextBytes(sn);
        byte[] data = new byte[32];
        System.arraycopy(sn, 0, data, 0, 2);
        System.arraycopy(qryUtypeCommandBytes, 0, data, 2, 10);
        if (userAccount == null) return -1;
        userAccount = CommonUtil.formatString((String)userAccount, (int)20, (char)' ', (boolean)true);
        System.arraycopy(userAccount.getBytes(), 0, data, 12, 20);
        byte[] lengthBytes = CommonUtil.intToByteArray((int)data.length);
        Socket socket = null;
        try {
            socket = new Socket(this.socketAddress, this.port);
            socket.setReuseAddress(true);
            socket.setSoLinger(false, 0);
            socket.setSoTimeout(this.timeout);
            InputStream input = socket.getInputStream();
            OutputStream output = socket.getOutputStream();
            output.write(lengthBytes);
            output.write(data);
            byte[] readLengthBytes = new byte[4];
            input.read(readLengthBytes);
            int readLength = CommonUtil.byteArrayToInt((byte[])readLengthBytes);
            if (readLength <= 0 || readLength > 1024) {
                this.logger.error((Object)("Invalid package length: " + readLength));
                int n = -2;
                return n;
            }
            byte[] readData = new byte[readLength];
            input.read(readData);
            byte[] readSn = new byte[]{readData[0], readData[1]};
            if (readSn[0] != sn[0] || readSn[1] != sn[1]) {
                this.logger.error((Object)"Invalid sn. ");
                int n = -2;
                return n;
            }
            byte[] code = new byte[4];
            System.arraycopy(readData, 2, code, 0, 4);
            int cd = Integer.parseInt(new String(code));
            if (cd == 0 && readData.length >= 10) {
                byte[] usertype = new byte[4];
                System.arraycopy(readData, 6, usertype, 0, 4);
                int n = Integer.parseInt(new String(usertype));
                return n;
            }
            int n = -2;
            return n;
        }
        catch (Exception e1) {
            throw new GameUserException(e1);
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int regisUser(String user, String password, String nickname, String email, String passquestion, String passwdanswer) throws GameUserException {
        if (user == null) return 404;
        if ("".equals(user.trim())) return 404;
        if (nickname == null) return 404;
        if ("".equals(nickname.trim())) return 404;
        if (password == null) return 404;
        if ("".equals(password.trim())) return 404;
        if (email == null) return 404;
        if ("".equals(email.trim())) {
            return 404;
        }
        if (passquestion == null) {
            passquestion = "";
        }
        if (passwdanswer == null) {
            passwdanswer = "";
        }
        if (user.trim().length() < 6) {
            throw new GameUserException(user + " length less than 6.");
        }
        user = user.replace(":", "%3A").replace("\t", "%09").replace("\n", "%0A").replace("%", "%37");
        nickname = nickname.replace(":", "%3A").replace("\t", "%09").replace("\n", "%0A").replace("%", "%37");
        email = email.replace(":", "%3A").replace("\t", "%09").replace("\n", "%0A").replace("%", "%37");
        passquestion = passquestion.replace(":", "%3A").replace("\t", "%09").replace("\n", "%0A").replace("%", "%37");
        passwdanswer = passwdanswer.replace(":", "%3A").replace("\t", "%09").replace("\n", "%0A").replace("%", "%37");
        password = CommonUtil.byteArrayToHexString((byte[])MD5Util.MD5Encode((byte[])password.getBytes())).toLowerCase();
        password = CommonUtil.byteArrayToHexString((byte[])MD5Util.MD5Encode((byte[])password.getBytes())).toLowerCase();
        user = CommonUtil.formatString((String)user, (int)20, (char)' ', (boolean)true);
        nickname = CommonUtil.formatString((String)nickname, (int)20, (char)' ', (boolean)true);
        email = CommonUtil.formatString((String)email, (int)30, (char)' ', (boolean)true);
        passquestion = CommonUtil.formatString((String)passquestion, (int)50, (char)' ', (boolean)true);
        passwdanswer = CommonUtil.formatString((String)passwdanswer, (int)50, (char)' ', (boolean)true);
        byte[] sn = new byte[2];
        this.random.nextBytes(sn);
        byte[] data = new byte[214];
        data[0] = sn[0];
        data[1] = sn[1];
        System.arraycopy(regis_UsrCommandBytes, 0, data, 2, 10);
        try {
            System.arraycopy(user.getBytes(charset), 0, data, 12, 20);
            System.arraycopy(password.getBytes(charset), 0, data, 32, 32);
            System.arraycopy(nickname.getBytes(charset), 0, data, 64, 20);
            System.arraycopy(email.getBytes(charset), 0, data, 84, 30);
            System.arraycopy(passquestion.getBytes(charset), 0, data, 114, 50);
            System.arraycopy(passwdanswer.getBytes(charset), 0, data, 164, 50);
        }
        catch (UnsupportedEncodingException e2) {
            throw new GameUserException(e2);
        }
        byte[] lengthBytes = CommonUtil.intToByteArray((int)data.length);
        Socket socket = null;
        try {
            socket = new Socket(this.socketAddress, this.port);
            socket.setReuseAddress(true);
            socket.setSoLinger(false, 0);
            socket.setSoTimeout(this.timeout);
            InputStream input = socket.getInputStream();
            OutputStream output = socket.getOutputStream();
            output.write(lengthBytes);
            output.write(data);
            byte[] readLengthBytes = new byte[4];
            input.read(readLengthBytes);
            int readLength = CommonUtil.byteArrayToInt((byte[])readLengthBytes);
            if (readLength <= 0) {
                this.logger.error((Object)("Invalid package length: " + readLength));
                int n = 500;
                return n;
            }
            byte[] readData = new byte[readLength];
            input.read(readData);
            byte[] readSn = new byte[]{readData[0], readData[1]};
            if (readSn[0] != sn[0] || readSn[1] != sn[1]) {
                this.logger.error((Object)"Invalid sn. ");
                int n = 500;
                return n;
            }
            byte[] returnCode = new byte[4];
            System.arraycopy(readData, 2, returnCode, 0, 4);
            String retCode = new String(returnCode).trim();
            int n = Integer.parseInt(retCode);
            return n;
        }
        catch (Exception e1) {
            throw new GameUserException(e1);
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {}
            }
        }
    }

    @Override
    public int register(XLUsrInfo info) throws GameUserException {
        GameUserCentreClient client = new GameUserCentreClient(this.socketAddress, this.port, this.timeout);
        return client.register(info);
    }

    @Override
    public int regisUser(String user, String password, String nickname) throws GameUserException {
        return this.regisUser(user, password, nickname, "email", "question", "answer");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int checkXLUsr(String user) throws GameUserException {
        if (user == null) return 500;
        if ("".equals(user.trim())) {
            return 500;
        }
        user = ProxyUtil.escapeForbidChar(user);
        byte[] sn = new byte[2];
        this.random.nextBytes(sn);
        byte[] data = new byte[32];
        data[0] = sn[0];
        data[1] = sn[1];
        System.arraycopy(checkXLUsrCommandBytes, 0, data, 2, 10);
        user = CommonUtil.formatString((String)user, (int)20, (char)' ', (boolean)true);
        System.arraycopy(user.getBytes(), 0, data, 12, 20);
        byte[] lengthBytes = CommonUtil.intToByteArray((int)data.length);
        Socket socket = null;
        try {
            socket = new Socket(this.socketAddress, this.port);
            socket.setReuseAddress(true);
            socket.setSoLinger(false, 0);
            socket.setSoTimeout(this.timeout);
            InputStream input = socket.getInputStream();
            OutputStream output = socket.getOutputStream();
            output.write(lengthBytes);
            output.write(data);
            byte[] readLengthBytes = new byte[4];
            input.read(readLengthBytes);
            int readLength = CommonUtil.byteArrayToInt((byte[])readLengthBytes);
            if (readLength <= 0) {
                this.logger.error((Object)("Invalid package length: " + readLength));
                int n = 500;
                return n;
            }
            byte[] readData = new byte[readLength];
            input.read(readData);
            byte[] readSn = new byte[]{readData[0], readData[1]};
            if (readSn[0] != sn[0] || readSn[1] != sn[1]) {
                this.logger.error((Object)"Invalid sn. ");
                int n = 500;
                return n;
            }
            byte[] returnCode = new byte[4];
            System.arraycopy(readData, 2, returnCode, 0, 4);
            String retCode = new String(returnCode).trim();
            int n = Integer.parseInt(retCode);
            return n;
        }
        catch (Exception e1) {
            throw new GameUserException(e1);
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int authenticateUsers(String user, String password, String sourceId, boolean checkAdult, int invokeBy) throws GameUserException {
        if (sourceId == null) {
            sourceId = "";
        }
        byte[] sn = new byte[2];
        this.random.nextBytes(sn);
        byte[] data = new byte[76];
        data[0] = sn[0];
        data[1] = sn[1];
        System.arraycopy(authCommandBytes, 0, data, 2, 10);
        user = CommonUtil.formatString((String)user, (int)20, (char)' ', (boolean)true);
        password = CommonUtil.formatString((String)password, (int)20, (char)' ', (boolean)true);
        sourceId = CommonUtil.formatString((String)sourceId, (int)20, (char)' ', (boolean)true);
        System.arraycopy(user.getBytes(), 0, data, 12, 20);
        System.arraycopy(password.getBytes(), 0, data, 32, 20);
        System.arraycopy(sourceId.getBytes(), 0, data, 52, 20);
        String t = String.valueOf(invokeBy);
        String utype = "0000".substring(t.length()) + t;
        System.arraycopy(utype.getBytes(), 0, data, 72, 4);
        byte[] lengthBytes = CommonUtil.intToByteArray((int)data.length);
        Socket socket = null;
        try {
            socket = new Socket(this.socketAddress, this.port);
            socket.setReuseAddress(true);
            socket.setSoLinger(false, 0);
            socket.setSoTimeout(this.timeout);
            InputStream input = socket.getInputStream();
            OutputStream output = socket.getOutputStream();
            output.write(lengthBytes);
            output.write(data);
            byte[] readLengthBytes = new byte[4];
            input.read(readLengthBytes);
            int readLength = CommonUtil.byteArrayToInt((byte[])readLengthBytes);
            if (readLength <= 0 || readLength > 1024) {
                this.logger.error((Object)("Invalid package length: " + readLength));
                int n = 5;
                return n;
            }
            byte[] readData = new byte[readLength];
            input.read(readData);
            byte[] readSn = new byte[]{readData[0], readData[1]};
            if (readSn[0] != sn[0] || readSn[1] != sn[1]) {
                this.logger.error((Object)"Invalid sn. ");
                int n = 5;
                return n;
            }
            byte[] returnCode = new byte[4];
            System.arraycopy(readData, 2, returnCode, 0, 4);
            String retCode = new String(returnCode);
            int code = Integer.parseInt(retCode);
            if (!checkAdult && code == 8) {
                code = 0;
            }
            int n = code;
            return n;
        }
        catch (Exception e1) {
            throw new GameUserException(e1);
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean reTakePass(String user, String password, boolean isDigitalUser) throws GameUserException {
        if (user == null) return false;
        if ("".equals(user.trim())) return false;
        if (password == null) return false;
        if ("".equals(password.trim())) {
            return false;
        }
        user = user.replace(":", "%3A").replace("\t", "%09").replace("\n", "%0A").replace("%", "%37");
        password = CommonUtil.byteArrayToHexString((byte[])MD5Util.MD5Encode((byte[])password.getBytes())).toLowerCase();
        password = CommonUtil.byteArrayToHexString((byte[])MD5Util.MD5Encode((byte[])password.getBytes())).toLowerCase();
        user = CommonUtil.formatString((String)user, (int)20, (char)' ', (boolean)true);
        byte[] sn = new byte[2];
        this.random.nextBytes(sn);
        byte[] data = new byte[65];
        data[0] = sn[0];
        data[1] = sn[1];
        System.arraycopy(reTakePassCommandBytes, 0, data, 2, 10);
        try {
            System.arraycopy(user.getBytes(charset), 0, data, 12, 20);
            System.arraycopy(password.getBytes(charset), 0, data, 32, 32);
            if (isDigitalUser) {
                System.arraycopy(new byte[]{1}, 0, data, 64, 1);
            } else {
                System.arraycopy(new byte[]{0}, 0, data, 64, 1);
            }
        }
        catch (UnsupportedEncodingException e2) {
            throw new GameUserException(e2);
        }
        byte[] lengthBytes = CommonUtil.intToByteArray((int)data.length);
        Socket socket = null;
        try {
            socket = new Socket(this.socketAddress, this.port);
            socket.setReuseAddress(true);
            socket.setSoLinger(false, 0);
            socket.setSoTimeout(this.timeout);
            InputStream input = socket.getInputStream();
            OutputStream output = socket.getOutputStream();
            output.write(lengthBytes);
            output.write(data);
            byte[] readLengthBytes = new byte[4];
            input.read(readLengthBytes);
            int readLength = CommonUtil.byteArrayToInt((byte[])readLengthBytes);
            if (readLength <= 0) {
                this.logger.error((Object)("Invalid package length: " + readLength));
                boolean bl = false;
                return bl;
            }
            byte[] readData = new byte[readLength];
            input.read(readData);
            byte[] readSn = new byte[]{readData[0], readData[1]};
            if (readSn[0] != sn[0] || readSn[1] != sn[1]) {
                this.logger.error((Object)"Invalid sn. ");
                boolean bl = false;
                return bl;
            }
            byte[] returnCode = new byte[4];
            System.arraycopy(readData, 2, returnCode, 0, 4);
            String retCode = new String(returnCode).trim();
            if ("200".equals(retCode)) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e1) {
            throw new GameUserException(e1);
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private byte[] commonRequest(byte[] lengthBytes, byte[] data) throws GameUserException {
        byte[] requestByte = new byte[lengthBytes.length + data.length];
        System.arraycopy(lengthBytes, 0, requestByte, 0, lengthBytes.length);
        System.arraycopy(data, 0, requestByte, lengthBytes.length, data.length);
        return this.commonRequest(requestByte);
    }

    private byte[] commonRequest(byte[] requestBytes) throws GameUserException {
        Socket socket = null;
        try {
            socket = new Socket(this.socketAddress, this.port);
            socket.setReuseAddress(true);
            socket.setSoLinger(false, 0);
            socket.setSoTimeout(this.timeout);
            InputStream input = socket.getInputStream();
            OutputStream output = socket.getOutputStream();
            output.write(requestBytes);
            byte[] readLengthBytes = new byte[4];
            input.read(readLengthBytes);
            int readLength = CommonUtil.byteArrayToInt((byte[])readLengthBytes);
            if (readLength <= 0) {
                throw new GameUserException("Invalid package length: " + readLength);
            }
            byte[] readData = new byte[readLength];
            input.read(readData);
            byte[] retByte = new byte[4 + readData.length];
            System.arraycopy(readLengthBytes, 0, retByte, 0, 4);
            System.arraycopy(readData, 0, retByte, 4, readData.length);
            byte[] byArray = retByte;
            return byArray;
        }
        catch (Exception e) {
            throw new GameUserException(e);
        }
        finally {
            try {
                if (socket != null) {
                    socket.close();
                }
            }
            catch (Exception e) {}
        }
    }

    @Override
    public String digiAotuGen() throws GameUserException {
        byte[] sn = new byte[2];
        this.random.nextBytes(sn);
        byte[] data = new byte[65];
        data[0] = sn[0];
        data[1] = sn[1];
        System.arraycopy(GEN_DIGICommandBytes, 0, data, 2, 10);
        byte[] lengthBytes = CommonUtil.intToByteArray((int)data.length);
        try {
            byte[] retByte = this.commonRequest(lengthBytes, data);
            byte[] readLengthBytes = new byte[4];
            System.arraycopy(retByte, 0, readLengthBytes, 0, 4);
            int readLength = CommonUtil.byteArrayToInt((byte[])readLengthBytes);
            byte[] readData = new byte[readLength];
            System.arraycopy(retByte, 4, readData, 0, readLength);
            byte[] readSn = new byte[]{readData[0], readData[1]};
            if (readSn[0] != sn[0] || readSn[1] != sn[1]) {
                throw new GameUserException("Invalid sn. ");
            }
            byte[] returnCode = new byte[4];
            System.arraycopy(readData, 2, returnCode, 0, 4);
            String retCode = new String(returnCode).trim();
            if ("0000".equals(retCode)) {
                return new String(readData, 6, readData.length - 6).trim();
            }
            return null;
        }
        catch (Exception e1) {
            throw new GameUserException(e1);
        }
    }

    @Override
    public List<String> digiRecommended(String account) throws GameUserException {
        for (int i = 0; i < account.length(); ++i) {
            if (Character.isDigit(account.charAt(i))) continue;
            throw new GameUserException(account + " IS not all digit number.");
        }
        byte[] sn = new byte[2];
        this.random.nextBytes(sn);
        byte[] data = new byte[23];
        data[0] = sn[0];
        data[1] = sn[1];
        System.arraycopy(RECM_DIGICommandBytes, 0, data, 2, 10);
        account = CommonUtil.formatString((String)account, (int)11, (char)' ', (boolean)true);
        System.arraycopy(account.getBytes(), 0, data, 12, 11);
        byte[] lengthBytes = CommonUtil.intToByteArray((int)data.length);
        try {
            byte[] retByte = this.commonRequest(lengthBytes, data);
            byte[] readLengthBytes = new byte[4];
            System.arraycopy(retByte, 0, readLengthBytes, 0, 4);
            int readLength = CommonUtil.byteArrayToInt((byte[])readLengthBytes);
            byte[] readData = new byte[readLength];
            System.arraycopy(retByte, 4, readData, 0, readLength);
            byte[] readSn = new byte[]{readData[0], readData[1]};
            if (readSn[0] != sn[0] || readSn[1] != sn[1]) {
                throw new GameUserException("Invalid sn. ");
            }
            byte[] returnCode = new byte[4];
            System.arraycopy(readData, 2, returnCode, 0, 4);
            String retCode = new String(returnCode).trim();
            if ("0000".equals(retCode)) {
                String idstr = new String(readData, 6, readData.length - 6).trim();
                String[] ids = idstr.split("\t");
                return Arrays.asList(ids);
            }
            return null;
        }
        catch (Exception e1) {
            throw new GameUserException(e1);
        }
    }

    private int digiNotExcel(String account) throws GameUserException {
        throw new GameUserException("the digit no is not allowed registe.");
    }

    @Override
    @Deprecated
    public int digiCanRegis(String account) throws GameUserException {
        return 3;
    }

    @Override
    public XLUsrInfo getXLUsrInfo(String user) throws GameUserException {
        return this.getXLUsrInfo(user, 0);
    }

    @Override
    public XLUsrInfo getXLUsrInfoOld(String user) throws GameUserException {
        return this.getXLUsrInfo(user, 0);
    }

    @Override
    public XLUsrInfo getXLUsrInfoNew(String user) throws GameUserException {
        return this.getXLUsrInfo(user, 1);
    }

    @Override
    public int rmAllMem() throws GameUserException {
        return this.rmMemUsr("RM_ALL");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int rmMemUsr(String user) throws GameUserException {
        if (user == null) return 3;
        if ("".equals(user.trim())) {
            return 3;
        }
        byte[] sn = new byte[2];
        this.random.nextBytes(sn);
        byte[] data = new byte[32];
        data[0] = sn[0];
        data[1] = sn[1];
        System.arraycopy(rmMemCommandBytes, 0, data, 2, 10);
        user = CommonUtil.formatString((String)user, (int)20, (char)' ', (boolean)true);
        System.arraycopy(user.getBytes(), 0, data, 12, 20);
        byte[] lengthBytes = CommonUtil.intToByteArray((int)data.length);
        Socket socket = null;
        try {
            socket = new Socket(this.socketAddress, this.port);
            socket.setReuseAddress(true);
            socket.setSoLinger(false, 0);
            socket.setSoTimeout(this.timeout);
            InputStream input = socket.getInputStream();
            OutputStream output = socket.getOutputStream();
            output.write(lengthBytes);
            output.write(data);
            byte[] readLengthBytes = new byte[4];
            input.read(readLengthBytes);
            int readLength = CommonUtil.byteArrayToInt((byte[])readLengthBytes);
            if (readLength <= 0) {
                this.logger.error((Object)("Invalid package length: " + readLength));
                int n = 500;
                return n;
            }
            byte[] readData = new byte[readLength];
            input.read(readData);
            byte[] readSn = new byte[]{readData[0], readData[1]};
            if (readSn[0] != sn[0] || readSn[1] != sn[1]) {
                this.logger.error((Object)"Invalid sn. ");
                int n = 500;
                return n;
            }
            byte[] returnCode = new byte[4];
            System.arraycopy(readData, 2, returnCode, 0, 4);
            String retCode = new String(returnCode).trim();
            this.logger.debug((Object)new String(readData, 6, readLength - 6));
            int n = Integer.parseInt(retCode);
            return n;
        }
        catch (Exception e1) {
            throw new GameUserException(e1);
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {}
            }
        }
    }

    @Override
    public int insDelUid(String user) throws GameUserException {
        return this.updUid(user, "insertaccount");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int updUid(String user, String deluid) throws GameUserException {
        if (user == null) return 3;
        if ("".equals(user.trim())) {
            return 3;
        }
        if (deluid == null) return 3;
        if ("".equals(deluid.trim())) {
            return 3;
        }
        byte[] sn = new byte[2];
        this.random.nextBytes(sn);
        byte[] data = new byte[48];
        data[0] = sn[0];
        data[1] = sn[1];
        System.arraycopy(upduidCommandBytes, 0, data, 2, 10);
        user = CommonUtil.formatString((String)user, (int)20, (char)' ', (boolean)true);
        System.arraycopy(user.getBytes(), 0, data, 12, 20);
        deluid = CommonUtil.formatString((String)deluid, (int)16, (char)' ', (boolean)true);
        System.arraycopy(deluid.getBytes(), 0, data, 32, 16);
        byte[] lengthBytes = CommonUtil.intToByteArray((int)data.length);
        Socket socket = null;
        try {
            socket = new Socket(this.socketAddress, this.port);
            socket.setReuseAddress(true);
            socket.setSoLinger(false, 0);
            socket.setSoTimeout(this.timeout);
            InputStream input = socket.getInputStream();
            OutputStream output = socket.getOutputStream();
            output.write(lengthBytes);
            output.write(data);
            byte[] readLengthBytes = new byte[4];
            input.read(readLengthBytes);
            int readLength = CommonUtil.byteArrayToInt((byte[])readLengthBytes);
            if (readLength <= 0) {
                this.logger.error((Object)("Invalid package length: " + readLength));
                int n = 500;
                return n;
            }
            byte[] readData = new byte[readLength];
            input.read(readData);
            byte[] readSn = new byte[]{readData[0], readData[1]};
            if (readSn[0] != sn[0] || readSn[1] != sn[1]) {
                this.logger.error((Object)"Invalid sn. ");
                int n = 500;
                return n;
            }
            byte[] returnCode = new byte[4];
            System.arraycopy(readData, 2, returnCode, 0, 4);
            String retCode = new String(returnCode).trim();
            this.logger.debug((Object)new String(readData, 6, readLength - 6));
            int n = Integer.parseInt(retCode);
            return n;
        }
        catch (Exception e1) {
            throw new GameUserException(e1);
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {}
            }
        }
    }

    @Override
    public RefergetInfo getUserInfoByRefid(String refid) throws GameUserException {
        XLUsrInfo xlusr = this.getXLUsrInfo(refid, 2);
        RefergetInfo refinfo = new RefergetInfo();
        if (xlusr != null) {
            String username = xlusr.getUsername();
            String userno = xlusr.getUsernewno();
            String usertran = null;
            if (username != null && !"".equals(username.trim())) {
                usertran = username;
            } else if (userno != null && !"".equals(userno.trim())) {
                usertran = userno;
            }
            if (usertran != null) {
                UserExistsResult useexists = this.userExistsNew(usertran);
                if (useexists != null && useexists.getCode() == 0) {
                    refinfo.setCode(0);
                    refinfo.setNewAccount(useexists.getNewAccount());
                    refinfo.setOldAccount(useexists.getOldAccount());
                    refinfo.setUserId(useexists.getUserId());
                    refinfo.setRefId(xlusr.getNo());
                    refinfo.setXlusrinfo(xlusr);
                } else if (useexists != null && useexists.getCode() != 0) {
                    int code = useexists.getCode();
                    refinfo.setCode(Integer.parseInt("1" + String.valueOf(code)));
                } else {
                    refinfo.setCode(1);
                }
            } else {
                refinfo.setCode(2);
            }
        } else {
            refinfo.setCode(3);
        }
        return refinfo;
    }

    @Override
    public int updateUserInfo(UserInfoDetail userinfo, int usertype) throws GameUserException {
        GameUserCentreClient client = new GameUserCentreClient(this.socketAddress, this.port, this.timeout);
        return client.updateUserInfo(userinfo, usertype);
    }

    @Override
    public AuthenticateResult authenticateUserNew(String account, String password, String sourceId, boolean checkAdult, int invokeBy) throws GameUserException {
        GameUserCentreClient client = new GameUserCentreClient(this.socketAddress, this.port, this.timeout);
        return client.userLogin(account, password, sourceId, checkAdult, invokeBy);
    }

    @Override
    public AuthenticateResult authenticateUserNew(String account, String password, String sourceId, boolean checkAdult) throws GameUserException {
        return this.authenticateUserNew(account, password, sourceId, checkAdult, 1);
    }

    @Override
    public AuthenticateResult authenticateUserNew(String account, String password, String sourceId) throws GameUserException {
        return this.authenticateUserNew(account, password, sourceId, false);
    }

    @Override
    public XLUsrInfo getXLUsrInfo(String username, int getflag) throws GameUserException {
        if (StringTools.isEmpty(username)) {
            throw new GameUserException("param is wrong");
        }
        username = username.trim();
        GameUserCentreClient client = new GameUserCentreClient(this.socketAddress, this.port, this.timeout);
        UserInfoDetail info = null;
        if (username.length() <= 20) {
            info = client.getUserInfoDetail(username, getflag);
        } else if (username.length() <= 60) {
            info = client.getUserInfoDetail60(username, getflag);
        } else {
            throw new GameUserException("The length of username is too long. The max value is 60.");
        }
        if (null != info) {
            if (info.getRetcode() == ConstantsRetCode.RETCODE_SUCCESS) {
                return info;
            }
            if (info.getRetcode() == ConstantsRetCode.RETCODE_USER_NOT_EXIST) {
                return null;
            }
            if (info.getRetcode() == ConstantsRetCode.RETCODE_PARAM_ERROR) {
                throw new GameUserException("param is wrong");
            }
            throw new GameUserException("Sys error");
        }
        throw new GameUserException("Sys error");
    }

    @Override
    public ResGameUserInfo getGameUserInfo(String username, int usertype) throws GameUserException {
        if (StringTools.isEmpty(username)) {
            throw new GameUserException("param is wrong");
        }
        username = username.trim();
        GameUserCentreClient client = new GameUserCentreClient(this.socketAddress, this.port, this.timeout);
        GameUserInfo info = null;
        ResGameUserInfo resInfo = new ResGameUserInfo();
        if (username.length() > 20) {
            throw new GameUserException("The length of username is too long. The max value is 20.");
        }
        info = client.getGameUserInfo(username, usertype);
        if (null != info) {
            if (info.getSeqid() > 0L) {
                resInfo.setRetcode(ConstantsRetCode.RETCODE_SUCCESS);
                resInfo.setGameUserInfo(info);
                return resInfo;
            }
            if (info.getSeqid() == -2L) {
                resInfo.setRetcode(ConstantsRetCode.RETCODE_USER_NOT_EXIST);
                return resInfo;
            }
            if (info.getSeqid() == -254L) {
                resInfo.setRetcode(ConstantsRetCode.RETCODE_PARAM_ERROR);
                return resInfo;
            }
            resInfo.setRetcode(ConstantsRetCode.RETCODE_SYS_ERROR);
            return resInfo;
        }
        throw new GameUserException("Sys error");
    }

    @Override
    public UserExistsResult userExistsNew(String username) throws GameUserException {
        return this.userExistsNew(username, this.socketAddress);
    }

    @Override
    public UserExistsResult userExistsNew(String username, String socketaddress) throws GameUserException {
        GameUserCentreClient client = new GameUserCentreClient(this.socketAddress, this.port, this.timeout);
        return client.userExists(username);
    }

    @Override
    public GetUserInfoByUserIdResult getUserInfoByUserId(String username) throws GameUserException {
        GameUserCentreClient client = new GameUserCentreClient(this.socketAddress, this.port, this.timeout);
        SimpleUserInfo info = client.getSimpleUserInfo(username, 50);
        GetUserInfoByUserIdResult result = new GetUserInfoByUserIdResult();
        if (info.getRetcode() == ConstantsRetCode.RETCODE_SUCCESS) {
            result.setNewAccount(info.getDigitno());
            result.setOldAccount(info.getOldusername());
            result.setUserId(info.getGameuserid());
            result.setCode(0);
        } else if (info.getRetcode() == ConstantsRetCode.RETCODE_USER_NOT_EXIST) {
            result.setCode(1);
        } else if (info.getRetcode() == ConstantsRetCode.RETCODE_PARAM_ERROR) {
            result.setCode(3);
        } else {
            throw new GameUserException("Sys error");
        }
        return result;
    }

    @Override
    public SimpleUserInfo getSimpleUserInfo(String username, int getflag) throws GameUserException {
        GameUserCentreClient client = new GameUserCentreClient(this.socketAddress, this.port, this.timeout);
        SimpleUserInfo info = client.getSimpleUserInfo(username, getflag);
        return info;
    }

    @Override
    public AuthenticateResult authenticateUserNewUsingEncodedPassword(String account, String password, String sourceId, boolean checkAdult) throws GameUserException {
        return this.authenticateUserNewUsingEncodedPassword(account, password, sourceId, checkAdult, 8);
    }

    @Override
    public AuthenticateResult authenticateUserNewUsingEncodedPassword(String account, String password, String sourceId) throws GameUserException {
        return this.authenticateUserNewUsingEncodedPassword(account, password, sourceId, false);
    }

    @Override
    public AuthenticateResult authenticateUserNewUsingEncodedPassword(String account, String password, String sourceId, boolean checkAdult, int invokeBy) throws GameUserException {
        GameUserCentreClient client = new GameUserCentreClient(this.socketAddress, this.port, this.timeout);
        return client.authenticateUserRemote(account, password, sourceId, checkAdult, invokeBy);
    }

    @Override
    public int queryVIPUser(String user) throws GameUserException {
        return this.queryVIPUser(user, false);
    }

    @Override
    public int queryVIPUser(String username, boolean isNewUser) throws GameUserException {
        GameUserCentreClient client = new GameUserCentreClient(this.socketAddress, this.port, this.timeout);
        return client.queryUserVipInfo(username, isNewUser ? 1 : 0);
    }

    @Override
    public int queryVIPUser(String username, int usertype) throws GameUserException {
        GameUserCentreClient client = new GameUserCentreClient(this.socketAddress, this.port, this.timeout);
        return client.queryUserVipInfo(username, usertype);
    }

    @Override
    @Deprecated
    public int digiRegisAccount(String account, String password, String nickname, String email, int sex) throws GameUserException {
        return 1;
    }

    @Override
    public int digiSetPassProt(String account, String secureEmail, String question, String answer, String truename, String cardno, String phone) throws GameUserException {
        GameUserCentreClient client = new GameUserCentreClient(this.socketAddress, this.port, this.timeout);
        return client.updateUserPwdSafeInfo(1, account, secureEmail, question, answer, truename, cardno, phone);
    }
}

