/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.riskcontrol.evaluator.engine;

import com.xunlei.channel.db.riskcontrol.dao.EvaluatorResultDAO;
import com.xunlei.channel.db.riskcontrol.dao.EvaluatorRuleDAO;
import com.xunlei.channel.db.riskcontrol.dao.PayOrderDAO;
import com.xunlei.channel.db.riskcontrol.dao.PayOrderOkDAO;
import com.xunlei.channel.db.riskcontrol.dao.RiskControlConfigDAO;
import com.xunlei.channel.db.riskcontrol.dao.RiskControlTaskRuleDAO;
import com.xunlei.channel.db.riskcontrol.pojo.EvaluatorResult;
import com.xunlei.channel.db.riskcontrol.pojo.EvaluatorRule;
import com.xunlei.channel.db.riskcontrol.pojo.PayOrder;
import com.xunlei.channel.db.riskcontrol.pojo.PayOrderOk;
import com.xunlei.channel.db.riskcontrol.pojo.RiskControlConfig;
import com.xunlei.channel.db.riskcontrol.pojo.RiskControlTaskRule;
import com.xunlei.channel.riskcontrol.evaluator.constant.FailType;
import com.xunlei.channel.riskcontrol.evaluator.constant.SuccessType;
import com.xunlei.channel.riskcontrol.evaluator.dto.EvaluatorResultDTO;
import com.xunlei.channel.riskcontrol.evaluator.exception.ServiceException;
import com.xunlei.channel.riskcontrol.evaluator.param.EvaluatorParam;
import com.xunlei.channel.riskcontrol.evaluator.result.EvaluatorResultFactory;
import com.xunlei.channel.riskcontrol.evaluator.result.RuleResult;
import com.xunlei.channel.thirdparty.vo.QueryResponse;
import com.xunlei.channel.thirdpartyquery.order.service.ThirdpartyQueryOrderService;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class EvaluatorEngine {
    private VelocityEngine velocityEngine = new VelocityEngine();
    private final Logger logger = LoggerFactory.getLogger(EvaluatorEngine.class);
    @Resource
    private PayOrderDAO payOrderDAO;
    @Resource
    private PayOrderOkDAO payOrderOkDAO;
    @Resource
    private ThirdpartyQueryOrderService thirdpartyQueryOrderService;
    @Resource
    private EvaluatorRuleDAO evaluatorRuleDAO;
    @Resource
    private EvaluatorResultDAO evaluatorResultDAO;
    @Resource
    private RiskControlTaskRuleDAO riskControlTaskRuleDAO;
    @Resource
    private RiskControlConfigDAO riskControlConfigDAO;

    public EvaluatorResultDTO evaluate(EvaluatorParam evaluatorParam) {
        this.validateParam(evaluatorParam);
        VelocityContext velocityContext = new VelocityContext();
        List<RiskControlTaskRule> riskControlTaskRules = this.getRiskControlTaskRules(evaluatorParam);
        for (RiskControlTaskRule riskControlTaskRule : riskControlTaskRules) {
            EvaluatorRule evaluatorRule = this.evaluatorRuleDAO.getEvaluatorRuleByRuleNo(riskControlTaskRule.getRuleNo());
            Map<String, Object> datasourceMap = this.getDataSourceByRule(evaluatorRule.getRuleValue(), evaluatorParam.getDataId(), velocityContext);
            RuleResult ruleResult = this.getRuleResult(velocityContext, datasourceMap, evaluatorRule.getRuleValue());
            this.handleRuleResult(ruleResult, evaluatorParam.getDataId(), riskControlTaskRule);
        }
        EvaluatorResultDTO dto = EvaluatorResultFactory.getSuccessEvaluatorResult(SuccessType.success200);
        return dto;
    }

    private Object getDataSourceByAlias(String alias, String dataId) {
        PayOrder obj = null;
        if ("payOrder".equals(alias) && (obj = this.payOrderDAO.getPayOrderByXunleiPayId(dataId)) != null) {
            this.logger.info("=====\u6211\u65b9=====" + obj.toString());
        }
        if ("payOrderOk".equals(alias) && (obj = this.payOrderOkDAO.getPayOrderOk(dataId)) != null) {
            this.logger.info("=====\u6211\u65b9=====" + ((PayOrderOk)obj).toString());
        }
        if ("queryResponse_payOrder".equals(alias)) {
            obj = this.thirdpartyQueryOrderService.queryOrder(dataId);
            if (obj != null) {
                this.logger.info("=====\u7b2c\u4e09\u65b9=====" + ((QueryResponse)obj).toString());
            } else {
                QueryResponse q = new QueryResponse();
                q.setQuerySuccess(false);
                q.setOrderPaid(false);
                obj = q;
            }
        }
        return obj;
    }

    private Map<String, Object> getDataSourceByRule(String rule, String dataId, VelocityContext velocityContext) {
        Set<String> dataSourceAliases = this.getDataSourceAliases(rule, velocityContext);
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String dataSourceAlias : dataSourceAliases) {
            Object obj = this.getDataSourceByAlias(dataSourceAlias, dataId);
            map.put(dataSourceAlias, obj);
        }
        return map;
    }

    private void fillVelocityContext(VelocityContext velocityContext, Map<String, Object> map) {
        Set<Map.Entry<String, Object>> entrySet = map.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            velocityContext.put(entry.getKey(), entry.getValue());
        }
    }

    private RuleResult getRuleResult(VelocityContext velocityContext, Map<String, Object> datasourceMap, String rule) {
        StringWriter output = new StringWriter();
        RuleResult ruleResult = new RuleResult();
        this.fillVelocityContext(velocityContext, datasourceMap);
        this.velocityEngine.evaluate((Context)velocityContext, (Writer)output, "EvaluatorEngine", rule);
        String outputString = output.toString().trim();
        String[] results = outputString.split("\\|\\|");
        int status = Integer.valueOf(results[0].trim());
        String code = results[1].trim();
        String msg = results[2].trim();
        ruleResult.setStatus(status);
        ruleResult.setCode(code);
        ruleResult.setMsg(msg);
        return ruleResult;
    }

    private void validateParam(EvaluatorParam evaluatorParam) {
        if (evaluatorParam == null || evaluatorParam.getDataId() == null || evaluatorParam.getTaskNo() == null) {
            throw new ServiceException(FailType.failParameterError);
        }
        RiskControlConfig riskControlConfig = this.riskControlConfigDAO.getRiskControlConfigByTaskNo(evaluatorParam.getTaskNo());
        PayOrder payOrder = this.payOrderDAO.getPayOrderByXunleiPayId(evaluatorParam.getDataId());
        if (riskControlConfig == null || payOrder == null) {
            throw new ServiceException(FailType.failParameterError);
        }
    }

    private List<RiskControlTaskRule> getRiskControlTaskRules(EvaluatorParam evaluatorParam) {
        ArrayList<RiskControlTaskRule> riskControlTaskRules = new ArrayList();
        Integer ruleOrder = this.evaluatorResultDAO.getCurrentRuleOrderByDataIdAndTaskNo(evaluatorParam.getDataId(), evaluatorParam.getTaskNo());
        if (ruleOrder == null) {
            ruleOrder = 1;
        }
        riskControlTaskRules = this.riskControlTaskRuleDAO.getRiskControlTaskRuleByTaskNoAndRuleOrder(evaluatorParam.getTaskNo(), ruleOrder);
        return riskControlTaskRules;
    }

    private void handleRuleResult(RuleResult ruleResult, String dataId, RiskControlTaskRule riskControlTaskRule) {
        EvaluatorResult evaluatorResult = new EvaluatorResult();
        evaluatorResult.setDataId(dataId);
        evaluatorResult.setTaskNo(riskControlTaskRule.getTaskNo());
        evaluatorResult.setRuleNo(riskControlTaskRule.getRuleNo());
        evaluatorResult.setRuleResult(Integer.valueOf(ruleResult.getStatus()));
        evaluatorResult.setRuleOrder(Integer.valueOf(riskControlTaskRule.getRuleOrder()));
        this.evaluatorResultDAO.addEvaluatorResult(evaluatorResult);
        if (0 == evaluatorResult.getRuleResult()) {
            throw new ServiceException(FailType.getFailType(ruleResult.getCode()));
        }
    }

    private Set<String> getDataSourceAliases(String rule, VelocityContext velocityContext) {
        HashSet<String> dataSourceAliases = new HashSet<String>();
        Matcher matcher = Pattern.compile("\\$\\{(.*?)(\\..*?)*\\}").matcher(rule);
        while (matcher.find()) {
            if (velocityContext.containsKey((Object)matcher.group(1))) continue;
            dataSourceAliases.add(matcher.group(1));
        }
        return dataSourceAliases;
    }
}

