/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.riskcontrol.evaluator.aspect;

import com.xunlei.channel.riskcontrol.evaluator.dto.EvaluatorResultDTO;
import com.xunlei.channel.riskcontrol.evaluator.exception.ServiceException;
import com.xunlei.channel.riskcontrol.evaluator.result.EvaluatorResultFactory;
import com.xunlei.channel.riskcontrol.evaluator.util.JsonUtil;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class LogAspect {
    String LogTemplate = "{method:%s,param:%s,return:%s,cost:%.3fms}";
    private final Logger logger = LoggerFactory.getLogger(LogAspect.class);

    @Pointcut(value="execution(* com.xunlei.channel.riskcontrol.evaluator.service.impl.*.*(..))")
    public void serviceAspect() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="serviceAspect()")
    public Object doArround(ProceedingJoinPoint joinPoint) {
        String info = "";
        String evaluatorResultDTOString = null;
        String params = "";
        long start = System.nanoTime();
        EvaluatorResultDTO evaluatorResultDTO = null;
        try {
            params = this.getParam(joinPoint);
            evaluatorResultDTO = (EvaluatorResultDTO)joinPoint.proceed();
            evaluatorResultDTOString = JsonUtil.toJson(evaluatorResultDTO);
        }
        catch (Throwable e) {
            try {
                if (e instanceof ServiceException && ((ServiceException)e).getFailType() != null) {
                    ServiceException ex = (ServiceException)e;
                    evaluatorResultDTO = EvaluatorResultFactory.getFailEvaluatorResult(ex.getFailType());
                } else {
                    e.printStackTrace();
                }
                try {
                    evaluatorResultDTOString = JsonUtil.toJson(evaluatorResultDTO);
                }
                catch (Exception e1) {
                    evaluatorResultDTOString = "{\"status\":0,\"code\":\"fail500\",\"msg\":\"\u7cfb\u7edf\u9519\u8bef\"}";
                    e1.printStackTrace();
                }
            }
            catch (Throwable throwable) {
                double cost = (double)(System.nanoTime() - start) * 1.0 / 1000000.0;
                info = String.format(this.LogTemplate, joinPoint.getSignature(), params, evaluatorResultDTOString, cost);
                this.logger.info(info);
                throw throwable;
            }
            double cost = (double)(System.nanoTime() - start) * 1.0 / 1000000.0;
            info = String.format(this.LogTemplate, joinPoint.getSignature(), params, evaluatorResultDTOString, cost);
            this.logger.info(info);
        }
        double cost = (double)(System.nanoTime() - start) * 1.0 / 1000000.0;
        info = String.format(this.LogTemplate, joinPoint.getSignature(), params, evaluatorResultDTOString, cost);
        this.logger.info(info);
        return evaluatorResultDTO;
    }

    private String getParam(ProceedingJoinPoint joinPoint) throws Exception {
        String params = "";
        if (joinPoint.getArgs() != null && joinPoint.getArgs().length > 0) {
            Object obj = joinPoint.getArgs()[0];
            params = JsonUtil.toJson(obj);
        }
        return params;
    }
}

