/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.riskcontrol.evaluator.eval;

import com.xunlei.channel.db.riskcontrol.pojo.PayOrderOk;
import com.xunlei.channel.riskcontrol.evaluator.constants.EvaluationCode;
import com.xunlei.channel.riskcontrol.evaluator.context.EvalContext;
import com.xunlei.channel.riskcontrol.evaluator.data.provider.AbstractProvider;
import com.xunlei.channel.riskcontrol.evaluator.data.provider.ProviderFactory;
import com.xunlei.channel.riskcontrol.evaluator.result.EvalResult;
import com.xunlei.channel.thirdparty.vo.QueryResponse;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class EvalEngine {
    private static final String LOG_TAG = "EvalEngine";
    private static final String SUCCESS = "SUCCESS";
    private static final String FAIL = "FAIL";
    private static final String IGNORE = "IGNORE";
    public static final String RESULT_SEPERATOR = "\\|\\|";
    private VelocityEngine ve = new VelocityEngine();
    private static final Logger logger = LoggerFactory.getLogger(EvalEngine.class);
    private static final String REGEX = "\\$\\{(.*?)(\\..*?)*\\}";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EvalResult eval(EvalContext context) {
        logger.info("EvalContext context id:{}", (Object)context.getId());
        VelocityContext velocityContext = new VelocityContext();
        String rule = context.getRule();
        Set<String> keys = EvalEngine.analyzeRule(rule);
        StringWriter output = new StringWriter();
        try {
            for (String key : keys) {
                AbstractProvider<?> provider = ProviderFactory.getProvider(key);
                if (provider == null) {
                    logger.error("Cant find data provider for id:" + key);
                    EvalResult evalResult = new EvalResult(false, false, "", "Cant find data provider for id:" + key);
                    return evalResult;
                }
                Object resultData = provider.getData(context);
                if (logger.isDebugEnabled()) {
                    logger.debug("resultData:{}", resultData);
                }
                if (resultData instanceof QueryResponse && null == resultData) {
                    logger.info("id {} third query method return null", (Object)context.getId());
                    EvalResult e = new EvalResult(false, false, EvaluationCode.ERROR_05.getCode(), EvaluationCode.ERROR_05.getMessage());
                    return e;
                }
                if (resultData instanceof PayOrderOk && null == resultData) {
                    logger.info("PayOrderOk id{} is null", (Object)context.getId());
                    EvalResult e = new EvalResult(false, false, EvaluationCode.ERROR_06.getCode(), EvaluationCode.ERROR_06.getMessage());
                    return e;
                }
                velocityContext.put(key, resultData);
            }
            this.ve.evaluate((Context)velocityContext, (Writer)output, LOG_TAG, rule);
            String result = output.toString().trim();
            String[] resultAndCodeAndMsg = result.split(RESULT_SEPERATOR);
            String evalResult = resultAndCodeAndMsg[0].trim();
            String code = "";
            String msg = "";
            if (resultAndCodeAndMsg.length > 1) {
                code = resultAndCodeAndMsg[1].trim();
            }
            if (resultAndCodeAndMsg.length > 2) {
                msg = resultAndCodeAndMsg[2].trim();
            }
            logger.info("result:{};evalResult:{}", (Object)result, (Object)evalResult);
            if (SUCCESS.equals(evalResult)) {
                EvalResult evalResult2 = new EvalResult(true, true, code, msg);
                return evalResult2;
            }
            if (FAIL.equals(evalResult)) {
                EvalResult evalResult3 = new EvalResult(true, false, code, msg);
                return evalResult3;
            }
            if (IGNORE.equals(evalResult)) {
                logger.info("ignore orderId:{},result:{}", (Object)context.getId(), (Object)result);
                EvalResult evalResult4 = null;
                return evalResult4;
            }
            EvalResult evalResult5 = new EvalResult(false, false, code, msg);
            return evalResult5;
        }
        catch (Exception e) {
            logger.error("EvalEngine eval error:", (Throwable)e);
            EvalResult evalResult = new EvalResult(false, false, EvaluationCode.ERROR_02.getCode(), EvaluationCode.ERROR_02.getMessage() + ";" + e.getMessage());
            return evalResult;
        }
        finally {
            try {
                output.close();
            }
            catch (Exception e) {
                logger.error("", (Throwable)e);
            }
        }
    }

    public static Set<String> analyzeRule(String rule) {
        HashSet<String> keys = new HashSet<String>();
        Matcher matcher = Pattern.compile(REGEX).matcher(rule);
        while (matcher.find()) {
            keys.add(matcher.group(1));
        }
        return keys;
    }
}

