/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.riskcontrol.evaluator.data.provider.impl;

import com.xunlei.channel.db.riskcontrol.dao.PayOrderDAO;
import com.xunlei.channel.db.riskcontrol.dao.PayOrderFailDAO;
import com.xunlei.channel.db.riskcontrol.dao.PayOrderOkDAO;
import com.xunlei.channel.db.riskcontrol.pojo.PayOrder;
import com.xunlei.channel.db.riskcontrol.pojo.PayOrderFail;
import com.xunlei.channel.db.riskcontrol.pojo.PayOrderOk;
import com.xunlei.channel.db.thirdparty.service.ThirdpartyQueryService;
import com.xunlei.channel.riskcontrol.evaluator.constants.DataProviderId;
import com.xunlei.channel.riskcontrol.evaluator.context.EvalContext;
import com.xunlei.channel.riskcontrol.evaluator.data.provider.AbstractProvider;
import com.xunlei.channel.thirdparty.vo.QueryResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OrderQueryDataProvider {
    private static final Logger logger = LoggerFactory.getLogger(OrderQueryDataProvider.class);
    @Autowired
    private PayOrderOkDAO payOrderOkDAO;
    @Autowired
    private PayOrderFailDAO payOrderFailDAO;
    @Autowired
    private PayOrderDAO payOrderDAO;
    @Autowired
    private ThirdpartyQueryService thirdpartyQueryService;

    public OrderQueryDataProvider() {
        new AbstractProvider<QueryResponse>(){

            @Override
            public String getId() {
                return DataProviderId.QUERY_RESPONSE_PAY_ORDER.getValue();
            }

            @Override
            public QueryResponse getData(EvalContext context) throws Exception {
                PayOrder payOrder = OrderQueryDataProvider.this.payOrderDAO.getPayOrder(context.getId());
                if (payOrder == null) {
                    logger.error("payOrder is null for query id :{}", (Object)context.getId());
                    throw new Exception("payOrder is null");
                }
                return OrderQueryDataProvider.this.thirdpartyQueryService.queryOrder(payOrder.getXunleiPayId(), payOrder.getPayType(), payOrder.getOrderAmt(), payOrder.getXunleiId(), payOrder.getUserShow(), payOrder.getPhone(), payOrder.getBizOrderId(), payOrder.getExtraJson(), payOrder.getCreateTime(), payOrder.getOrderGroup(), payOrder.getChannelOrderId());
            }
        };
        new AbstractProvider<QueryResponse>(){

            @Override
            public String getId() {
                return DataProviderId.QUERY_RESPONSE_PAY_ORDER_OK.getValue();
            }

            @Override
            public QueryResponse getData(EvalContext context) throws Exception {
                PayOrderOk payOrderOk = OrderQueryDataProvider.this.payOrderOkDAO.getPayOrderOk(context.getId());
                if (payOrderOk == null) {
                    logger.error("payOrderOk is null for query id :{}", (Object)context.getId());
                    throw new Exception("payOrderOk is null");
                }
                return OrderQueryDataProvider.this.thirdpartyQueryService.queryOrder(payOrderOk.getXunleiPayId(), payOrderOk.getPayType(), payOrderOk.getOrderAmt(), payOrderOk.getXunleiId(), payOrderOk.getUserShow(), payOrderOk.getPhone(), payOrderOk.getBizOrderId(), payOrderOk.getExtraJson(), payOrderOk.getCreateTime(), payOrderOk.getOrderGroup(), payOrderOk.getChannelOrderId());
            }
        };
        new AbstractProvider<QueryResponse>(){

            @Override
            public String getId() {
                return DataProviderId.QUERY_RESPONSE_PAY_ORDER_FAIL.getValue();
            }

            @Override
            public QueryResponse getData(EvalContext context) throws Exception {
                PayOrderFail payOrderFail = OrderQueryDataProvider.this.payOrderFailDAO.getPayOrderFail(context.getId());
                if (payOrderFail == null) {
                    logger.error("payOrderFail is null for query id :{}", (Object)context.getId());
                    throw new Exception("payOrderFail is null");
                }
                return OrderQueryDataProvider.this.thirdpartyQueryService.queryOrder(payOrderFail.getXunleiPayId(), payOrderFail.getPayType(), payOrderFail.getOrderAmt(), payOrderFail.getXunleiId(), payOrderFail.getUserShow(), payOrderFail.getPhone(), payOrderFail.getBizOrderId(), payOrderFail.getExtraJson(), payOrderFail.getCreateTime(), payOrderFail.getOrderGroup(), payOrderFail.getChannelOrderId());
            }
        };
    }
}

