/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.riskcontrol.evaluator.data.provider.impl;

import com.xunlei.channel.db.riskcontrol.dao.PayOrderDAO;
import com.xunlei.channel.db.riskcontrol.dao.PayOrderFailDAO;
import com.xunlei.channel.db.riskcontrol.dao.PayOrderOkDAO;
import com.xunlei.channel.db.riskcontrol.pojo.PayOrder;
import com.xunlei.channel.db.riskcontrol.pojo.PayOrderFail;
import com.xunlei.channel.db.riskcontrol.pojo.PayOrderOk;
import com.xunlei.channel.riskcontrol.evaluator.constants.DataProviderId;
import com.xunlei.channel.riskcontrol.evaluator.context.EvalContext;
import com.xunlei.channel.riskcontrol.evaluator.data.provider.AbstractProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OrderDataProvider {
    @Autowired
    PayOrderDAO payOrderDAO;
    @Autowired
    PayOrderOkDAO payOrderOkDAO;
    @Autowired
    PayOrderFailDAO payOrderFailDAO;

    public OrderDataProvider() {
        new AbstractProvider<PayOrder>(){

            @Override
            public String getId() {
                return DataProviderId.PAY_ORDER.getValue();
            }

            @Override
            public PayOrder getData(EvalContext context) {
                return OrderDataProvider.this.payOrderDAO.getPayOrder(context.getId());
            }
        };
        new AbstractProvider<PayOrderOk>(){

            @Override
            public String getId() {
                return DataProviderId.PAY_ORDER_OK.getValue();
            }

            @Override
            public PayOrderOk getData(EvalContext context) {
                return OrderDataProvider.this.payOrderOkDAO.getPayOrderOk(context.getId());
            }
        };
        new AbstractProvider<PayOrderFail>(){

            @Override
            public String getId() {
                return DataProviderId.PAY_ORDER_FAIL.getValue();
            }

            @Override
            public PayOrderFail getData(EvalContext context) {
                return OrderDataProvider.this.payOrderFailDAO.getPayOrderFail(context.getId());
            }
        };
    }
}

