/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.riskcontrol.web.model;

import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.riskcontrol.http.HttpRequest;
import com.xunlei.riskcontrol.vo.Libclassd;
import com.xunlei.riskcontrol.vo.Rctaskstatus;
import com.xunlei.riskcontrol.web.model.BaseManagedBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.faces.model.SelectItem;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;

public class RctaskstatusManageBean
extends BaseManagedBean {
    private static Logger logger = Logger.getLogger(RctaskstatusManageBean.class);
    private static final String TYPE = "check";
    private Map<String, String> currTypeMap;
    private SelectItem[] currTypeItem;
    private static Map<String, List<Rctaskstatus>> serviceMap;
    private static Map<String, String> runServiceNumMap;
    private static Map<String, String> stopServiceNumMap;
    private static Map<String, String> exceptServiceNumMap;

    public String getQueryTaskState() {
        Sheet<Rctaskstatus> sheet = null;
        String projectno = this.findParameter("sid");
        PagedFliper fliper = this.getFliper();
        try {
            sheet = this.dealReturnData(projectno);
            this.mergePagedDataModel(sheet, new PagedFliper[]{fliper});
        }
        catch (Exception e) {
            logger.debug((Object)("\u53d6\u6570\u5f02\u5e38:" + e.getMessage()));
        }
        return "";
    }

    public Sheet<Rctaskstatus> dealReturnData(String projectno) {
        List<Rctaskstatus> list = this.getServiceMap().get(projectno);
        Sheet<Rctaskstatus> sheet = this.convertData(list);
        return sheet;
    }

    private Sheet<Rctaskstatus> convertData(List<Rctaskstatus> list) {
        if (list == null) {
            return Sheet.EMPTY;
        }
        int rowcount = list.size();
        if (rowcount <= 0) {
            return Sheet.EMPTY;
        }
        return new Sheet(rowcount, list);
    }

    private List<Rctaskstatus> getRctaskstatusList() {
        HttpRequest request = HttpRequest.getInstance();
        String resp = request.execute(TYPE, "");
        List<Rctaskstatus> list = null;
        if (this.isNotEmpty(resp)) {
            JSONObject jsonObj = JSONObject.fromObject((Object)resp);
            JSONArray array = jsonObj.getJSONArray(TYPE);
            list = JSONArray.toList((JSONArray)array, Rctaskstatus.class);
        }
        if (list == null || list.size() == 0) {
            list = new ArrayList<Rctaskstatus>();
            Rctaskstatus rd = new Rctaskstatus();
            rd.setServiceno("");
            rd.setLastEndTime("");
            rd.setLastStartTime("");
            rd.setStatus("");
            list.add(rd);
        }
        return list;
    }

    public String getInit() {
        List<Rctaskstatus> list = this.getRctaskstatusList();
        serviceMap = new HashMap<String, List<Rctaskstatus>>();
        runServiceNumMap = new HashMap<String, String>();
        stopServiceNumMap = new HashMap<String, String>();
        exceptServiceNumMap = new HashMap<String, String>();
        if (list == null || list.size() == 0) {
            return "";
        }
        for (String projectno : this.getCurrTypeMap().keySet()) {
            ArrayList<Rctaskstatus> result = new ArrayList<Rctaskstatus>();
            int runNum = 0;
            int stopNum = 0;
            int exceptNum = 0;
            int i = 0;
            while (i < list.size()) {
                Rctaskstatus data = list.get(i);
                if (data.getServiceno().indexOf(projectno) == 0) {
                    result.add(data);
                    if ("Y".equals(data.getStatus())) {
                        ++runNum;
                    } else if ("S".equals(data.getStatus())) {
                        ++stopNum;
                    } else {
                        ++exceptNum;
                    }
                }
                ++i;
            }
            serviceMap.put(projectno, result);
            runServiceNumMap.put(projectno, String.valueOf(runNum));
            stopServiceNumMap.put(projectno, String.valueOf(stopNum));
            exceptServiceNumMap.put(projectno, String.valueOf(exceptNum));
        }
        return "";
    }

    public Map<String, List<Rctaskstatus>> getServiceMap() {
        return serviceMap;
    }

    public Map<String, String> getRunServiceNumMap() {
        return runServiceNumMap;
    }

    public Map<String, String> getStopServiceNumMap() {
        return stopServiceNumMap;
    }

    public Map<String, String> getExceptServiceNumMap() {
        return exceptServiceNumMap;
    }

    public Map<String, String> getCurrTypeMap() {
        List<Libclassd> list = facade.getLibclassdByClassNo("riskcontrol");
        this.currTypeMap = new Hashtable<String, String>();
        for (Libclassd data : list) {
            this.currTypeMap.put(data.getItemno(), data.getItemname());
        }
        return this.currTypeMap;
    }

    public SelectItem[] getCurrTypeItem() {
        List<Libclassd> list = facade.getLibclassdByClassNo("riskcontrol");
        if (list == null) {
            this.currTypeItem = new SelectItem[0];
        } else {
            this.currTypeItem = new SelectItem[list.size()];
            int i = 0;
            while (i < list.size()) {
                this.currTypeItem[i] = new SelectItem((Object)list.get(i).getItemno(), list.get(i).getItemname());
                ++i;
            }
        }
        return this.currTypeItem;
    }
}

