/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.riskcontrol.web.model;

import com.xunlei.common.util.PagedFliper;
import com.xunlei.riskcontrol.vo.Libclassd;
import com.xunlei.riskcontrol.vo.Rcconfigs;
import com.xunlei.riskcontrol.vo.Rcresultnos;
import com.xunlei.riskcontrol.web.model.BaseManagedBean;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.faces.model.SelectItem;
import org.apache.log4j.Logger;

public class RcresultnosManageBean
extends BaseManagedBean {
    private static Logger logger = Logger.getLogger(RcresultnosManageBean.class);
    private static Map<String, String> currTypeMap;
    private static SelectItem[] currTypeItem;
    private static Map<String, Map<String, String>> rcresultnosMap;

    public String getQueryRcresultnosList() {
        logger.debug((Object)"Start query rcresultnos...");
        String projectno = this.findParameter("sid");
        PagedFliper pagedFliper = this.getFliper();
        pagedFliper.setSortColumn("projectno desc");
        Rcresultnos rcresultnos = (Rcresultnos)this.findBean(Rcresultnos.class, "riskcontrol_rcresultnosquery");
        if (this.isNotEmpty(projectno)) {
            rcresultnos.setProjectno(projectno);
        }
        rcresultnos.setExt1("1");
        this.mergePagedDataModel(facade.queryRcresultnos(rcresultnos, pagedFliper), new PagedFliper[]{pagedFliper});
        return "";
    }

    public String add() {
        logger.debug((Object)"Start add rcresultnos...");
        this.authenticateAdd();
        Rcresultnos rcresultnos = (Rcresultnos)this.findBean(Rcresultnos.class, "riskcontrol_rcresultnos");
        if (this.chectExists(rcresultnos).booleanValue()) {
            return "";
        }
        rcresultnos.setExt1("1");
        try {
            facade.insertRcresultnos(rcresultnos);
            RcresultnosManageBean.refreshResultnos();
        }
        catch (Exception e) {
            logger.debug((Object)("add rcresultnos failed:" + e.getMessage()));
            this.mergeBean(e.getMessage(), "jsmessage");
        }
        this.getQueryRcresultnosList();
        return "";
    }

    public String edit() {
        logger.debug((Object)"Start edit rcresultnos...");
        this.authenticateEdit();
        Rcresultnos rcresultnos = (Rcresultnos)this.findBean(Rcresultnos.class, "riskcontrol_rcresultnos");
        if (this.chectExists(rcresultnos).booleanValue()) {
            return "";
        }
        try {
            facade.updateRcresultnos(rcresultnos);
            RcresultnosManageBean.refreshResultnos();
        }
        catch (Exception e) {
            logger.debug((Object)("Update rcresultnos failed:" + e.getMessage()));
            this.mergeBean(e.getMessage(), "jsmessage");
        }
        this.getQueryRcresultnosList();
        return "";
    }

    public String deleteSome() {
        logger.debug((Object)"Start delete rcresultnos...");
        this.authenticateDel();
        long[] seqids = this.findParamSeqids();
        logger.debug((Object)("ids:" + seqids.toString()));
        try {
            facade.deleteRcresultnosByIds(seqids);
            RcresultnosManageBean.refreshResultnos();
        }
        catch (Exception e) {
            logger.debug((Object)("Delete rcresultnos failed:" + e.getMessage()));
            this.mergeBean(e.getMessage(), "jsmessage");
        }
        this.getQueryRcresultnosList();
        return "";
    }

    private Boolean chectExists(Rcresultnos rcresultnos) {
        Rcresultnos query = new Rcresultnos();
        query.setSerivceno(rcresultnos.getSerivceno());
        query.setResultno(rcresultnos.getResultno());
        Rcresultnos checkdata = facade.findRcresultnos(query);
        logger.debug((Object)("check data:" + checkdata));
        if (checkdata != null && checkdata.getSeqid() != rcresultnos.getSeqid()) {
            this.mergeBean("\u8be5\u914d\u7f6e\u5df2\u7ecf\u5b58\u5728", "jsmessage");
            this.getQueryRcresultnosList();
            return true;
        }
        return false;
    }

    public SelectItem[] getCurrTypeItem() {
        List<Libclassd> list = facade.getLibclassdByClassNo("riskcontrol");
        if (list == null) {
            currTypeItem = new SelectItem[0];
        } else {
            currTypeItem = new SelectItem[list.size()];
            int i = 0;
            while (i < list.size()) {
                RcresultnosManageBean.currTypeItem[i] = new SelectItem((Object)list.get(i).getItemno(), list.get(i).getItemname());
                ++i;
            }
        }
        return currTypeItem;
    }

    public Map<String, String> getCurrTypeMap() {
        List<Libclassd> list = facade.getLibclassdByClassNo("riskcontrol");
        currTypeMap = new Hashtable<String, String>();
        for (Libclassd data : list) {
            currTypeMap.put(data.getItemno(), data.getItemname());
        }
        return currTypeMap;
    }

    public Map<String, Map<String, String>> getRcresultnosMap() {
        if (rcresultnosMap == null) {
            rcresultnosMap = new HashMap<String, Map<String, String>>();
            Rcconfigs rcconfigs = new Rcconfigs();
            List<Rcconfigs> rcconfigsList = facade.getRcconfigsList(rcconfigs);
            for (Rcconfigs data : rcconfigsList) {
                Map<String, String> resultnosMap = this.getMapByServiceno(data.getServiceno());
                rcresultnosMap.put(data.getServiceno(), resultnosMap);
            }
        }
        return rcresultnosMap;
    }

    private Map<String, String> getMapByServiceno(String serviceno) {
        HashMap<String, String> resultnosMap = new HashMap<String, String>();
        Rcresultnos query = new Rcresultnos();
        query.setSerivceno(serviceno);
        List<Rcresultnos> list = facade.queryRcresultnosList(query);
        for (Rcresultnos data : list) {
            resultnosMap.put(data.getResultno(), data.getResultinfo());
        }
        return resultnosMap;
    }

    public static void refreshResultnos() {
        rcresultnosMap = null;
    }
}

