/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.riskcontrol.web.model;

import com.xunlei.common.util.PagedFliper;
import com.xunlei.riskcontrol.vo.Rcnotifiers;
import com.xunlei.riskcontrol.web.model.BaseManagedBean;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.faces.model.SelectItem;
import org.apache.log4j.Logger;

public class RcnotifiersManageBean
extends BaseManagedBean {
    private static Logger logger = Logger.getLogger(RcnotifiersManageBean.class);
    private static Map<String, String> notifiersMap;
    private static SelectItem[] notifiersItem;

    public String getQueryNotifiersList() {
        logger.debug((Object)"Start query notifiers...");
        PagedFliper fliper = this.getFliper();
        fliper.setSortColumnIfEmpty("xingming asc");
        Rcnotifiers rcnotifiers = (Rcnotifiers)this.findBean(Rcnotifiers.class, "riskcontrol_rcnotifiersq");
        logger.debug((Object)("query xingming:" + rcnotifiers.getXingming() + ",name:" + rcnotifiers.getName()));
        this.mergePagedDataModel(facade.queryRcnotifiers(rcnotifiers, fliper), new PagedFliper[]{fliper});
        return "";
    }

    public String delete() {
        return "";
    }

    public String add() {
        logger.debug((Object)"Start add rcnotifier...");
        this.authenticateAdd();
        Rcnotifiers rcnotifiers = (Rcnotifiers)this.findBean(Rcnotifiers.class, "riskcontrol_rcnotifiers");
        logger.debug((Object)("xingming:" + rcnotifiers.getXingming()));
        logger.debug((Object)("name:" + rcnotifiers.getName()));
        logger.debug((Object)("moble:" + rcnotifiers.getMobile()));
        logger.debug((Object)("email:" + rcnotifiers.getEmail()));
        facade.insertRcnotifiers(rcnotifiers);
        this.refreshNotifiers();
        this.getQueryNotifiersList();
        return "";
    }

    public String edit() {
        this.authenticateEdit();
        logger.debug((Object)"Start update...");
        Rcnotifiers rcnotifiers = (Rcnotifiers)this.findBean(Rcnotifiers.class, "riskcontrol_rcnotifiers");
        try {
            facade.updateRcnotifiers(rcnotifiers);
            this.refreshNotifiers();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.getQueryNotifiersList();
        return "";
    }

    public String deleteSome() {
        logger.debug((Object)"Start delete...");
        long[] seqids = this.findParamSeqids();
        logger.debug((Object)("ids:" + seqids.toString()));
        facade.deleteRcnotifiersByIds(seqids);
        this.refreshNotifiers();
        this.getQueryNotifiersList();
        return "";
    }

    public Map<String, String> getNotifiersMap() {
        if (notifiersMap == null) {
            logger.debug((Object)"Start get RcnotifiersMap...");
            Rcnotifiers query = new Rcnotifiers();
            List<Rcnotifiers> rcnotifiersList = facade.getRcnotifiersList(query);
            notifiersMap = new Hashtable<String, String>();
            for (Rcnotifiers data : rcnotifiersList) {
                notifiersMap.put(data.getName(), data.getXingming());
            }
        }
        return notifiersMap;
    }

    public SelectItem[] getNotifiersItem() {
        if (notifiersItem == null) {
            Rcnotifiers query = new Rcnotifiers();
            List<Rcnotifiers> rcnotifiersList = facade.getRcnotifiersList(query);
            if (rcnotifiersList == null) {
                notifiersItem = new SelectItem[0];
            } else {
                notifiersItem = new SelectItem[rcnotifiersList.size()];
                int i = 0;
                while (i < rcnotifiersList.size()) {
                    RcnotifiersManageBean.notifiersItem[i] = new SelectItem((Object)rcnotifiersList.get(i).getName(), rcnotifiersList.get(i).getXingming());
                    ++i;
                }
            }
        }
        return notifiersItem;
    }

    private void refreshNotifiers() {
        notifiersMap = null;
        notifiersItem = null;
    }
}

