/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.riskcontrol.web.model;

import com.xunlei.common.util.DatetimeUtil;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.riskcontrol.facade.IFacade;
import com.xunlei.riskcontrol.http.HttpRequest;
import com.xunlei.riskcontrol.util.RiskcontrolUtil;
import com.xunlei.riskcontrol.vo.Libclassd;
import com.xunlei.riskcontrol.vo.Rcconfigs;
import com.xunlei.riskcontrol.vo.Rcnotifiers;
import com.xunlei.riskcontrol.vo.Rcresultnos;
import com.xunlei.riskcontrol.vo.Rctaskstatus;
import com.xunlei.riskcontrol.web.model.BaseManagedBean;
import com.xunlei.riskcontrol.web.model.RcresultnosManageBean;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.model.SelectItem;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;

public class RcconfigsManageBean
extends BaseManagedBean {
    private static Logger logger = Logger.getLogger(RcconfigsManageBean.class);
    private Map<String, String> currTypeMap;
    private SelectItem[] currTypeItem;
    private Map<String, String> projectSizeMap;
    private Map<String, String> projectUseSizeMap;
    private Map<String, String> serviceMap;
    private Map<String, String> taskstatusMap;
    private Map<String, SelectItem[]> serviceItemMap;
    public static Map<String, SelectItem[]> serviceItemAllMap;
    private static String serviceName;

    public String getQueryRcconfigsList() {
        logger.debug((Object)"Start query rcconfigs list ...");
        String projectno = this.findParameter("sid");
        Rcconfigs rcconfigs = (Rcconfigs)this.findBean(Rcconfigs.class, "riskcontrol_rcconfigsquery");
        if (this.isNotEmpty(projectno)) {
            rcconfigs.setProjectno(projectno);
        }
        rcconfigs.setExt1("1");
        PagedFliper fliper = this.getFliper();
        fliper.setSortColumnIfEmpty("projectno desc");
        this.mergePagedDataModel(facade.queryRcconfigs(rcconfigs, fliper), new PagedFliper[]{fliper});
        this.taskstatusMap = null;
        return "";
    }

    public String add() {
        logger.debug((Object)"Start add rcconfigs ...");
        this.authenticateAdd();
        Rcconfigs rcconfigs = (Rcconfigs)this.findBean(Rcconfigs.class, "riskcontrol_rcconfigs");
        rcconfigs = this.initRcconfigs(rcconfigs);
        try {
            facade.insertRcconfigs(rcconfigs);
            this.doResultnos(rcconfigs.getServiceno(), rcconfigs.getProjectno(), rcconfigs.getMonitortype());
            logger.debug((Object)"Add rcconfigs success");
            this.getRefresh();
            RcresultnosManageBean.refreshResultnos();
        }
        catch (Exception e) {
            logger.debug((Object)"Add rcconfigs failed");
        }
        this.getQueryRcconfigsList();
        return "";
    }

    public String delete() {
        logger.debug((Object)"Start delete rcconfigs ...");
        this.authenticateDel();
        long[] seqids = this.findParamSeqids();
        try {
            this.beforeDeleteRcconfigs(seqids);
            logger.debug((Object)"beforeDeleteRcconfigs dealed success");
            facade.deleteRcconfigsByIds(seqids);
            logger.debug((Object)"delete rcconfigs success");
            this.serviceItemMap = null;
        }
        catch (Exception e) {
            logger.debug((Object)"delete rcconfigs failed");
        }
        this.getQueryRcconfigsList();
        return "";
    }

    private void beforeDeleteRcconfigs(long ... ids) {
        logger.debug((Object)"beforeDeleteRcconfigs ...");
        long[] lArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            long id = lArray[n2];
            String serviceno = facade.findRcconfigsById(id).getServiceno();
            this.stopService(serviceno, "delete");
            this.deleteRcresultnos(serviceno);
            ++n2;
        }
    }

    private void stopService(String serviceno, String delete) {
        if ("Y".equals(this.getTaskstatusMap().get(serviceno))) {
            String resp;
            String type = "stop";
            HttpRequest request = HttpRequest.getInstance();
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("serviceno", serviceno);
            if (this.isNotEmpty(delete)) {
                paramMap.put("type", delete);
            }
            if (this.isNotEmpty(RiskcontrolUtil.getString(resp = request.execute(type, paramMap)))) {
                logger.debug((Object)("service result decription:" + RiskcontrolUtil.getString(resp)));
            }
        }
    }

    public String getService() {
        logger.debug((Object)"Service operation");
        HttpRequest request = HttpRequest.getInstance();
        String type = this.findParameter("type");
        String service = this.findParameter("service");
        logger.debug((Object)("service type:" + type + ",serviceno:" + service));
        try {
            String resp = request.execute(type, service);
            if (this.isNotEmpty(resp)) {
                logger.debug((Object)("service result code:" + resp));
                Rcresultnos data = new Rcresultnos();
                data.setSerivceno(service);
                data.setResultno(resp);
                Rcresultnos resultRcresultnos = facade.findRcresultnos(data);
                if (resultRcresultnos != null) {
                    logger.debug((Object)("service result decription:" + resultRcresultnos.getResultinfo()));
                    this.alertJS(resultRcresultnos.getResultinfo());
                } else if (this.isNotEmpty(RiskcontrolUtil.getString(resp))) {
                    logger.debug((Object)("service result decription:" + RiskcontrolUtil.getString(resp)));
                    this.alertJS(RiskcontrolUtil.getString(resp));
                } else {
                    logger.debug((Object)"No mapped decription");
                    this.alertJS("\u8fd4\u56de\u7801\uff1a" + resp);
                }
            } else {
                logger.debug((Object)"\u64cd\u4f5c\u5f02\u5e38");
                this.alertJS("\u8bbf\u95ee\u670d\u52a1\u88ab\u62d2\u7edd");
            }
        }
        catch (Exception e) {
            logger.debug((Object)("\u64cd\u4f5c\u5f02\u5e38:" + e.getMessage()));
            this.alertJS(e.getMessage());
        }
        this.getQueryRcconfigsList();
        return "";
    }

    private void deleteRcresultnos(String serviceno) {
        logger.debug((Object)("Start delete rcconfigs serviceno:" + serviceno + "=>resultnos ..."));
        Rcresultnos data = new Rcresultnos();
        data.setSerivceno(serviceno);
        List<Rcresultnos> list = facade.queryRcresultnosList(data);
        for (Rcresultnos rcresultnos : list) {
            rcresultnos.setExt1("0");
            facade.updateRcresultnos(rcresultnos);
        }
    }

    public String edit() {
        logger.debug((Object)"Start update rcconfigs ...");
        this.authenticateEdit();
        Rcconfigs rcconfigs = (Rcconfigs)this.findBean(Rcconfigs.class, "riskcontrol_rcconfigs");
        rcconfigs = this.initRcconfigs(rcconfigs);
        try {
            if ("0".equals(rcconfigs.getValidity())) {
                this.stopService(rcconfigs.getServiceno(), "");
            }
            facade.updateRcconfigs(rcconfigs);
            logger.debug((Object)"update rcconfigs success");
            this.getRefresh();
        }
        catch (Exception e) {
            logger.debug((Object)"update rcconfigs failed");
        }
        this.getQueryRcconfigsList();
        return "";
    }

    public String getEmailNotifiers() {
        Rcnotifiers rcnotifiers = new Rcnotifiers();
        rcnotifiers.setEvalidity("1");
        List<Rcnotifiers> rcnotifiersList = facade.getRcnotifiersList(rcnotifiers);
        StringBuffer rcnotifierslist = new StringBuffer();
        if (rcnotifiersList != null && rcnotifiersList.size() > 0) {
            int i = 0;
            while (i < rcnotifiersList.size() - 1) {
                rcnotifierslist.append(rcnotifiersList.get(i).getName()).append("|").append(rcnotifiersList.get(i).getXingming()).append(",");
                ++i;
            }
            rcnotifierslist.append(rcnotifiersList.get(rcnotifiersList.size() - 1).getName()).append("|").append(rcnotifiersList.get(rcnotifiersList.size() - 1).getXingming());
        }
        return rcnotifierslist.toString();
    }

    public String getSmsNotifiers() {
        Rcnotifiers rcnotifiers = new Rcnotifiers();
        rcnotifiers.setMvalidity("1");
        List<Rcnotifiers> rcnotifiersList = facade.getRcnotifiersList(rcnotifiers);
        StringBuffer rcnotifierslist = new StringBuffer();
        if (rcnotifiersList != null && rcnotifiersList.size() > 0) {
            int i = 0;
            while (i < rcnotifiersList.size() - 1) {
                rcnotifierslist.append(rcnotifiersList.get(i).getName()).append("|").append(rcnotifiersList.get(i).getXingming()).append(",");
                ++i;
            }
            rcnotifierslist.append(rcnotifiersList.get(rcnotifiersList.size() - 1).getName()).append("|").append(rcnotifiersList.get(rcnotifiersList.size() - 1).getXingming());
        }
        return rcnotifierslist.toString();
    }

    public SelectItem[] getCurrTypeItem() {
        List<Libclassd> list = facade.getLibclassdByClassNo("riskcontrol");
        if (list == null) {
            this.currTypeItem = new SelectItem[0];
        } else {
            this.currTypeItem = new SelectItem[list.size()];
            int i = 0;
            while (i < list.size()) {
                this.currTypeItem[i] = new SelectItem((Object)list.get(i).getItemno(), list.get(i).getItemname());
                ++i;
            }
        }
        return this.currTypeItem;
    }

    public Map<String, String> getCurrTypeMap() {
        List<Libclassd> list = facade.getLibclassdByClassNo("riskcontrol");
        this.currTypeMap = new Hashtable<String, String>();
        for (Libclassd data : list) {
            this.currTypeMap.put(data.getItemno(), data.getItemname());
        }
        return this.currTypeMap;
    }

    public String getServiceName() {
        serviceName = "";
        String projectno = this.findParameter("riskcontrol_rcconfigs_projectname");
        String nowserviename = this.findParameter("riskcontrol_rcconfigs_servicename");
        logger.debug((Object)("Start getservicenamelist,projectno:" + projectno + ",nowserviename:" + nowserviename));
        if (this.isEmpty(projectno)) {
            projectno = "";
        }
        if (this.isEmpty(nowserviename)) {
            return "";
        }
        SelectItem[] selectItems = this.getServiceItemMap().get(projectno);
        serviceName = this.mergeServiceList(selectItems, nowserviename);
        logger.info((Object)("servicenamelist:" + serviceName));
        this.mergeJsmessage(serviceName);
        return "";
    }

    private String mergeServiceList(SelectItem[] selectItems, String nowserviename) {
        if (selectItems == null || selectItems.length < 1) {
            return "";
        }
        StringBuffer serviceNamebuf = new StringBuffer();
        int len = selectItems.length;
        int j = 0;
        int i = 0;
        while (i < len) {
            if (selectItems[i].getLabel().toLowerCase().indexOf(nowserviename.toLowerCase()) == 0) {
                serviceNamebuf.append(selectItems[i].getLabel()).append(",");
                ++j;
            }
            if (j > 11) break;
            ++i;
        }
        if (j < 11) {
            i = 0;
            while (i < len) {
                if (selectItems[i].getLabel().toLowerCase().indexOf(nowserviename.toLowerCase()) > 0) {
                    serviceNamebuf.append(selectItems[i].getLabel()).append(",");
                    ++j;
                }
                if (j > 11) break;
                ++i;
            }
        }
        if (serviceNamebuf.length() > 0 && serviceNamebuf.charAt(serviceNamebuf.length() - 1) == ',') {
            return serviceNamebuf.substring(0, serviceNamebuf.length() - 1);
        }
        return serviceNamebuf.toString();
    }

    public Map<String, String> getServiceMap() {
        if (this.serviceMap == null) {
            Rcconfigs rcconfigs = new Rcconfigs();
            List<Rcconfigs> rcconfigsList = facade.getRcconfigsList(rcconfigs);
            this.serviceMap = new Hashtable<String, String>();
            for (Rcconfigs data : rcconfigsList) {
                this.serviceMap.put(data.getServiceno(), data.getServicename());
            }
        }
        return this.serviceMap;
    }

    public Map<String, SelectItem[]> getServiceItemMap() {
        if (this.serviceItemMap == null) {
            logger.debug((Object)"Start get service...");
            this.serviceItemMap = new Hashtable<String, SelectItem[]>();
            Set<String> set = this.getCurrTypeMap().keySet();
            for (String key : set) {
                this.serviceItemMap.put(key, this.getServiceItemByProjectno(key, "1"));
            }
            this.serviceItemMap.put("", this.getServiceItemByProjectno("", "1"));
        }
        return this.serviceItemMap;
    }

    public Map<String, SelectItem[]> getServiceItemAllMap() {
        if (serviceItemAllMap == null) {
            logger.debug((Object)"Start get all service...");
            serviceItemAllMap = new Hashtable<String, SelectItem[]>();
            Set<String> set = this.getCurrTypeMap().keySet();
            for (String key : set) {
                serviceItemAllMap.put(key, this.getServiceItemByProjectno(key, ""));
            }
        }
        return serviceItemAllMap;
    }

    public Map<String, String> getProjectSizeMap() {
        if (this.projectSizeMap == null) {
            this.projectSizeMap = new HashMap<String, String>();
            Set<String> set = this.getCurrTypeMap().keySet();
            for (String key : set) {
                this.projectSizeMap.put(key, String.valueOf(this.getServiceItemAllMap().get(key).length));
            }
        }
        return this.projectSizeMap;
    }

    public Map<String, String> getProjectUseSizeMap() {
        if (this.projectUseSizeMap == null) {
            this.projectUseSizeMap = new HashMap<String, String>();
            Set<String> set = this.getCurrTypeMap().keySet();
            for (String key : set) {
                this.projectUseSizeMap.put(key, String.valueOf(this.getServiceItemMap().get(key).length));
            }
        }
        return this.projectUseSizeMap;
    }

    private SelectItem[] getServiceItemByProjectno(String projectno, String inuse) {
        SelectItem[] serviceItem = null;
        logger.debug((Object)("Start get service...+projectno:" + projectno));
        Rcconfigs rcconfigs = new Rcconfigs();
        rcconfigs.setProjectno(projectno);
        rcconfigs.setExt1(inuse);
        List<Rcconfigs> rcconfigsList = facade.getRcconfigsList(rcconfigs);
        if (rcconfigsList == null) {
            serviceItem = new SelectItem[]{};
        } else {
            serviceItem = new SelectItem[rcconfigsList.size()];
            int i = 0;
            while (i < rcconfigsList.size()) {
                serviceItem[i] = new SelectItem((Object)rcconfigsList.get(i).getServiceno(), rcconfigsList.get(i).getServicename());
                ++i;
            }
        }
        return serviceItem;
    }

    public Map<String, String> getTaskstatusMap() {
        if (this.taskstatusMap == null) {
            logger.debug((Object)"Start get task status...");
            this.taskstatusMap = new HashMap<String, String>();
            List<Rctaskstatus> list = this.getRctaskstatusList();
            if (list != null && list.size() > 0) {
                for (Rctaskstatus data : list) {
                    this.taskstatusMap.put(data.getServiceno(), data.getStatus());
                }
            }
        }
        return this.taskstatusMap;
    }

    private List<Rctaskstatus> getRctaskstatusList() {
        String type = "check";
        HttpRequest request = HttpRequest.getInstance();
        String resp = request.execute(type, "");
        List list = null;
        try {
            JSONObject jsonObj = JSONObject.fromObject((Object)resp);
            JSONArray array = jsonObj.getJSONArray(type);
            list = JSONArray.toList((JSONArray)array, Rctaskstatus.class);
        }
        catch (Exception e) {
            logger.debug((Object)("getRctaskstatusList exception:" + e.getMessage()));
        }
        return list;
    }

    private Rcconfigs initRcconfigs(Rcconfigs rcconfigs) {
        rcconfigs.setExt1("1");
        if (this.isEmpty(rcconfigs.getFirstruntime())) {
            rcconfigs.setFirstruntime(DatetimeUtil.timeofnow());
        }
        if (rcconfigs.getDelaytime() == 0) {
            rcconfigs.setDelaytime(60);
        }
        if (rcconfigs.getMonitorinterval() == 0) {
            rcconfigs.setMonitorinterval(60);
        }
        rcconfigs.setMonitorinterval(rcconfigs.getMonitorinterval() * rcconfigs.getMonitorintervaltype());
        rcconfigs.setDelaytime(rcconfigs.getDelaytime() * rcconfigs.getDelaytimetype());
        rcconfigs.setMonitorconfig(RiskcontrolUtil.decodeString(rcconfigs.getMonitorconfig()));
        if (!this.isEmpty(rcconfigs.getIgnoreperiodstarttime()) || !this.isEmpty(rcconfigs.getIgnoreperiodendtime())) {
            rcconfigs.setIgnoreperiod(String.valueOf(this.isEmpty(rcconfigs.getIgnoreperiodstarttime()) ? rcconfigs.getIgnoreperiodendtime() : rcconfigs.getIgnoreperiodstarttime()) + "|" + (this.isEmpty(rcconfigs.getIgnoreperiodendtime()) ? rcconfigs.getIgnoreperiodstarttime() : rcconfigs.getIgnoreperiodendtime()));
        }
        if (!this.isEmpty(rcconfigs.getWorkingtimestart()) || !this.isEmpty(rcconfigs.getWorkingtimeend())) {
            rcconfigs.setWorkingtime(String.valueOf(this.isEmpty(rcconfigs.getWorkingtimestart()) ? rcconfigs.getWorkingtimeend() : rcconfigs.getWorkingtimestart()) + "|" + (this.isEmpty(rcconfigs.getWorkingtimeend()) ? rcconfigs.getWorkingtimestart() : rcconfigs.getWorkingtimeend()));
        }
        if (!this.isEmpty(rcconfigs.getNworkingtimestart()) || !this.isEmpty(rcconfigs.getNworkingtimeend())) {
            rcconfigs.setNworkingtime(String.valueOf(this.isEmpty(rcconfigs.getNworkingtimestart()) ? rcconfigs.getNworkingtimeend() : rcconfigs.getNworkingtimestart()) + "|" + (this.isEmpty(rcconfigs.getNworkingtimeend()) ? rcconfigs.getNworkingtimestart() : rcconfigs.getNworkingtimeend()));
        }
        return rcconfigs;
    }

    private void doResultnos(String serviceno, String projectno, String monitortype) {
        Rcresultnos rcresultno = new Rcresultnos();
        rcresultno.setSerivceno(serviceno);
        Sheet<Rcresultnos> sheet = IFacade.INSTANCE.queryRcresultnos(rcresultno, null);
        if (sheet != null && sheet.getRowcount() > 0) {
            for (Rcresultnos del : sheet.getDatas()) {
                IFacade.INSTANCE.deleteRcresultnos(del);
            }
        }
        this.insertResultnos(serviceno, projectno, "000", "\u6b63\u5e38", "\u6838\u67e5\u6b63\u5e38");
        if ("0".equals(monitortype)) {
            this.insertResultnos(serviceno, projectno, "103", "UnknowHost", "UnknowHost");
            this.insertResultnos(serviceno, projectno, "104", "\u7aef\u53e3\u65e0\u6cd5\u8fde\u63a5", "\u7aef\u53e3\u65e0\u6cd5\u8fde\u63a5");
            this.insertResultnos(serviceno, projectno, "105", "IO\u9519\u8bef", "IO\u9519\u8bef");
        } else if ("1".equals(monitortype)) {
            this.insertResultnos(serviceno, projectno, "100", "\u63a5\u53e3\u8fd4\u56de\u72b6\u6001\u5f02\u5e38", "\u63a5\u53e3\u8fd4\u56de\u72b6\u6001\u5f02\u5e38");
            this.insertResultnos(serviceno, projectno, "101", "\u76d1\u63a7\u63a5\u53e3\u65e0\u8fd4\u56de\u503c", "\u76d1\u63a7\u63a5\u53e3\u65e0\u8fd4\u56de\u503c");
            this.insertResultnos(serviceno, projectno, "102", "\u94fe\u63a5\u5f02\u5e38", "\u94fe\u63a5\u5f02\u5e38");
        }
    }

    private void insertResultnos(String serviceno, String projectno, String resultno, String resultnoinfo, String notifyinfo) {
        Rcresultnos no1 = new Rcresultnos();
        no1.setSerivceno(serviceno);
        no1.setProjectno(projectno);
        no1.setResultno(resultno);
        no1.setResultinfo(resultnoinfo);
        no1.setNotifyinfo(notifyinfo);
        no1.setExt1("1");
        IFacade.INSTANCE.insertRcresultnos(no1);
    }

    public String getRefresh() {
        this.serviceMap = null;
        this.serviceItemMap = null;
        this.projectSizeMap = null;
        this.projectUseSizeMap = null;
        serviceItemAllMap = null;
        return "";
    }
}

