/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.riskcontrol.http;

import com.xunlei.riskcontrol.http.AbstractHttpRequest;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;

public class HttpRequest
extends AbstractHttpRequest {
    private static Logger logger = Logger.getLogger(HttpRequest.class);
    private static String host;
    private static int port;
    public static String charset;

    public static HttpRequest getInstance() {
        if (host == null || port == 0 || charset == null) {
            HttpRequest.init();
        }
        return new HttpRequest();
    }

    private static synchronized boolean init() {
        if (host != null && port != 0 && charset != null) {
            return true;
        }
        ResourceBundle cfg = ResourceBundle.getBundle("riskcontrol");
        host = cfg.getString("servicehost");
        port = Integer.valueOf(cfg.getString("serviceport"));
        charset = cfg.getString("charset");
        return true;
    }

    @Override
    protected String createUrl(String handle, String serviceno) {
        StringBuffer urlBuilder = new StringBuffer();
        urlBuilder.append("http://").append(host).append(":").append(port).append("/").append(handle).append("?").append("serviceno=").append(serviceno);
        return urlBuilder.toString();
    }

    @Override
    protected String createUrl(String handle, Map<String, String> param) {
        StringBuffer urlBuilder = new StringBuffer();
        urlBuilder.append("http://").append(host).append(":").append(port).append("/").append(handle);
        if (param != null & param.size() > 0) {
            urlBuilder.append("?");
            for (String key : param.keySet()) {
                urlBuilder.append(String.valueOf(key) + "=").append(param.get(key)).append("&");
            }
        }
        if (urlBuilder.charAt(urlBuilder.length() - 1) == '&') {
            urlBuilder.deleteCharAt(urlBuilder.length() - 1);
        }
        return urlBuilder.toString();
    }

    @Override
    protected String dealResult(String resp) {
        logger.debug((Object)"deal result...");
        return resp;
    }
}

