/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.riskcontrol.http;

import com.xunlei.riskcontrol.http.IRequest;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class AbstractHttpRequest
implements IRequest {
    private static Logger logger = Logger.getLogger(AbstractHttpRequest.class);

    @Override
    public String execute(String handle, String serviceno) {
        String path = this.createUrl(handle, serviceno);
        String resp = this.getRequest(path);
        return this.dealResult(resp);
    }

    @Override
    public String getUrl(String handle, Map<String, String> param) {
        return this.createUrl(handle, param);
    }

    @Override
    public String execute(String handle, Map<String, String> param) {
        String path = this.getUrl(handle, param);
        String resp = this.getRequest(path);
        return this.dealResult(resp);
    }

    protected String getRequest(String path) {
        logger.debug((Object)("request url:" + path));
        System.out.println("request url:" + path);
        StringBuilder builder = new StringBuilder();
        try {
            URL url = new URL(path);
            HttpURLConnection httpURLConnection = (HttpURLConnection)url.openConnection();
            int state = 0;
            httpURLConnection.setRequestProperty("user-agent", "mozilla/4.0 (compatible;x11;Linux i686)");
            httpURLConnection.setRequestProperty("Connection", "close");
            httpURLConnection.setConnectTimeout(30000);
            httpURLConnection.setReadTimeout(30000);
            httpURLConnection.connect();
            state = httpURLConnection.getResponseCode();
            logger.debug((Object)("State:" + state));
            System.out.println("state:" + state);
            InputStream in = httpURLConnection.getInputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(in, "UTF-8"));
            String line = null;
            while ((line = br.readLine()) != null) {
                builder.append(line);
            }
            in.close();
        }
        catch (Exception e) {
            logger.debug((Object)("Exception:" + e.getMessage()));
            System.err.println(e.getMessage());
        }
        logger.debug((Object)("result:" + builder));
        System.out.println("result:" + builder);
        return builder == null ? null : builder.toString();
    }

    protected abstract String createUrl(String var1, String var2);

    protected abstract String createUrl(String var1, Map<String, String> var2);

    protected abstract String dealResult(String var1);
}

