/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.icbc.check;

import com.sun.net.ssl.HttpsURLConnection;
import com.xunlei.icbc.check.IcbcCheckRet;
import com.xunlei.icbc.prop.ConfigProperties;
import com.xunlei.icbc.prop.PropertiesUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class IcbcCheck {
    protected Logger log = Logger.getLogger(IcbcCheck.class);
    private HostnameVerifier hnv = new HostnameVerifier(){

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    };
    private TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }
    }};

    public String queryOrderStatusIcbcB2C2(String orderId, String orderDate) throws IOException {
        String line;
        String pswd = PropertiesUtil.getProperty(ConfigProperties.IcbcB2CQueryProp, "pfxPassword");
        String pfxPath = PropertiesUtil.getProperty(ConfigProperties.IcbcB2CQueryProp, "pfxPath");
        String hostName = PropertiesUtil.getProperty(ConfigProperties.IcbcB2CQueryProp, "hostName");
        int hostPort = PropertiesUtil.getPropertyToInt(ConfigProperties.IcbcB2CQueryProp, "hostPort");
        int timeout = PropertiesUtil.getPropertyToInt(ConfigProperties.IcbcB2CQueryProp, "timeout");
        String postPath = PropertiesUtil.getProperty(ConfigProperties.IcbcB2CQueryProp, "postPath");
        String APIName = PropertiesUtil.getProperty(ConfigProperties.IcbcB2CQueryProp, "APIName");
        String APIVersion = PropertiesUtil.getProperty(ConfigProperties.IcbcB2CQueryProp, "APIVersion");
        String shopCode = PropertiesUtil.getProperty(ConfigProperties.IcbcB2CQueryProp, "shopCode");
        String shopAccount = PropertiesUtil.getProperty(ConfigProperties.IcbcB2CQueryProp, "shopAccount");
        try {
            SSLSocketFactory factory = null;
            try {
                char[] passphrase = pswd.toCharArray();
                SSLContext ctx = SSLContext.getInstance("TLS");
                KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
                TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
                KeyStore ks = KeyStore.getInstance("PKCS12");
                if (!new File(pfxPath).isFile()) {
                    System.out.println("(ClientAuthA) Missing pfxPath [" + pfxPath + "]");
                    throw new IOException("Missing pfxPath = " + pfxPath);
                }
                ks.load(new FileInputStream(pfxPath), passphrase);
                kmf.init(ks, passphrase);
                tmf.init(ks);
                ctx.init(kmf.getKeyManagers(), this.trustAllCerts, null);
                factory = ctx.getSocketFactory();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IOException(e.getMessage());
            }
            SSLSocket socket = (SSLSocket)factory.createSocket(hostName, hostPort);
            socket.setSoTimeout(timeout);
            socket.startHandshake();
            SSLSession session = socket.getSession();
            if (session == null) {
                System.out.println("(ClientAuthA) Failed to get session context");
                throw new IOException("Failed to get session context");
            }
            InputStream is = null;
            OutputStream os = null;
            try {
                os = socket.getOutputStream();
            }
            catch (IOException e) {
                System.out.println("(ClientAuthA) Error getting output stream");
                throw new IOException("Error getting output stream");
            }
            try {
                is = socket.getInputStream();
            }
            catch (IOException e) {
                System.out.println("(ClientAuthA) Error getting input stream");
                throw new IOException("Error getting input stream");
            }
            String data1 = "APIName=EAPI&APIVersion=001.001.002.001&MerReqData=<?xml  version=\"1.0\" encoding=\"GBK\" standalone=\"no\" ?><ICBCAPI><in><orderNum>201009011804592134062548</orderNum><tranDate>20100901180633</ tranDate><ShopCode>4000EC23585693</ShopCode><ShopAccount>4000023029200124946</ShopAccount></in></ICBCAPI>";
            String merReqData = "<?xml  version=\"1.0\" encoding=\"GBK\" standalone=\"no\" ?><ICBCAPI><in><orderNum>" + orderId + "</orderNum><tranDate>" + orderDate + "</tranDate><ShopCode>" + shopCode + "</ShopCode><ShopAccount>" + shopAccount + "</ShopAccount></in></ICBCAPI>";
            System.out.println(merReqData);
            String data = "APIName=" + APIName + "&APIVersion=" + APIVersion + "&MerReqData=" + URLEncoder.encode(merReqData, "GBK");
            System.out.println(data);
            BufferedWriter wr = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), "GBK"));
            wr.write("POST " + postPath + " HTTP/1.0\r\n");
            wr.write("Content-Length: " + data.length() + "\r\n");
            wr.write("Content-Type: application/x-www-form-urlencoded\r\n");
            wr.write("\r\n");
            wr.write(data);
            wr.flush();
            BufferedReader rd = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            while ((line = rd.readLine()) != null) {
                System.out.println(line);
                line = String.valueOf(line) + "/n" + line;
            }
            wr.close();
            rd.close();
        }
        catch (Exception e) {
            if (e instanceof UnknownHostException) {
                e.printStackTrace(System.out);
                throw new IOException("Unknown Host Exception");
            }
            if (e instanceof IOException) {
                e.printStackTrace(System.out);
                throw new IOException(e.getMessage());
            }
            throw new RuntimeException(e.toString());
        }
        return line;
    }

    public String queryOrderStatusIcbcB2C(String orderId, String orderDate) throws IOException {
        String retXml;
        block18: {
            String APIName = PropertiesUtil.getProperty(ConfigProperties.IcbcB2CQueryProp, "APIName");
            String APIVersion = PropertiesUtil.getProperty(ConfigProperties.IcbcB2CQueryProp, "APIVersion");
            String shopCode = PropertiesUtil.getProperty(ConfigProperties.IcbcB2CQueryProp, "shopCode");
            String shopAccount = PropertiesUtil.getProperty(ConfigProperties.IcbcB2CQueryProp, "shopAccount");
            String keyf = PropertiesUtil.getProperty(ConfigProperties.IcbcB2CQueryProp, "pfxPath");
            String pass = PropertiesUtil.getProperty(ConfigProperties.IcbcB2CQueryProp, "pfxPassword");
            String icbcPayGateWay = PropertiesUtil.getProperty(ConfigProperties.IcbcB2CQueryProp, "icbcPayGateWay");
            SSLSocketFactory ssf = null;
            OutputStreamWriter out = null;
            BufferedReader in = null;
            retXml = "";
            try {
                try {
                    String line;
                    SSLContext ctx = SSLContext.getInstance("TLS");
                    KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
                    TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
                    KeyStore ks = KeyStore.getInstance("PKCS12");
                    ks.load(new FileInputStream(keyf), pass.toCharArray());
                    kmf.init(ks, pass.toCharArray());
                    ctx.init(kmf.getKeyManagers(), this.trustAllCerts, null);
                    System.out.println("load keystore success.");
                    ssf = ctx.getSocketFactory();
                    javax.net.ssl.HttpsURLConnection.setDefaultSSLSocketFactory(ssf);
                    javax.net.ssl.HttpsURLConnection.setDefaultHostnameVerifier(this.hnv);
                    HttpsURLConnection.setDefaultSSLSocketFactory((SSLSocketFactory)ssf);
                    URL realUrl = new URL(icbcPayGateWay);
                    HttpURLConnection conn = (HttpURLConnection)realUrl.openConnection();
                    conn.setRequestProperty("accept", "*/*");
                    conn.setRequestProperty("connection", "Keep-Alive");
                    conn.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)");
                    conn.setDoOutput(true);
                    conn.setDoInput(true);
                    out = new OutputStreamWriter(conn.getOutputStream());
                    String merReqData = "<?xml  version=\"1.0\" encoding=\"GBK\" standalone=\"no\" ?><ICBCAPI><in><orderNum>" + orderId + "</orderNum><tranDate>" + orderDate + "</tranDate><ShopCode>" + shopCode + "</ShopCode><ShopAccount>" + shopAccount + "</ShopAccount></in></ICBCAPI>";
                    this.log.info((Object)("{IcbcCheck}->merReqData:" + merReqData));
                    String data = "APIName=" + APIName + "&APIVersion=" + APIVersion + "&MerReqData=" + URLEncoder.encode(merReqData, "GBK");
                    out.write(data);
                    out.flush();
                    in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                    while ((line = in.readLine()) != null) {
                        retXml = String.valueOf(retXml) + line;
                    }
                }
                catch (Exception e) {
                    this.log.error((Object)"{IcbcCheck}->queryOrderStatusIcbcB2C:Post Data Exception:", (Throwable)e);
                    e.printStackTrace();
                    try {
                        if (out != null) {
                            out.close();
                        }
                        if (in != null) {
                            in.close();
                        }
                        break block18;
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                        this.log.error((Object)"{IcbcCheck}->queryOrderStatusIcbcB2C:Close Stream Exception:", (Throwable)ex);
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (out != null) {
                        out.close();
                    }
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    this.log.error((Object)"{IcbcCheck}->queryOrderStatusIcbcB2C:Close Stream Exception:", (Throwable)ex);
                }
                throw throwable;
            }
            try {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
                this.log.error((Object)"{IcbcCheck}->queryOrderStatusIcbcB2C:Close Stream Exception:", (Throwable)ex);
            }
        }
        retXml = URLDecoder.decode(retXml, "gbk");
        return retXml;
    }

    public IcbcCheckRet getIcbcB2cPayStatus(String orderId, String orderDate, double amount) throws IOException {
        String ret = null;
        String retXml = this.queryOrderStatusIcbcB2C(orderId, orderDate);
        IcbcCheckRet checkrRet = new IcbcCheckRet();
        checkrRet.setOrderId(orderId);
        try {
            Document document = DocumentHelper.parseText((String)retXml);
            Element root = document.getRootElement();
            Element out = root.element("out");
            String tranStat = out.elementText("tranStat");
            if (tranStat.equals("1")) {
                String amountStr = out.elementText("amount");
                checkrRet.setOrderNotifyTime(String.valueOf(orderDate) + out.elementText("tranTime"));
                ret = amount * 100.0 == Double.valueOf(amountStr) ? "tranStat_1" : "tranStat_4";
            } else {
                ret = "tranStat_" + tranStat;
            }
        }
        catch (DocumentException e) {
            ret = "tranStat_" + retXml;
        }
        checkrRet.setOrderTranStat(ret);
        return checkrRet;
    }

    public String isIcbcB2cPayStatusSuccess(String orderId, String orderDate, double amount) throws IOException {
        return this.getIcbcB2cPayStatus(orderId, orderDate, amount).getOrderTranStat();
    }

    public static void main(String[] a) throws IOException {
        String orderId = "110216785663171480";
        String orderDate = "20110216";
        double amount = 20.0;
        IcbcCheck check = new IcbcCheck();
        String str = check.queryOrderStatusIcbcB2C(orderId, orderDate);
        System.out.println(str);
        IcbcCheckRet ret = check.getIcbcB2cPayStatus(orderId, orderDate, amount);
        System.out.println(ret);
    }
}

