/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.util;

import com.xunlei.util.DateStringUtil;
import com.xunlei.util.Log;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;

public class TimebasedIdGenerator {
    public static final long[] DECIMAL_SHIFT_BASE = new long[19];
    private static final Logger log = Log.getLogger();
    public static final int LONG_MAX_LEN = "9223372036854775807".length();
    private static final DecimalFormat percentageFormat = new DecimalFormat("#0.00%");
    private static final Long startMilli;
    private static final long startNano;
    private long _accuracyDividend;
    private long _accuracyMod;
    private long _incrMod;
    private int accuracyLen;
    private int canExpandLen;
    private long collides;
    private long collideTries;
    private final DateStringUtil dsu;
    private final String pattern;
    private long gens;
    private int incrLen;
    private volatile long lastId;
    private final Lock LOCK;
    private long sleepWhenCollide;

    static {
        int i = 0;
        while (i < DECIMAL_SHIFT_BASE.length) {
            TimebasedIdGenerator.DECIMAL_SHIFT_BASE[i] = (long)Math.pow(10.0, i);
            ++i;
        }
        long startMilliTmp = System.currentTimeMillis();
        long bias = startMilliTmp % 1000L;
        if (bias > 0L) {
            try {
                Thread.sleep(999L - bias);
            }
            catch (Exception exception) {
                // empty catch block
            }
            int i2 = 0;
            while ((startMilliTmp = System.currentTimeMillis()) % 1000L != 0L) {
                ++i2;
            }
        }
        startNano = System.nanoTime();
        startMilli = startMilliTmp;
    }

    public static long decimalShift(long num, int len) {
        if (num == 0L) {
            return 0L;
        }
        if (len > 18) {
            throw new IndexOutOfBoundsException("decimalShift overflow,num:" + num + ",len:" + len);
        }
        if (len >= 0) {
            long r;
            if (num > 0L ^ (r = num * DECIMAL_SHIFT_BASE[len]) > 0L) {
                throw new IndexOutOfBoundsException("decimalShift overflow,num:" + num + ",len:" + len + "result:" + r);
            }
            return r;
        }
        return num / DECIMAL_SHIFT_BASE[len];
    }

    public static void main(String[] args) throws InterruptedException {
        TimebasedIdGenerator tt = new TimebasedIdGenerator(4, 2, false);
        long before = System.currentTimeMillis();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < 20000) {
            String t = tt.nextId();
            Integer intt = (Integer)map.get(t);
            if (intt != null) {
                System.out.println(String.valueOf(t) + "   -   " + intt + " - " + i);
                System.out.println(sb);
                System.exit(0);
            }
            map.put(t, i);
            sb.append(i).append("   ").append(t).append("\n");
            ++i;
        }
        log.error("span:{},{}", (Object)(System.currentTimeMillis() - before), (Object)tt);
    }

    public TimebasedIdGenerator(int accuracyLen, boolean fullYearMode) {
        this(accuracyLen, accuracyLen < 6 ? 2 : 0, fullYearMode);
    }

    public TimebasedIdGenerator(int accuracyLen, int incrLen, boolean fullYearMode) {
        block12: {
            this._incrMod = 1L;
            this.canExpandLen = -1;
            this.lastId = -1L;
            this.LOCK = new ReentrantLock();
            this.sleepWhenCollide = 0L;
            int accuracyLen_l = accuracyLen;
            int incrLen_l = incrLen;
            if (incrLen_l < 0) {
                incrLen_l = 0;
            }
            if (accuracyLen_l < 0) {
                accuracyLen_l = 0;
            }
            if (incrLen_l > accuracyLen_l) {
                incrLen_l = 0;
            }
            this.pattern = fullYearMode ? "yyyyMMddHHmmss" : "yyMMddHHmmss";
            this.dsu = DateStringUtil.getInstance(this.pattern);
            try {
                try {
                    this.canExpandLen = LONG_MAX_LEN - this.pattern.length() - accuracyLen_l;
                    this.accuracyLen = accuracyLen_l;
                    this.incrLen = incrLen_l;
                    this._accuracyDividend = DECIMAL_SHIFT_BASE[9 - (accuracyLen_l - incrLen_l)];
                    this._accuracyMod = DECIMAL_SHIFT_BASE[accuracyLen_l - incrLen_l];
                    if (this._accuracyMod < 1000L) {
                        this.sleepWhenCollide = 1000L / this._accuracyMod / 4L;
                    }
                    this._incrMod = DECIMAL_SHIFT_BASE[incrLen_l];
                }
                catch (Exception exception) {
                    if (this.canExpandLen < 0) {
                        log.error("CREATE ERROR:{}", (Object)this);
                        throw new IllegalArgumentException(fullYearMode ? "fullYearMode's accuracyLen range is [0~5],but now accuracyLen:" + accuracyLen_l : "accuracyLen range is [0~7],but now accuracyLen:" + this.accuracyLen);
                    }
                    log.debug("CREATE:{}", (Object)this);
                    break block12;
                }
            }
            catch (Throwable throwable) {
                if (this.canExpandLen < 0) {
                    log.error("CREATE ERROR:{}", (Object)this);
                    throw new IllegalArgumentException(fullYearMode ? "fullYearMode's accuracyLen range is [0~5],but now accuracyLen:" + accuracyLen_l : "accuracyLen range is [0~7],but now accuracyLen:" + this.accuracyLen);
                }
                log.debug("CREATE:{}", (Object)this);
                throw throwable;
            }
            if (this.canExpandLen < 0) {
                log.error("CREATE ERROR:{}", (Object)this);
                throw new IllegalArgumentException(fullYearMode ? "fullYearMode's accuracyLen range is [0~5],but now accuracyLen:" + accuracyLen_l : "accuracyLen range is [0~7],but now accuracyLen:" + this.accuracyLen);
            }
            log.debug("CREATE:{}", (Object)this);
        }
    }

    public long currentTimeMillis() {
        long pastNano = System.nanoTime() - startNano;
        long pastMilli = pastNano / 1000000L;
        return startMilli + pastMilli;
    }

    public int getAccuracyLen() {
        return this.accuracyLen;
    }

    public int getCanExpandLen() {
        return this.canExpandLen;
    }

    public long getCollides() {
        return this.collides;
    }

    public long getCollideTries() {
        return this.collideTries;
    }

    public long getGens() {
        return this.gens;
    }

    public int getIncrLen() {
        return this.incrLen;
    }

    public long getLastId() {
        return this.lastId;
    }

    public long getSleepWhenCollide() {
        return this.sleepWhenCollide;
    }

    public String nextId() {
        return String.valueOf(this.nextLongId());
    }

    public Date parse(String id) {
        int patternLen = this.pattern.length();
        if (id.length() < patternLen) {
            log.warn("id:{},pattern:{},length err", (Object)id, (Object)this.pattern);
            return new Date(0L);
        }
        String date = id.substring(0, patternLen);
        return this.dsu.parse(date);
    }

    public Date parse(long id) {
        return this.parse(String.valueOf(id));
    }

    public long nextLongId() {
        this.LOCK.lock();
        ++this.gens;
        long incr = this.incrLen > 0 ? this.gens % this._incrMod : 0L;
        boolean collide = incr == 0L;
        int collideTimes = 0;
        long newId = 0L;
        try {
            while (true) {
                long pastNano = System.nanoTime() - startNano;
                long pastMilli = pastNano / 1000000L;
                long pastAccuracyTime = pastNano / this._accuracyDividend % this._accuracyMod;
                Date now = new Date(startMilli + pastMilli);
                newId = Long.parseLong(this.dsu.format(now)) * this._accuracyMod * this._incrMod + pastAccuracyTime * this._incrMod;
                if (this.incrLen > 0) {
                    if (collide && this.lastId == newId) {
                        this.sleepWhenCollide();
                        ++collideTimes;
                        continue;
                    }
                    this.lastId = newId;
                    long l = newId + incr;
                    return l;
                }
                if (this.lastId != newId) {
                    this.lastId = newId;
                    long l = newId;
                    return l;
                }
                this.sleepWhenCollide();
                ++collideTimes;
            }
        }
        finally {
            this.LOCK.unlock();
            if (collideTimes > 0) {
                ++this.collides;
                this.collideTries += (long)collideTimes;
            }
        }
    }

    private void sleepWhenCollide() {
        try {
            Thread.sleep(this.sleepWhenCollide);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public long timeBias() {
        return System.currentTimeMillis() - this.currentTimeMillis();
    }

    public String toString() {
        String statInfo = "";
        SimpleDateFormat sdf = (SimpleDateFormat)this.dsu.getDateFormat();
        if (this.gens > 0L) {
            long collides_l = this.collides == 0L ? 1L : this.collides;
            statInfo = MessageFormat.format("[gens:{0},collide(tries/num):{2}/{1}->avg:{3},probability:{4},now:{5},bias:{6}] ", this.gens, collides_l, this.collideTries, this.collideTries / collides_l, percentageFormat.format((double)this.collides / (double)this.gens), sdf.format(this.currentTimeMillis()), this.timeBias());
        }
        return MessageFormat.format("TimebasedIdGenerator {0}[dateFormat={1}, accuracyLen={2}, incrLen={3}, canExpandLen={4}, sleepWhenCollide={5}]", statInfo, sdf.toPattern(), this.accuracyLen, this.incrLen, this.canExpandLen, this.sleepWhenCollide);
    }
}

