/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.util;

import com.xunlei.util.ValueUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public final class StringTools {
    public static boolean isBlank(String str) {
        if (str == null) {
            return true;
        }
        int len = str.length();
        int i = 0;
        while (i < len) {
            char c = str.charAt(i);
            if (c > ' ') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isNotBlank(String str) {
        return !StringTools.isBlank(str);
    }

    public static boolean isNotEmpty(String str) {
        return !StringTools.isEmpty(str);
    }

    public static boolean isNotNumberStr(String str) {
        return !StringTools.isNumberStr(str);
    }

    public static boolean isNumberStr(String str) {
        if (StringTools.isEmpty(str)) {
            return false;
        }
        int len = str.length();
        int i = 0;
        while (i < len) {
            if (!Character.isDigit(str.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void main(String[] args) {
        System.out.println(Arrays.toString((Object[])StringTools.splitAndTrimAsArray("1,2,3,4,5", ",", ValueUtil.REF_ARRAY_LONG)));
        System.out.println(Arrays.toString((long[])StringTools.splitAndTrimAsArray("1,2,3,4,5", ",", Long.TYPE)));
    }

    public static String removeNewLines(String src) {
        if (StringTools.isNotEmpty(src)) {
            return src.replace("\n", "").replace("\r", "");
        }
        return "";
    }

    public static List<String> splitAndTrim(String str, String regex) {
        String[] arr = str.split(regex);
        ArrayList<String> list = new ArrayList<String>(arr.length);
        String[] stringArray = arr;
        int n = arr.length;
        int n2 = 0;
        while (n2 < n) {
            String a = stringArray[n2];
            String add = a.trim();
            if (add.length() > 0) {
                list.add(add);
            }
            ++n2;
        }
        return list;
    }

    public static Collection<String> splitAndTrim(String str, String regex, Collection<String> result) {
        String[] arr;
        String[] stringArray = arr = str.split(regex);
        int n = arr.length;
        int n2 = 0;
        while (n2 < n) {
            String a = stringArray[n2];
            String add = a.trim();
            if (add.length() > 0) {
                result.add(add);
            }
            ++n2;
        }
        return result;
    }

    public static <T> Collection<T> splitAndTrim(String str, String regex, Collection<T> result, Class<T> componentClazz) {
        String[] arr;
        Method method = ValueUtil.getValueOfMethod(componentClazz);
        String[] stringArray = arr = str.split(regex);
        int n = arr.length;
        int n2 = 0;
        while (n2 < n) {
            String a = stringArray[n2];
            String add = a.trim();
            if (add.length() > 0) {
                try {
                    result.add(method.invoke(null, a));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++n2;
        }
        return result;
    }

    public static String[] splitAndTrimAsArray(String str, String regex) {
        return StringTools.splitAndTrim(str, regex).toArray(ValueUtil.REF_ARRAY_STRING);
    }

    public static <T> Object splitAndTrimAsArray(String str, String regex, Class<T> componentClazz) {
        return ValueUtil.toArray(StringTools.splitAndTrim(str, regex, new ArrayList(2), componentClazz), componentClazz);
    }

    public static <T> T[] splitAndTrimAsArray(String str, String regex, T[] refArray) {
        return ValueUtil.toArray(StringTools.splitAndTrim(str, regex, new ArrayList(2), refArray.getClass().getComponentType()), refArray);
    }

    private StringTools() {
    }
}

