/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.springutil;

import com.xunlei.logback.LogFormatFactory;
import com.xunlei.util.EmptyChecker;
import com.xunlei.util.Log;
import com.xunlei.util.StringTools;
import java.io.File;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;

public class MailTemplate {
    private static Logger log = Log.getLogger();
    private static final LogFormatFactory logformat = LogFormatFactory.getInstance("|");
    private String defaultCharset = "GBK";
    private String fromAddress;
    private String fromName = "";
    private int maxRetryTime = 0;
    private long retryIdle = 0L;
    private int retryIdleFactor = 2;
    private JavaMailSender sender;

    public MailTemplate(JavaMailSender sender, String fromAddress) {
        this.sender = sender;
        this.fromAddress = fromAddress;
    }

    public MailTemplate(JavaMailSender sender, String fromAddress, String fromName, String defaultCharset, int maxTryTime, long retryIdle) {
        this.sender = sender;
        this.fromAddress = fromAddress;
        this.fromName = fromName;
        this.defaultCharset = defaultCharset;
        this.maxRetryTime = maxTryTime;
        this.retryIdle = retryIdle;
    }

    private boolean send(String[] to, String subject, String content, boolean isMime, boolean asHtml, File ... attachments) {
        boolean r = false;
        Exception ex = null;
        String result = "OK";
        long idle = this.retryIdle;
        long firstNano = System.nanoTime();
        int i = 0;
        while (i <= this.maxRetryTime) {
            block24: {
                Object[] args;
                try {
                    try {
                        if (EmptyChecker.isEmpty(to)) {
                            throw new NullPointerException("To is null");
                        }
                        if (StringTools.isEmpty(subject)) {
                            throw new NullPointerException("Subject is empty");
                        }
                        if (StringTools.isEmpty(content)) {
                            throw new NullPointerException("Content is empty");
                        }
                        if (isMime) {
                            MimeMessage msg = this.sender.createMimeMessage();
                            MimeMessageHelper mail = new MimeMessageHelper(msg, true, this.defaultCharset);
                            if (StringTools.isEmpty(this.fromName)) {
                                mail.setFrom(this.fromAddress);
                            } else {
                                mail.setFrom(this.fromAddress, this.fromName);
                            }
                            mail.setTo(to);
                            mail.setSubject(subject);
                            mail.setText(content, asHtml);
                            if (attachments != null) {
                                File[] fileArray = attachments;
                                int n = attachments.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    File file = fileArray[n2];
                                    if (!file.getName().startsWith(".svn")) {
                                        mail.addInline(file.getName(), file);
                                    }
                                    ++n2;
                                }
                            }
                            this.sender.send(msg);
                        } else {
                            SimpleMailMessage mail = new SimpleMailMessage();
                            mail.setFrom(this.fromAddress);
                            mail.setTo(to);
                            mail.setSubject(subject);
                            mail.setText(content);
                            this.sender.send(mail);
                        }
                        r = true;
                    }
                    catch (Exception e) {
                        ex = e;
                        result = e.getClass().getSimpleName();
                        if (r) {
                            args = new Object[]{firstNano, result, isMime ? "HTML" : "TEXT", i + 1, to, subject, StringTools.removeNewLines(content)};
                            log.debug(logformat.getFormat(args), args);
                        } else {
                            args = new Object[]{firstNano, result, isMime ? "HTML" : "TEXT", i + 1, to, subject, StringTools.removeNewLines(content), ex == null ? "OK" : StringTools.removeNewLines(ex.getMessage())};
                            log.error(logformat.getFormat(args), args);
                        }
                        break block24;
                    }
                }
                catch (Throwable throwable) {
                    if (r) {
                        args = new Object[]{firstNano, result, isMime ? "HTML" : "TEXT", i + 1, to, subject, StringTools.removeNewLines(content)};
                        log.debug(logformat.getFormat(args), args);
                    } else {
                        args = new Object[]{firstNano, result, isMime ? "HTML" : "TEXT", i + 1, to, subject, StringTools.removeNewLines(content), ex == null ? "OK" : StringTools.removeNewLines(ex.getMessage())};
                        log.error(logformat.getFormat(args), args);
                    }
                    throw throwable;
                }
                if (r) {
                    args = new Object[]{firstNano, result, isMime ? "HTML" : "TEXT", i + 1, to, subject, StringTools.removeNewLines(content)};
                    log.debug(logformat.getFormat(args), args);
                } else {
                    args = new Object[]{firstNano, result, isMime ? "HTML" : "TEXT", i + 1, to, subject, StringTools.removeNewLines(content), ex == null ? "OK" : StringTools.removeNewLines(ex.getMessage())};
                    log.error(logformat.getFormat(args), args);
                }
            }
            if (r || ex instanceof NullPointerException) break;
            try {
                Thread.sleep(idle);
                idle *= (long)this.retryIdleFactor;
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
            ++i;
        }
        return r;
    }

    public boolean sendMimeMail(String to, String subject, String content, File ... attachments) {
        return this.send(new String[]{to}, subject, content, true, true, attachments);
    }

    public boolean sendMimeMail(String[] to, String subject, String content, File ... attachments) {
        return this.send(to, subject, content, true, true, attachments);
    }

    public boolean sendMimeMail(String[] to, String subject, String content, boolean asHtml, File ... attachments) {
        return this.send(to, subject, content, true, asHtml, attachments);
    }

    public boolean sendMimeMail(String to, String subject, String content, boolean asHtml, File ... attachments) {
        return this.send(new String[]{to}, subject, content, true, asHtml, attachments);
    }

    public boolean sendTextMail(String to, String subject, String content) {
        return this.send(new String[]{to}, subject, content, false, false, new File[0]);
    }

    public boolean sendTextMail(String[] to, String subject, String content) {
        return this.send(to, subject, content, false, false, new File[0]);
    }

    public void setDefaultCharset(String defaultCharset) {
        this.defaultCharset = defaultCharset;
    }

    public void setFromAddress(String fromAddress) {
        this.fromAddress = fromAddress;
    }

    public void setFromName(String fromName) {
        this.fromName = fromName;
    }

    public void setMaxRetryTime(int maxRetryTime) {
        this.maxRetryTime = maxRetryTime;
    }

    public void setRetryIdle(long retryIdle) {
        this.retryIdle = retryIdle;
    }

    public void setRetryIdleFactor(int retryIdleFactor) {
        this.retryIdleFactor = retryIdleFactor;
    }

    public void setSender(JavaMailSender sender) {
        this.sender = sender;
    }
}

