/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.logback;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class LogFormatFactory {
    private static final Map<String, LogFormatFactory> LFF_CACHE_MAP = new ConcurrentHashMap<String, LogFormatFactory>(1);
    private String _maxArgsLenFormat = "";
    private List<String> formats = new ArrayList<String>();
    private String split;

    public static LogFormatFactory getInstance(String split) {
        LogFormatFactory lff = LFF_CACHE_MAP.get(split);
        if (lff == null) {
            LogFormatFactory new_lff = new LogFormatFactory(split);
            LogFormatFactory new_lff1 = LFF_CACHE_MAP.put(split, new_lff);
            lff = new_lff1 == null ? new_lff : new_lff1;
        }
        return lff;
    }

    private LogFormatFactory(String split) {
        this.split = split;
    }

    public String getFormat(int argsLen) {
        if (this.formats.size() >= argsLen) {
            return this.formats.get(argsLen - 1);
        }
        StringBuilder tmp = new StringBuilder(this._maxArgsLenFormat);
        int i = this.formats.size();
        while (i < argsLen) {
            this.formats.add(tmp.append("{}").toString());
            tmp.append(this.split);
            ++i;
        }
        this._maxArgsLenFormat = tmp.toString();
        return this.formats.get(argsLen - 1);
    }

    public String getFormat(Object[] args) {
        if (args == null) {
            return "";
        }
        return this.getFormat(args.length);
    }
}

