/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.httptool.login;

import com.xunlei.httptool.login.MainParam;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.proxy.ProxyFactory;
import com.xunlei.proxy.socket.bin.resp.Resp_getusrinfor;
import com.xunlei.spring.Config;
import com.xunlei.util.DateStringUtil;
import com.xunlei.util.Log;
import com.xunlei.util.StringTools;
import com.xunlei.util.codec.DigestUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class LoginBo {
    private static final Logger log = Log.getLogger();
    private static final DateStringUtil dsu = DateStringUtil.getInstance("yyMMddHHmmss");
    private static final int seccodeTimestampLen = dsu.getDateForamtPattern().length();
    private static final int seccodeLen = seccodeTimestampLen + 32;
    @Config(resetable=true)
    private String loginBoDigestKey = "sd8xlnc8";
    @Config
    private String loginBoEmptyIpKey = "iwantip";
    @Config(resetable=true)
    private String testingLoginUsers = "";
    private boolean testing = false;
    private final AtomicInteger testingIndex = new AtomicInteger();
    private List<MainParam> testingLoginUserIdList;

    public MainParam getTestingLoginUserId(XLHttpRequest request) {
        if (this.testing) {
            long reqUserId = request.getParameterLong("userid", -1L);
            if (reqUserId == -1L) {
                return this.testingLoginUserIdList.get(this.testingIndex.getAndIncrement() % this.testingLoginUserIdList.size());
            }
            int reqIsVip = request.getParameterInteger("isvip", 0);
            String sessionId = request.getParameter("sessionid", "req-session-" + reqUserId);
            return new MainParam(reqUserId, sessionId, reqIsVip);
        }
        return null;
    }

    public void setTestingLoginUsers(String testingLoginUsers) {
        this.testingLoginUsers = testingLoginUsers;
        if (StringTools.isEmpty(testingLoginUsers)) {
            this.testing = false;
            this.testingLoginUserIdList = null;
        } else {
            ArrayList<MainParam> testingLoginUserIdListTmp = new ArrayList<MainParam>(2);
            for (String i : StringTools.splitAndTrim(this.testingLoginUsers, ",")) {
                try {
                    String[] item = StringTools.splitAndTrimAsArray(i, ":");
                    long userid = Long.valueOf(item[0]);
                    byte viplevel = item.length > 1 ? Byte.valueOf(item[1]) : (byte)0;
                    testingLoginUserIdListTmp.add(new MainParam(userid, String.valueOf(userid) + "test-session-" + userid, viplevel));
                }
                catch (Exception e) {
                    log.error("", (Throwable)e);
                }
            }
            if (!testingLoginUserIdListTmp.isEmpty()) {
                this.testingLoginUserIdList = testingLoginUserIdListTmp;
                this.testing = true;
                String info = "LoginBo Using testingLoginUserList:" + testingLoginUsers;
                System.err.println(info);
                log.error(info);
            } else {
                this.testing = false;
                this.testingLoginUserIdList = null;
            }
        }
    }

    public String md5(String timeStamp, String userId, String sessionId, String loginIP) {
        String wantMd5Str = String.valueOf(this.loginBoDigestKey) + timeStamp + userId + sessionId + (StringTools.isEmpty(loginIP) ? this.loginBoEmptyIpKey : loginIP);
        return DigestUtils.md5Hex(wantMd5Str);
    }

    public String login(String sessionid, String loginIP) {
        Resp_getusrinfor r = ProxyFactory.getInstance().getLoginProxy().getusrinfor(sessionid);
        if (r.isOk()) {
            String now = dsu.now();
            return String.valueOf(now) + this.md5(now, String.valueOf(r.getUserno()), sessionid, loginIP);
        }
        return null;
    }

    public boolean verify(String usr, String sessionId, String loginIP, String seccode) {
        boolean r = false;
        String newValue = null;
        if (seccode == null || seccode.length() != seccodeLen) {
            return false;
        }
        String now = seccode.substring(0, seccodeTimestampLen);
        String oriValue = seccode.substring(seccodeTimestampLen);
        newValue = this.md5(now, usr, sessionId, loginIP);
        r = newValue.equals(oriValue);
        return r;
    }
}

