/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.httptool.login;

import com.xunlei.httptool.login.LoginBo;
import com.xunlei.httptool.login.MainParam;
import com.xunlei.httptool.util.SessionInvalidError;
import com.xunlei.netty.httpserver.cmd.BaseCmd;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.netty.httpserver.util.AntiDos;
import com.xunlei.netty.httpserver.util.HttpServerConfig;
import com.xunlei.spring.Config;
import com.xunlei.util.Log;
import com.xunlei.util.StringTools;
import org.jboss.netty.handler.codec.http.Cookie;
import org.jboss.netty.handler.codec.http.DefaultCookie;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class DefaultCmd
extends BaseCmd {
    private static final Logger log = Log.getLogger();
    @Config(resetable=true)
    private String antiDos4DefaultCmdGlobal;
    private AntiDos defaultCmdGlobalAntiDos = null;
    @Config(value="front_domain")
    private String domain = "xunlei.com";
    @Autowired
    private LoginBo loginBo;

    protected void addCookie(String key, String value, XLHttpResponse response) {
        DefaultCookie cookie = new DefaultCookie(key, value);
        cookie.setDomain(this.domain);
        cookie.setPath("/");
        response.addCookie((Cookie)cookie);
    }

    public AntiDos getDefaultCmdGlobalAntiDos() {
        return this.defaultCmdGlobalAntiDos;
    }

    protected MainParam getMainParam(XLHttpRequest request, XLHttpResponse response, boolean isSeccode) throws Exception {
        MainParam mainParam;
        block17: {
            String ip;
            String seccode;
            String userid;
            boolean checkSeccode;
            boolean r;
            String sessionid;
            block16: {
                MainParam testMp;
                if (this.defaultCmdGlobalAntiDos != null) {
                    this.defaultCmdGlobalAntiDos.visitAndCheck((Object)request.getRemoteIP());
                }
                if ((testMp = this.loginBo.getTestingLoginUserId(request)) != null) {
                    return testMp;
                }
                sessionid = request.getCookieValue("sessionid");
                r = sessionid != null;
                checkSeccode = false;
                userid = request.getCookieValue("userid");
                seccode = request.getCookieValue("seccode");
                ip = request.getRemoteIP();
                try {
                    if (r) {
                        if (isSeccode) {
                            if (seccode == null) {
                                r = this.validateSessionExternal(sessionid, ip, response);
                            } else {
                                r = true;
                                checkSeccode = true;
                            }
                        } else {
                            checkSeccode = false;
                            r = this.validateSessionExternal(sessionid, ip, response);
                        }
                    }
                    if (r) {
                        if (userid == null) {
                            r = false;
                        } else if (checkSeccode) {
                            r = !this.loginBo.verify(userid, sessionid, ip, seccode) ? this.validateSessionExternal(sessionid, ip, response) : true;
                        }
                    }
                    if (!r) {
                        throw SessionInvalidError.INSTANCE;
                    }
                    mainParam = new MainParam((long)Long.valueOf(userid), sessionid, request);
                    if (!r) break block16;
                }
                catch (Throwable throwable) {
                    if (r) {
                        log.debug("{}|{}|{}|{}|{}|{}", new Object[]{r, sessionid, checkSeccode, seccode, ip, userid});
                    } else {
                        log.error("{}|{}|{}|{}|{}|{}", new Object[]{r, sessionid, checkSeccode, seccode, ip, userid});
                    }
                    throw throwable;
                }
                log.debug("{}|{}|{}|{}|{}|{}", new Object[]{r, sessionid, checkSeccode, seccode, ip, userid});
                break block17;
            }
            log.error("{}|{}|{}|{}|{}|{}", new Object[]{r, sessionid, checkSeccode, seccode, ip, userid});
        }
        return mainParam;
    }

    protected void removeCookie(String key, String value, XLHttpResponse response) {
        DefaultCookie cookie = new DefaultCookie(key, value);
        cookie.setDomain(this.domain);
        cookie.setPath("/");
        cookie.setMaxAge(0);
        response.addCookie((Cookie)cookie);
    }

    public void setAntiDos4DefaultCmdGlobal(String antiDos4DefaultCmdGlobal) {
        this.antiDos4DefaultCmdGlobal = antiDos4DefaultCmdGlobal;
        this.defaultCmdGlobalAntiDos = StringTools.isEmpty(antiDos4DefaultCmdGlobal) ? null : new AntiDos(this.antiDos4DefaultCmdGlobal).initSweeper(0, HttpServerConfig.daemonTaskExecutor);
    }

    private boolean validateSessionExternal(String sessionid, String ip, XLHttpResponse response) {
        String newSeccode = this.loginBo.login(sessionid, ip);
        if (newSeccode != null) {
            this.addCookie("seccode", newSeccode, response);
            return true;
        }
        return false;
    }
}

