/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.command;

import com.xunlei.command.CantAllocateMemErrorHandler;
import com.xunlei.util.DateUtil;
import com.xunlei.util.Log;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.StringTokenizer;
import org.slf4j.Logger;

public class CommandService {
    private static final Logger log = Log.getLogger();
    private static final int OS_TYPE = CommandService.getOsType();
    private StringBuilder _readLineBuffer = new StringBuilder();
    private int _readLineRemainChar = -1;
    protected CmdMode cmdMode = CmdMode.compatible;
    protected CmdMonitor cmdMonitor;
    protected String[] commandArray;
    protected String commandArrayStr;
    protected String createTime = String.valueOf(DateUtil.UNSAFE_DF_DEFAULT.format(new Date())) + " ";
    protected String flushingLine = "";
    protected boolean flushingProcessingLing;
    protected boolean processComplete;
    protected StringBuilder processingDetail = new StringBuilder();
    protected String processingLine;
    protected int processingLineIndex = 0;
    protected boolean success = false;
    private boolean useShell = false;
    public static CantAllocateMemErrorHandler cantAllocateMemErrorHandler;

    private static int getOsType() {
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Linux")) {
            return 0;
        }
        if (osName.startsWith("Windows")) {
            return 1;
        }
        return -1;
    }

    public CommandService(String commandString) {
        this(commandString, true);
    }

    public CommandService(String commandString, boolean useShell) {
        this.useShell = useShell;
        this.commandArray = this.useShell ? this.buildOsSpcArgs(commandString) : this.buildArgs(commandString);
        this.init();
    }

    public CommandService(String[] command) {
        this.commandArray = command;
        this.useShell = false;
        this.init();
    }

    private String[] buildArgs(String commandString) {
        StringTokenizer st = new StringTokenizer(commandString);
        String[] cmdarray = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            cmdarray[i] = st.nextToken();
            ++i;
        }
        return cmdarray;
    }

    private String[] buildOsSpcArgs(String commandString) {
        switch (OS_TYPE) {
            case 0: {
                String[] tmp = new String[]{"/bin/sh", "-c", commandString};
                return tmp;
            }
            case 1: {
                String[] tmp1 = new String[]{"cmd.exe", "/c", commandString};
                return tmp1;
            }
        }
        return null;
    }

    public void checkIsPreparing() {
        if (this.processComplete) {
            throw new IllegalStateException("cmd is already completed:" + this.commandArrayStr);
        }
    }

    public CommandService copy() {
        CommandService cmd = new CommandService(this.commandArray);
        cmd.useShell = this.useShell;
        return cmd;
    }

    public synchronized CommandService execute() {
        block22: {
            this.checkIsPreparing();
            try {
                log.info("RUN CMD:{} ({})", (Object)this.commandArrayStr, (Object)this.cmdMode);
                Process process = new ProcessBuilder(this.commandArray).redirectErrorStream(true).start();
                BufferedReader reader = null;
                try {
                    try {
                        int existCode;
                        if (this.cmdMode != CmdMode.ignore) {
                            InputStreamReader innerIs = new InputStreamReader(process.getInputStream());
                            if (this.cmdMode == CmdMode.simple) {
                                LineNumberReader lr = new LineNumberReader(innerIs);
                                reader = lr;
                                this.cmdMonitor = new CmdMonitor(process, reader);
                                while ((this.processingLine = this.readLineSimple(lr)) != null) {
                                    this.cmdMonitor.updateLastProcessTime();
                                    this.processLine();
                                    if (this.flushingProcessingLing) continue;
                                    ++this.processingLineIndex;
                                }
                            } else {
                                reader = new BufferedReader(innerIs);
                                this.cmdMonitor = new CmdMonitor(process, reader);
                                while ((this.processingLine = this.readLineCompatible(reader)) != null) {
                                    this.cmdMonitor.updateLastProcessTime();
                                    this.processLine();
                                    if (this.flushingProcessingLing) continue;
                                    ++this.processingLineIndex;
                                }
                            }
                        }
                        if (this.success = (existCode = process.waitFor()) == 0) {
                            this.success = true;
                            log.error("RUN CMD OK:{}", (Object)this.commandArrayStr);
                            break block22;
                        }
                        log.error("RUN CMD ERR:{},CODE:{}", (Object)this.commandArrayStr, (Object)existCode);
                    }
                    catch (Exception e) {
                        if (this.isInterrupt()) {
                            this.cmdMonitor.interuptedMsg = "[INTERRUPTED(" + e.getClass().getSimpleName() + ")]";
                            log.error("RUN CMD {}:{}", new Object[]{this.cmdMonitor, this.commandArrayStr, e});
                        } else {
                            log.error("RUN CMD EXCEPTION:{}", (Object)this.commandArrayStr, (Object)e);
                        }
                        this.processComplete = true;
                        if (process == null) break block22;
                        try {
                            reader.close();
                            process.getInputStream().close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        process.destroy();
                    }
                }
                finally {
                    this.processComplete = true;
                    if (process != null) {
                        try {
                            reader.close();
                            process.getInputStream().close();
                        }
                        catch (Exception exception) {}
                        process.destroy();
                    }
                }
            }
            catch (IOException e) {
                log.error("RUN CMD ERR:{}", (Object)this.commandArrayStr, (Object)e);
                String error = e.toString().toLowerCase();
                if (cantAllocateMemErrorHandler == null || !error.contains("cannot allocate memory")) break block22;
                log.error("\n====Waiting to resolve the fatal Exception====\n");
                cantAllocateMemErrorHandler.handleCantAllocateMemError(e);
            }
        }
        return this;
    }

    public CmdMode getCmdMode() {
        return this.cmdMode;
    }

    public String getCommandArrayStr() {
        return this.commandArrayStr;
    }

    public StringBuilder getProcessingDetail() {
        return this.processingDetail;
    }

    private void init() {
        this.commandArrayStr = Arrays.toString(this.commandArray);
        this.success = false;
    }

    public void interrupt(String interuptMsg) {
        if (this.cmdMode == CmdMode.ignore) {
            throw new IllegalAccessError("cant interrupt cmd with [ignore] CmdMode:" + this.commandArrayStr);
        }
        if (this.cmdMonitor == null) {
            throw new IllegalStateException("cmd isnot started:" + this.commandArrayStr);
        }
        this.cmdMonitor.interrupt(interuptMsg);
    }

    public boolean isInterrupt() {
        if (this.cmdMonitor == null) {
            return false;
        }
        return this.cmdMonitor.interrupt;
    }

    public boolean isProcessComplete() {
        return this.processComplete;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public boolean monitor(int tolerantSec) {
        if (this.cmdMonitor == null) {
            return false;
        }
        return this.cmdMonitor.monitor(tolerantSec);
    }

    protected void processLine() {
    }

    private String readLineCompatible(BufferedReader br) throws IOException {
        this._readLineBuffer.delete(0, this._readLineBuffer.length());
        int readingChar = -1;
        int lastChar = -1;
        if (this._readLineRemainChar != -1) {
            lastChar = this._readLineRemainChar;
            if (this._readLineRemainChar != 13 && this._readLineRemainChar != 10) {
                this._readLineBuffer.append((char)this._readLineRemainChar);
            }
        }
        this.flushingProcessingLing = false;
        while ((readingChar = br.read()) != -1) {
            char c = (char)readingChar;
            this.updateLastProcessTimeForChar(c);
            if (readingChar == 10) {
                if (lastChar == 13) {
                    this._readLineRemainChar = -1;
                    break;
                }
                if (lastChar == 10) {
                    this._readLineRemainChar = readingChar;
                    break;
                }
                lastChar = readingChar;
                continue;
            }
            if (readingChar == 13) {
                if (lastChar == 10) {
                    this._readLineRemainChar = -1;
                    break;
                }
                lastChar = readingChar;
                continue;
            }
            if (lastChar == 10) {
                this._readLineRemainChar = readingChar;
                break;
            }
            if (lastChar == 13) {
                this._readLineRemainChar = readingChar;
                this.flushingProcessingLing = true;
                break;
            }
            this._readLineBuffer.append(c);
        }
        if (readingChar == -1) {
            if (this._readLineBuffer.length() == 0) {
                return null;
            }
            this._readLineRemainChar = -1;
        }
        String result = this._readLineBuffer.toString();
        if (!this.flushingProcessingLing) {
            this.processingDetail.append(result).append('\n');
            this.flushingLine = "";
        } else {
            this.flushingLine = result;
        }
        return result;
    }

    private String readLineSimple(LineNumberReader lineReader) throws IOException {
        this.processingLine = lineReader.readLine();
        this.processingDetail.append(this.processingLine).append('\n');
        return this.processingLine;
    }

    public void setCmdMode(CmdMode cmdMode) {
        this.checkIsPreparing();
        this.cmdMode = cmdMode;
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int type) {
        StringBuilder tmp = new StringBuilder();
        if (!this.isProcessComplete()) {
            long span = this.cmdMonitor == null ? 0L : System.currentTimeMillis() - this.cmdMonitor.lastProcessTime;
            tmp.append(">>>(").append(span).append("MS)");
        }
        tmp.append(this.createTime);
        tmp.append(this.commandArrayStr);
        tmp.append('\n');
        if (type == 0) {
            tmp.append((CharSequence)this.processingDetail);
            tmp.append(this.flushingLine).append('\n');
        } else if (type == 1 && this.processingLine != null) {
            tmp.append(this.processingLine).append('\n');
        }
        if (this.cmdMonitor != null) {
            tmp.append(this.cmdMonitor);
        }
        return tmp.toString();
    }

    protected void updateLastProcessTimeForChar(char c) {
    }

    protected static enum CmdMode {
        compatible,
        ignore,
        simple;

    }

    protected class CmdMonitor {
        private boolean interrupt;
        private String interuptedMsg = "";
        private String interuptMsg = "";
        protected long lastProcessTime;
        protected String lastProcessTimeStr;
        private Process process;
        private Thread processThread;
        private BufferedReader reader;

        public CmdMonitor(Process process, BufferedReader reader) {
            this.process = process;
            this.processThread = Thread.currentThread();
            this.lastProcessTime = System.currentTimeMillis();
            this.reader = reader;
            this.lastProcessTimeStr = this.now();
        }

        public void interrupt(String msg) {
            this.interrupt = true;
            this.interuptMsg = MessageFormat.format("EXECUTE {0} - currentTime:{1},lastProcessTime:{2}\n", msg, this.now(), this.lastProcessTimeStr);
            try {
                this.process.getInputStream().close();
            }
            catch (IOException e) {
                log.error("try to close reader encount exception", (Throwable)e);
            }
            try {
                this.process.destroy();
            }
            catch (Exception e) {
                log.error("try to destory process encount exception", (Throwable)e);
            }
        }

        private boolean monitor(int tolerantSec) {
            if (System.currentTimeMillis() - this.lastProcessTime > (long)(tolerantSec * 1000)) {
                this.interrupt("TIMEOUT(>" + tolerantSec + ")");
                return true;
            }
            return false;
        }

        public String now() {
            return DateUtil.UNSAFE_DF_DEFAULT.format(new Date());
        }

        public String toString() {
            return String.valueOf(this.interuptedMsg) + this.interuptMsg;
        }

        public void updateLastProcessTime() {
            this.lastProcessTime = System.currentTimeMillis();
            this.lastProcessTimeStr = this.now();
        }
    }
}

