/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxyutil.yeepay;

import com.xunlei.payproxyutil.result.ResultInfo;
import com.xunlei.payproxyutil.result.SuccessResultInfo;
import com.yeepay.DigestUtil;
import com.yeepay.HttpUtils;
import com.yeepay.QueryResult;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YeepayHelper {
    private static Logger logger = LoggerFactory.getLogger(YeepayHelper.class);
    private static final String QUERY_URL = "https://cha.yeepay.com/app-merchant-proxy/node";
    private static String r1_Code_1 = "1";
    private static String r1_Code_50 = "50";

    public static ResultInfo getQueryResult(String orderId, double factamt, double fareamt) {
        QueryResult queryResult = YeepayHelper.queryByOrder(orderId);
        String failDesp = "";
        String code = "10";
        ResultInfo resultInfo = new ResultInfo();
        resultInfo.setCode(code);
        if (!"SUCCESS".equals(queryResult.getRb_PayStatus())) {
            failDesp = String.valueOf(orderId) + " \u5f02\u5e38\uff0c\u6613\u5b9d\u8fd4\u56de\u652f\u4ed8\u72b6\u6001\u4e3a\uff1a" + queryResult.getRb_PayStatus();
            resultInfo.setMessage(failDesp);
            return resultInfo;
        }
        if (!r1_Code_1.equals(queryResult.getR1_Code())) {
            failDesp = String.valueOf(orderId) + " \u8ba2\u5355\u4e0d\u5b58\u5728.. \u6613\u5b9d\u8fd4\u56de\u67e5\u8be2\u7ed3\u679c\u4e3a\uff1a " + queryResult.getR1_Code();
            resultInfo.setMessage(failDesp);
            return resultInfo;
        }
        if (queryResult.getR3_Amt() == null || Math.abs(Double.parseDouble(queryResult.getR3_Amt()) - (factamt + fareamt)) > 0.1) {
            failDesp = String.valueOf(orderId) + " \u652f\u4ed8\u91d1\u989d\u4e0d\u7b26.. \u6613\u5b9d\u8fd4\u56de\u91d1\u989d=" + queryResult.getR3_Amt() + ", \u5b9e\u9645\u652f\u4ed8 =" + (factamt + fareamt);
            resultInfo.setMessage(failDesp);
            return resultInfo;
        }
        return new SuccessResultInfo();
    }

    private static QueryResult queryByOrder(String orderId) {
        String p2_Order = orderId;
        String query_Cmd = "QueryOrdDetail";
        String p1_MerId = "10000575066";
        String decodeCharset = "GBK";
        String keyValue = "0kkgj86d2doahq8gsfcrcn8zscgv3spci7c20p4zn0n7p4uctgowbtry23u3";
        QueryResult qr = null;
        String hmac = DigestUtil.getHmac((String[])new String[]{query_Cmd, p1_MerId, p2_Order}, (String)keyValue);
        HashMap<String, String> reParams = new HashMap<String, String>();
        reParams.put("p0_Cmd", query_Cmd);
        reParams.put("p1_MerId", p1_MerId);
        reParams.put("p2_Order", p2_Order);
        reParams.put("hmac", hmac);
        List responseStr = null;
        try {
            logger.info("http_request...url:{},params:{}", (Object)QUERY_URL, reParams);
            responseStr = HttpUtils.URLGet((String)QUERY_URL, reParams);
            logger.info("response:{}", (Object)responseStr);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        if (responseStr.size() == 0) {
            logger.error("No response received....");
            throw new RuntimeException("No response.");
        }
        qr = new QueryResult();
        int t = 0;
        while (t < responseStr.size()) {
            String currentResult = (String)responseStr.get(t);
            if (currentResult != null && !currentResult.equals("")) {
                try {
                    URLDecoder.decode(currentResult, decodeCharset);
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e.getMessage());
                }
                int i = currentResult.indexOf("=");
                int j = currentResult.length();
                if (i >= 0) {
                    String sKey = currentResult.substring(0, i);
                    String sValue = currentResult.substring(i + 1);
                    if (sKey.equals("r0_Cmd")) {
                        qr.setR0_Cmd(sValue);
                    } else if (sKey.equals("r1_Code")) {
                        qr.setR1_Code(sValue);
                    } else if (sKey.equals("r2_TrxId")) {
                        qr.setR2_TrxId(sValue);
                    } else if (sKey.equals("r3_Amt")) {
                        qr.setR3_Amt(sValue);
                    } else if (sKey.equals("r4_Cur")) {
                        qr.setR4_Cur(sValue);
                    } else if (sKey.equals("r5_Pid")) {
                        qr.setR5_Pid(sValue);
                    } else if (sKey.equals("r6_Order")) {
                        qr.setR6_Order(sValue);
                    } else if (sKey.equals("r8_MP")) {
                        qr.setR8_MP(sValue);
                    } else if (sKey.equals("rb_PayStatus")) {
                        qr.setRb_PayStatus(sValue);
                    } else if (sKey.equals("rc_RefundCount")) {
                        qr.setRc_RefundCount(sValue);
                    } else if (sKey.equals("rd_RefundAmt")) {
                        qr.setRd_RefundAmt(sValue);
                    } else if (sKey.equals("hmac")) {
                        qr.setHmac(sValue);
                    }
                }
            }
            ++t;
        }
        String r5new = "\u96f7\u70b9";
        String newHmac = "";
        return qr;
    }
}

