/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxyutil.vnetone;

import com.xunlei.encrypt.util.Md5Encrypt;
import com.xunlei.payproxyutil.result.VpayResultInfo;
import com.xunlei.payproxyutil.vnetone.VnetoneUtil;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tempuri.ServiceLocator;

public class ExtVpayHelper {
    private static Logger logger = LoggerFactory.getLogger(ExtVpayHelper.class);
    private static ServiceLocator serviceLocator = new ServiceLocator();

    public static void main(String[] args) {
        try {
            List<VpayResultInfo> res = ExtVpayHelper.queryvcardx("23132", "2011-08-24", "2011-08-25");
            System.out.println("count :" + res.size());
            for (VpayResultInfo v : res) {
                System.out.println("\u8ba2\u5355\u53f7\u4e3a\uff1a" + v.getOrderId());
                System.out.println("\u91d1\u989d\u4e3a\uff1a " + v.getOrderAmt());
            }
            VpayResultInfo resultInfo = ExtVpayHelper.queryorder("23132", "110824418348480202");
            System.out.println("result: " + resultInfo.getVdate());
            VpayResultInfo result = ExtVpayHelper.queryvcard("23132", "990196213935010");
            System.out.println("result :" + result.getOrderAmt());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static VpayResultInfo queryorder(String bizno, String orderid) {
        VpayResultInfo vpayResultInfo = new VpayResultInfo();
        try {
            String spid = "";
            String sppwd = "";
            String md5 = "";
            if (VnetoneUtil.isShopBiz(bizno)) {
                spid = VnetoneUtil.shop_spid;
                sppwd = VnetoneUtil.shop_sppwd;
                md5 = Md5Encrypt.md5(Md5Encrypt.md5(String.valueOf(spid) + sppwd, "GBK"), "GBK");
            } else {
                spid = VnetoneUtil.spid;
                sppwd = VnetoneUtil.sppwd;
                md5 = Md5Encrypt.md5(Md5Encrypt.md5(String.valueOf(spid) + sppwd, "GBK"), "GBK");
            }
            String result = serviceLocator.getServiceSoap().queryorder(spid, md5, orderid);
            logger.info("result: " + result);
            vpayResultInfo = ExtVpayHelper.setVpayResultInfoData(result);
            return vpayResultInfo;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            vpayResultInfo.setCode("11");
            vpayResultInfo.setMessage("unknown error!");
            return vpayResultInfo;
        }
    }

    public static VpayResultInfo queryvcard(String bizno, String vcard) {
        VpayResultInfo vpayResultInfo = new VpayResultInfo();
        try {
            String spid = "";
            String sppwd = "";
            String md5 = "";
            if (VnetoneUtil.isShopBiz(bizno)) {
                spid = VnetoneUtil.shop_spid;
                sppwd = VnetoneUtil.shop_sppwd;
                md5 = Md5Encrypt.md5(Md5Encrypt.md5(String.valueOf(spid) + sppwd, "GBK"), "GBK");
            } else {
                spid = VnetoneUtil.spid;
                sppwd = VnetoneUtil.sppwd;
                md5 = Md5Encrypt.md5(Md5Encrypt.md5(String.valueOf(spid) + sppwd, "GBK"), "GBK");
            }
            String result = serviceLocator.getServiceSoap().queryvcard(spid, md5, vcard);
            logger.info("result: " + result);
            vpayResultInfo = ExtVpayHelper.setVpayResultInfoData(result);
            return vpayResultInfo;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            vpayResultInfo.setCode("11");
            vpayResultInfo.setMessage("unknown error!");
            return vpayResultInfo;
        }
    }

    public static List<VpayResultInfo> queryvcardx(String bizno, String begindate, String enddate) {
        ArrayList<VpayResultInfo> vList = new ArrayList<VpayResultInfo>();
        try {
            String spid = "";
            String sppwd = "";
            String md5 = "";
            if (VnetoneUtil.isShopBiz(bizno)) {
                spid = VnetoneUtil.shop_spid;
                sppwd = VnetoneUtil.shop_sppwd;
                md5 = Md5Encrypt.md5(Md5Encrypt.md5(String.valueOf(spid) + sppwd, "GBK"), "GBK");
            } else {
                spid = VnetoneUtil.spid;
                sppwd = VnetoneUtil.sppwd;
                md5 = Md5Encrypt.md5(Md5Encrypt.md5(String.valueOf(spid) + sppwd, "GBK"), "GBK");
            }
            String result = serviceLocator.getServiceSoap().queryvcardx(spid, md5, begindate, enddate);
            logger.info("result: " + result);
            if (result != null && !result.equals("")) {
                if (result.trim().startsWith("1")) {
                    String[] params;
                    String[] stringArray = params = result.trim().split(";");
                    int n = params.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String str = stringArray[n2];
                        VpayResultInfo vri = ExtVpayHelper.setVpayResultInfoData(str);
                        vList.add(vri);
                        ++n2;
                    }
                } else if (result.trim().equals("2")) {
                    VpayResultInfo v = new VpayResultInfo();
                    v.setCode("2");
                    v.setMessage("wrong md5!");
                    vList.add(v);
                } else if (result.trim().equals("0")) {
                    VpayResultInfo v = new VpayResultInfo();
                    v.setCode("0");
                    v.setMessage("data not found!");
                    vList.add(v);
                } else if (result.trim().equals("3")) {
                    VpayResultInfo v = new VpayResultInfo();
                    v.setCode("3");
                    v.setMessage("date format wrong!");
                    vList.add(v);
                } else if (result.trim().equals("4")) {
                    VpayResultInfo v = new VpayResultInfo();
                    v.setCode("4");
                    v.setMessage("two date time should be in one month!");
                    vList.add(v);
                }
            } else {
                VpayResultInfo v = new VpayResultInfo();
                v.setCode("10");
                v.setMessage("data return null ");
                vList.add(v);
            }
            return vList;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            VpayResultInfo v = new VpayResultInfo();
            v.setCode("11");
            v.setMessage("unknown error!");
            vList.add(v);
            return vList;
        }
    }

    private static VpayResultInfo setVpayResultInfoData(String result) {
        VpayResultInfo vpayResultInfo = new VpayResultInfo();
        if (result != null && !result.equals("")) {
            if (result.trim().startsWith("1")) {
                vpayResultInfo.setCode("1");
                vpayResultInfo.setMessage("success!");
                String[] params = result.trim().split("\\^");
                vpayResultInfo.setOrderAmt(Integer.valueOf(params[1]));
                vpayResultInfo.setOrderId(params[2]);
                vpayResultInfo.setVcard(params[3]);
                vpayResultInfo.setVpassword(params[4]);
                vpayResultInfo.setVdate(params[5]);
            } else if (result.trim().startsWith("2")) {
                vpayResultInfo.setCode("2");
                vpayResultInfo.setMessage("wrong md5!");
            } else if (result.trim().startsWith("0")) {
                vpayResultInfo.setCode("0");
                vpayResultInfo.setMessage("data not found!");
            }
        } else {
            vpayResultInfo.setCode("10");
            vpayResultInfo.setMessage("data return null !");
        }
        return vpayResultInfo;
    }
}

