/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxyutil.qishun;

import com.xunlei.payproxyutil.result.ResultInfo;
import com.xunlei.payproxyutil.result.SuccessResultInfo;
import com.xunlei.payproxyutil.util.PayProxyUtilPropertiesUtil;
import java.net.URL;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QishunHelper {
    private static Logger logger = LoggerFactory.getLogger(QishunHelper.class);

    public static ResultInfo getQueryResult(String productType, String orderid, String balancedate, double payedAmt) throws Exception {
        String date = String.valueOf(balancedate.substring(0, 4)) + balancedate.substring(5, 7);
        String qishunurl = QishunHelper.createQishunUrl(productType, orderid, date);
        QueryResult queryResult = QishunHelper.queryOrder(qishunurl);
        if (queryResult.getRetcode().equalsIgnoreCase("1")) {
            String failDesp = String.valueOf(orderid) + " \u8ba2\u5355\u4e0d\u5b58\u5728,\u9f50\u987a\u8fd4\u56de\u67e5\u8be2\u7ed3\u679c\u4e3a:" + queryResult.getRetcode();
            return new ResultInfo("10", failDesp);
        }
        payedAmt /= 100.0;
        if (Math.abs(queryResult.getRetprice() - payedAmt) > 0.1) {
            String failDesp = String.valueOf(orderid) + " \u8ba2\u5355 \u652f\u4ed8\u91d1\u989d\u4e0d\u7b26,\u9f50\u987a\u8fd4\u56de\u91d1\u989d\u4e3a:" + queryResult.getRetprice() + ",\u5e73\u53f0\u8bb0\u5f55\u91d1\u989d\u4e3a:" + payedAmt;
            return new ResultInfo("10", failDesp);
        }
        return new SuccessResultInfo();
    }

    public static String createQishunUrl(String producttype, String orderid, String date) {
        if (producttype == null || orderid == null || date == null) {
            return null;
        }
        String cpid = PayProxyUtilPropertiesUtil.qishunProductCpidMap.get(producttype);
        if (cpid == null) {
            logger.error("no find producttype:{} cpid, please check monitor.properties", new Object[]{producttype});
            return null;
        }
        return String.format(PayProxyUtilPropertiesUtil.qishu_orderquery_url_format, cpid, orderid, date);
    }

    private static QueryResult queryOrder(String qishunurl) throws Exception {
        URL url = new URL(qishunurl);
        SAXReader reader = new SAXReader();
        Document doc = reader.read(url);
        Element root = doc.getRootElement();
        QueryResult queryResult = new QueryResult();
        String retCode = root.element("ret_code").getText();
        String retPrice = root.element("ret_price").getText();
        queryResult.setRetcode(retCode);
        queryResult.setRetprice(Double.parseDouble(retPrice));
        return queryResult;
    }

    public static void main(String[] args) throws Exception {
        System.out.println(QishunHelper.getQueryResult("2", "110905521679307486", "2011-09-05", 1000.0).toString());
    }

    private static class QueryResult {
        private String ret_code;
        private double ret_price;

        private QueryResult() {
        }

        public String getRetcode() {
            return this.ret_code;
        }

        public void setRetcode(String retCode) {
            this.ret_code = retCode;
        }

        public double getRetprice() {
            return this.ret_price;
        }

        public void setRetprice(double retPrice) {
            this.ret_price = retPrice;
        }
    }
}

